/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    public static final String JNDI_JAVA_NAMESPACE = "java:";
    static final String RESTRICTION_MSG = "JNDI name must start with java: but was ";

    public static Object lookupObject(Context ctx, String name) throws NamingException {
        if (ctx == null) {
            return null;
        }
        if (JNDIUtil.isNullOrEmpty(name)) {
            return null;
        }
        JNDIUtil.jndiNameSecurityCheck(name);
        Object lookup2 = ctx.lookup(name);
        return lookup2;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static void jndiNameSecurityCheck(String name) throws NamingException {
        if (!name.startsWith(JNDI_JAVA_NAMESPACE)) {
            throw new NamingException(RESTRICTION_MSG + name);
        }
    }
}

