/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.descriptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.visitor.SimpleStringBuilderForIATypeVisitor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.DefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ExpectedSchemaNodeToIATypeTranslatorVisitor;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;

public class ScanDefineDescriptor
extends DefineDescriptor {
    private final Dataset dataset;
    private final List<LogicalVariable> primaryKeyVariables;
    private final LogicalVariable metaRecordVariable;
    private final Map<ILogicalExpression, ARecordType> paths;
    private final Map<String, FunctionCallInformation> pathLocations;
    private RootExpectedSchemaNode recordNode;
    private RootExpectedSchemaNode metaNode;
    private ILogicalExpression filterExpression;
    private ILogicalExpression rangeFilterExpression;

    public ScanDefineDescriptor(int scope, Dataset dataset, List<LogicalVariable> primaryKeyVariables, LogicalVariable recordVariable, LogicalVariable metaRecordVariable, ILogicalOperator operator) {
        super(scope, null, recordVariable, operator, null, -1);
        this.primaryKeyVariables = primaryKeyVariables;
        this.metaRecordVariable = metaRecordVariable;
        this.dataset = dataset;
        this.paths = new HashMap<ILogicalExpression, ARecordType>();
        this.pathLocations = new HashMap<String, FunctionCallInformation>();
        this.recordNode = RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE;
        if (this.hasMeta()) {
            this.metaNode = RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE;
        }
    }

    @Override
    public boolean isScanDefinition() {
        return true;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public List<LogicalVariable> getPrimaryKeyVariables() {
        return this.primaryKeyVariables;
    }

    public boolean hasMeta() {
        return this.metaRecordVariable != null;
    }

    public LogicalVariable getMetaRecordVariable() {
        return this.metaRecordVariable;
    }

    public void setRecordNode(RootExpectedSchemaNode recordNode) {
        this.recordNode = recordNode;
    }

    public RootExpectedSchemaNode getRecordNode() {
        return this.recordNode;
    }

    public void setMetaNode(RootExpectedSchemaNode metaNode) {
        this.metaNode = metaNode;
    }

    public RootExpectedSchemaNode getMetaNode() {
        return this.metaNode;
    }

    public Map<ILogicalExpression, ARecordType> getFilterPaths() {
        return this.paths;
    }

    public Map<String, FunctionCallInformation> getPathLocations() {
        return this.pathLocations;
    }

    public void setFilterExpression(ILogicalExpression expression) {
        this.filterExpression = expression;
    }

    public ILogicalExpression getFilterExpression() {
        return this.filterExpression;
    }

    public void setRangeFilterExpression(ILogicalExpression rangeFilterExpression) {
        this.rangeFilterExpression = rangeFilterExpression;
    }

    public ILogicalExpression getRangeFilterExpression() {
        return this.rangeFilterExpression;
    }

    @Override
    public String toString() {
        ExpectedSchemaNodeToIATypeTranslatorVisitor converter = new ExpectedSchemaNodeToIATypeTranslatorVisitor(new HashMap<String, FunctionCallInformation>());
        SimpleStringBuilderForIATypeVisitor typeStringVisitor = new SimpleStringBuilderForIATypeVisitor();
        StringBuilder builder = new StringBuilder();
        AbstractScanOperator scanOp = (AbstractScanOperator)this.operator;
        builder.append("[record: ");
        builder.append(this.getVariable());
        if (this.hasMeta()) {
            builder.append(", meta: ");
            builder.append(this.metaRecordVariable);
        }
        builder.append("] <- ");
        builder.append(scanOp.getOperatorTag());
        builder.append('\n');
        boolean fieldAccessPushdown = DatasetUtil.isFieldAccessPushdownSupported((Dataset)this.dataset);
        if (fieldAccessPushdown && !this.recordNode.isAllFields()) {
            builder.append("project: ");
            ARecordType recordType = (ARecordType)this.recordNode.accept(converter, "root");
            recordType.accept((IATypeVisitor)typeStringVisitor, (Object)builder);
            if (this.hasMeta()) {
                builder.append(" project-meta: ");
                ARecordType metaType = (ARecordType)this.metaNode.accept(converter, "meta");
                metaType.accept((IATypeVisitor)typeStringVisitor, (Object)builder);
            }
        }
        builder.append('\n');
        if (this.filterExpression != null) {
            builder.append("filter: ");
            builder.append(this.filterExpression);
        }
        builder.append('\n');
        if (this.rangeFilterExpression != null) {
            builder.append("range-filter: ");
            builder.append(this.rangeFilterExpression);
        }
        return builder.toString();
    }
}

