/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.base;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.rewriter.base.AlgebricksOptimizationContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public final class AsterixOptimizationContext
extends AlgebricksOptimizationContext {
    private final Int2ObjectOpenHashMap<Set<DataSource>> dataSourceMap;

    public AsterixOptimizationContext(IOptimizationContextFactory optContextFactory, int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer nullableTypeComputer, IConflictingTypeResolver conflictingTypeResovler, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations, IPlanPrettyPrinter prettyPrinter, IWarningCollector warningCollector) {
        super(optContextFactory, varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, nullableTypeComputer, conflictingTypeResovler, physicalOptimizationConfig, clusterLocations, prettyPrinter, warningCollector);
        this.dataSourceMap = new Int2ObjectOpenHashMap();
    }

    public AsterixOptimizationContext(AsterixOptimizationContext from) {
        super((AlgebricksOptimizationContext)from);
        this.dataSourceMap = from.dataSourceMap.clone();
    }

    public void addDataSource(DataSource dataSource) {
        byte type = dataSource.getDatasourceType();
        HashSet<DataSource> set = (HashSet<DataSource>)this.dataSourceMap.get((int)type);
        if (set == null) {
            set = new HashSet<DataSource>();
            this.dataSourceMap.put((int)type, set);
        }
        set.add(dataSource);
    }

    public Int2ObjectMap<Set<DataSource>> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public boolean skipJobCapacityAssignment() {
        if (this.dataSourceMap.isEmpty()) {
            return false;
        }
        for (Int2ObjectMap.Entry me : this.dataSourceMap.int2ObjectEntrySet()) {
            int dataSourceType = me.getIntKey();
            if (dataSourceType != 0 && dataSourceType != 4) {
                return false;
            }
            Predicate<DataSource> dataSourceTest = AsterixOptimizationContext::skipJobCapacityAssignment;
            if (((Set)me.getValue()).stream().allMatch(dataSourceTest)) continue;
            return false;
        }
        return true;
    }

    private static boolean skipJobCapacityAssignment(DataSource ds) {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)ds.getId().getDataverseName()) || AsterixOptimizationContext.isSkipping(ds);
    }

    private static boolean isSkipping(DataSource ds) {
        return ds instanceof FunctionDataSource && ((FunctionDataSource)ds).skipJobCapacityAssignment();
    }
}

