/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import java.util.Objects;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.lazy.AbstractLazyNestedVisitablePointable;
import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.ILazyVisitablePointableVisitor;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractListLazyVisitablePointable
extends AbstractLazyNestedVisitablePointable {
    private final int headerSize;
    private final AbstractLazyVisitablePointable itemVisitablePointable;
    private int numberOfItems;
    protected int currentIndex;
    protected int itemsOffset;

    AbstractListLazyVisitablePointable(boolean tagged, AbstractCollectionType listType) {
        super(tagged, listType.getTypeTag());
        Objects.requireNonNull(listType);
        Objects.requireNonNull(listType.getItemType());
        this.headerSize = (this.isTagged() ? 1 : 0) + 1 + 4;
        this.itemVisitablePointable = this.createVisitablePointable(listType.getItemType());
    }

    @Override
    public final int getNumberOfChildren() {
        return this.numberOfItems;
    }

    @Override
    final void init(byte[] data, int offset, int length) {
        int pointer = this.headerSize + offset;
        this.numberOfItems = AInt32SerializerDeserializer.getInt(data, pointer);
        this.itemsOffset = pointer + 4;
        this.currentIndex = 0;
    }

    @Override
    public AbstractLazyVisitablePointable getChildVisitablePointable() throws HyracksDataException {
        this.itemVisitablePointable.set(this.getChildValue());
        return this.itemVisitablePointable;
    }

    @Override
    public <R, T> R accept(ILazyVisitablePointableVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    abstract AbstractLazyVisitablePointable createVisitablePointable(IAType var1);
}

