/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.application;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.ConfigManager;

public class ConfigManagerApplicationConfig
implements IApplicationConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConfigManager configManager;

    public ConfigManagerApplicationConfig(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public String getString(String section, String key) {
        return (String)this.get(section, key);
    }

    public int getInt(String section, String key) {
        return (Integer)this.get(section, key);
    }

    public long getLong(String section, String key) {
        return (Long)this.get(section, key);
    }

    public Set<String> getSectionNames() {
        return this.configManager.getSectionNames();
    }

    public Set<Section> getSections() {
        return this.configManager.getSections();
    }

    public Set<Section> getSections(Predicate<Section> predicate) {
        return this.configManager.getSections(predicate);
    }

    public Set<String> getKeys(String section) {
        Set<String> keys = this.configManager.getOptionNames(section);
        return keys.isEmpty() ? this.configManager.getExtensionKeys(section) : keys;
    }

    private Object get(String section, String key) {
        IOption option = this.configManager.lookupOption(section, key);
        return option != null ? this.get(option) : this.configManager.getExtensionValue(section, key);
    }

    public Object getStatic(IOption option) {
        return this.configManager.get(option);
    }

    public List<String> getNCNames() {
        return this.configManager.getNodeNames();
    }

    public IOption lookupOption(String sectionName, String propertyName) {
        return this.configManager.lookupOption(sectionName, propertyName);
    }

    public Set<IOption> getOptions() {
        return this.configManager.getOptions();
    }

    public Set<IOption> getOptions(Section section) {
        return this.configManager.getOptions(section);
    }

    public IApplicationConfig getNCEffectiveConfig(String nodeId) {
        return this.configManager.getNodeEffectiveConfig(nodeId);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

