/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyTaskCompleteWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final Task task;

    public NotifyTaskCompleteWork(NodeControllerService ncs, Task task) {
        this.ncs = ncs;
        this.task = task;
    }

    public void run() {
        JobId jobId = this.task.getJoblet().getJobId();
        TaskAttemptId taskAttemptId = this.task.getTaskAttemptId();
        LOGGER.debug("notifying CC of task complete {}:{}", (Object)jobId, (Object)taskAttemptId);
        TaskProfile taskProfile = new TaskProfile(taskAttemptId, this.task.getPartitionSendProfile(), this.task.getStatsCollector(), this.task.getWarnings(), this.task.getWarningCollector().getTotalWarningsCount());
        try {
            this.ncs.getClusterController(this.task.getJobletContext().getJobId().getCcId()).notifyTaskComplete(this.task.getJobletContext().getJobId(), taskAttemptId, this.ncs.getId(), taskProfile);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failed notifying task complete for {}", (Object)taskAttemptId, (Object)e);
        }
        this.task.getJoblet().removeTask(this.task);
    }

    public String toString() {
        return this.getName() + ": [" + this.task.getJoblet().getJobId() + ":" + this.task.getTaskAttemptId() + "]";
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

