/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CreateAdapterStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String adapterName;
    private final Namespace libraryNamespace;
    private final String libraryName;
    private final List<String> externalIdentifier;
    private final boolean ifNotExists;

    public CreateAdapterStatement(Namespace namespace, String adapterName, Namespace libraryNamespace, String libraryName, List<String> externalIdentifier, boolean ifNotExists) {
        this.namespace = namespace;
        this.adapterName = adapterName;
        this.libraryNamespace = libraryNamespace;
        this.libraryName = libraryName;
        this.externalIdentifier = externalIdentifier;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_ADAPTER;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getLibraryDatabaseName() {
        return this.libraryNamespace == null ? null : this.libraryNamespace.getDatabaseName();
    }

    public DataverseName getLibraryDataverseName() {
        return this.libraryNamespace == null ? null : this.libraryNamespace.getDataverseName();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public List<String> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

