/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.cloud;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CloudCachePolicy {
    EAGER("eager"),
    LAZY("lazy");

    private static final Map<String, CloudCachePolicy> partitioningSchemes;
    private final String policyName;

    private CloudCachePolicy(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public static CloudCachePolicy fromName(String policyName) {
        CloudCachePolicy partitioningScheme = partitioningSchemes.get(policyName.toLowerCase());
        if (partitioningScheme == null) {
            throw new IllegalArgumentException("unknown cloud cache policy: " + policyName);
        }
        return partitioningScheme;
    }

    static {
        partitioningSchemes = Collections.unmodifiableMap(Arrays.stream(CloudCachePolicy.values()).collect(Collectors.toMap(CloudCachePolicy::getPolicyName, Function.identity())));
    }
}

