/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.asterix.column.assembler.value.ValueGetterFactory;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.operation.query.QueryColumnTupleProjector;
import org.apache.asterix.column.operation.query.QueryColumnWithMetaMetadata;
import org.apache.asterix.column.tuple.QueryColumnWithMetaTupleReference;
import org.apache.asterix.column.values.reader.ColumnValueReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;

public class QueryColumnWithMetaTupleProjector
extends QueryColumnTupleProjector {
    private final ARecordType metaType;
    private final ARecordType requestedMetaType;

    public QueryColumnWithMetaTupleProjector(ARecordType datasetType, ARecordType metaType, int numberOfPrimaryKeys, ARecordType requestedType, Map<String, FunctionCallInformation> functionCallInfoMap, ARecordType requestedMetaType, IColumnRangeFilterEvaluatorFactory filterEvaluator, IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory, IWarningCollector warningCollector, IHyracksTaskContext context) {
        super(datasetType, numberOfPrimaryKeys, requestedType, functionCallInfoMap, filterEvaluator, columnFilterEvaluatorFactory, warningCollector, context);
        this.metaType = metaType;
        this.requestedMetaType = requestedMetaType;
    }

    @Override
    public IColumnProjectionInfo createProjectionInfo(IValueReference serializedMetadata) throws HyracksDataException {
        try {
            return QueryColumnWithMetaMetadata.create(this.datasetType, this.metaType, this.numberOfPrimaryKeys, serializedMetadata, new ColumnValueReaderFactory(), ValueGetterFactory.INSTANCE, this.requestedType, this.functionCallInfoMap, this.requestedMetaType, this.normalizedFilterEvaluatorFactory, this.columnFilterEvaluatorFactory, this.warningCollector, this.context);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    protected boolean isColumnar(ITupleReference tuple) {
        return tuple instanceof QueryColumnWithMetaTupleReference;
    }

    @Override
    protected IValueReference getAssembledValue(ITupleReference tuple) throws HyracksDataException {
        QueryColumnWithMetaTupleReference columnTuple = (QueryColumnWithMetaTupleReference)tuple;
        return columnTuple.getAssembledValue();
    }

    @Override
    protected void writeMeta(ITupleReference tuple, DataOutput dos, ArrayTupleBuilder tb) throws IOException {
        if (tuple instanceof QueryColumnWithMetaTupleReference) {
            QueryColumnWithMetaTupleReference columnTuple = (QueryColumnWithMetaTupleReference)tuple;
            IValueReference assembledRecord = columnTuple.getMetaAssembledValue();
            dos.write(assembledRecord.getByteArray(), assembledRecord.getStartOffset(), assembledRecord.getLength());
        } else {
            dos.write(tuple.getFieldData(this.numberOfPrimaryKeys + 1), tuple.getFieldStart(this.numberOfPrimaryKeys + 1), tuple.getFieldLength(this.numberOfPrimaryKeys + 1));
        }
        tb.addFieldEndOffset();
    }

    @Override
    protected int getNumberOfTupleFields() {
        return super.getNumberOfTupleFields() + 1;
    }
}

