/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.lazy.accessor;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.lazy.accessor.ILazyAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;

abstract class AbstractLazyAccessor
implements ILazyAccessor {
    protected final ICloudClient cloudClient;
    protected final String bucket;
    protected final IOManager localIoManager;

    AbstractLazyAccessor(ICloudClient cloudClient, String bucket, IOManager localIoManager) {
        this.cloudClient = cloudClient;
        this.bucket = bucket;
        this.localIoManager = localIoManager;
    }

    Set<FileReference> doCloudDelete(FileReference fileReference) throws HyracksDataException {
        Set<FileReference> deletedFiles = Collections.emptySet();
        if (!"storage".equals(IoUtil.getFileNameFromPath((String)fileReference.getAbsolutePath()))) {
            Set<String> paths;
            File localFile = fileReference.getFile();
            if (localFile.exists() && localFile.isFile()) {
                paths = Collections.singleton(fileReference.getRelativePath());
            } else {
                deletedFiles = this.doList(fileReference, IoUtil.NO_OP_FILTER);
                paths = deletedFiles.stream().map(FileReference::getRelativePath).collect(Collectors.toSet());
            }
            this.cloudClient.deleteObjects(this.bucket, paths);
        }
        return deletedFiles;
    }
}

