/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients;

import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.clients.aws.s3.S3ClientConfig;
import org.apache.asterix.cloud.clients.aws.s3.S3CloudClient;
import org.apache.asterix.common.config.CloudProperties;

public class CloudClientProvider {
    private CloudClientProvider() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static ICloudClient getClient(CloudProperties cloudProperties) {
        String storageScheme = cloudProperties.getStorageScheme();
        if ("s3".equalsIgnoreCase(storageScheme)) {
            S3ClientConfig config = S3ClientConfig.of(cloudProperties);
            return new S3CloudClient(config);
        }
        throw new IllegalStateException("unsupported cloud storage scheme: " + storageScheme);
    }
}

