/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.Aggregate;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Unbound;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;

public class UnboundAggregate<T>
extends Aggregate<UnboundTerm<T>>
implements Unbound<T, Expression> {
    UnboundAggregate(Expression.Operation op, UnboundTerm<T> term) {
        super(op, term);
    }

    @Override
    public NamedReference<?> ref() {
        return ((UnboundTerm)this.term()).ref();
    }

    @Override
    public Expression bind(Types.StructType struct, boolean caseSensitive) {
        if (this.op() == Expression.Operation.COUNT_STAR) {
            return new BoundAggregate(this.op(), null);
        }
        Preconditions.checkArgument((this.term() != null ? 1 : 0) != 0, (Object)"Invalid aggregate term: null");
        BoundTerm bound = (BoundTerm)((UnboundTerm)this.term()).bind(struct, caseSensitive);
        return new BoundAggregate(this.op(), bound);
    }
}

