/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.function.Function;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.DependencyFullyQualifiedName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.TypeUtil;

public enum DependencyKind {
    DATASET(dependency -> DatasetUtil.getFullyQualifiedDisplayName(dependency.getDataverseName(), dependency.getSubName1())),
    FUNCTION(dependency -> new FunctionSignature(dependency.getDatabaseName(), dependency.getDataverseName(), dependency.getSubName1(), Integer.parseInt(dependency.getSubName2())).toString()),
    TYPE(dependency -> TypeUtil.getFullyQualifiedDisplayName(dependency.getDataverseName(), dependency.getSubName1())),
    SYNONYM(dependency -> MetadataUtil.getFullyQualifiedDisplayName((DataverseName)dependency.getDataverseName(), (String)dependency.getSubName1()));

    private final Function<DependencyFullyQualifiedName, String> dependencyDisplayNameAccessor;

    private DependencyKind(Function<DependencyFullyQualifiedName, String> dependencyDisplayNameAccessor) {
        this.dependencyDisplayNameAccessor = dependencyDisplayNameAccessor;
    }

    public String getDependencyDisplayName(DependencyFullyQualifiedName dependency) {
        return this.dependencyDisplayNameAccessor.apply(dependency);
    }

    public String toString() {
        return this == DATASET ? IdentifierUtil.dataset() + " (or view)" : this.name().toLowerCase();
    }
}

