/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FeedConnectionEntity {
    private static final FeedConnectionEntity FEED_CONNECTION = new FeedConnectionEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED_CONNECTION, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("FeedName"), List.of("DatasetName")), 0, FeedConnectionEntity.feedConnectionType(), true, new int[]{0, 1, 2}), 3, -1);
    private static final FeedConnectionEntity DB_FEED_CONNECTION = new FeedConnectionEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED_CONNECTION, 5, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("FeedName"), List.of("DatasetName")), 0, FeedConnectionEntity.databaseFeedConnectionType(), true, new int[]{0, 1, 2, 3}), 4, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int feedNameIndex;
    private final int datasetNameIndex;
    private final int outputTypeIndex;
    private final int appliedFunctionsIndex;
    private final int policyIndex;

    private FeedConnectionEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.feedNameIndex = startIndex++;
        this.datasetNameIndex = startIndex++;
        this.outputTypeIndex = startIndex++;
        this.appliedFunctionsIndex = startIndex++;
        this.policyIndex = startIndex++;
    }

    public static FeedConnectionEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FEED_CONNECTION : FEED_CONNECTION;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int feedNameIndex() {
        return this.feedNameIndex;
    }

    public int datasetNameIndex() {
        return this.datasetNameIndex;
    }

    public int outputTypeIndex() {
        return this.outputTypeIndex;
    }

    public int appliedFunctionsIndex() {
        return this.appliedFunctionsIndex;
    }

    public int policyIndex() {
        return this.policyIndex;
    }

    private static ARecordType feedConnectionType() {
        return MetadataRecordTypes.createRecordType("FeedConnectionRecordType", new String[]{"DataverseName", "FeedName", "DatasetName", "ReturnType", "AppliedFunctions", "PolicyName"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)BuiltinType.ASTRING, null), BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseFeedConnectionType() {
        return MetadataRecordTypes.createRecordType("FeedConnectionRecordType", new String[]{"DatabaseName", "DataverseName", "FeedName", "DatasetName", "ReturnType", "AppliedFunctions", "PolicyName"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)BuiltinType.ASTRING, null), BuiltinType.ASTRING}, true);
    }
}

