/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.replication.INcLifecycleCoordinator;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.common.utils.NcLocalCounters;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.application.ConfigManagerApplicationConfig;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ClusterStateManager
implements IClusterStateManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Map<IOption, Object>> ncConfigMap = new HashMap<String, Map<IOption, Object>>();
    private Set<String> pendingRemoval = new HashSet<String>();
    private IClusterManagementWork.ClusterState state = IClusterManagementWork.ClusterState.UNUSABLE;
    private AlgebricksAbsolutePartitionConstraint clusterPartitionConstraint;
    private Map<String, ClusterPartition[]> node2PartitionsMap;
    private SortedMap<Integer, ClusterPartition> clusterPartitions;
    private String currentMetadataNode = null;
    private boolean metadataNodeActive = false;
    private Set<String> failedNodes = new HashSet<String>();
    private Set<String> participantNodes = new HashSet<String>();
    private INcLifecycleCoordinator lifecycleCoordinator;
    private ICcApplicationContext appCtx;
    private ClusterPartition metadataPartition;
    private boolean rebalanceRequired;

    public void setCcAppCtx(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.node2PartitionsMap = appCtx.getMetadataProperties().getNodePartitions();
        this.clusterPartitions = appCtx.getMetadataProperties().getClusterPartitions();
        this.currentMetadataNode = appCtx.getMetadataProperties().getMetadataNodeName();
        this.metadataPartition = this.node2PartitionsMap.get(this.currentMetadataNode)[0];
        this.lifecycleCoordinator = appCtx.getNcLifecycleCoordinator();
        this.lifecycleCoordinator.bindTo((IClusterStateManager)this);
    }

    public synchronized void notifyNodeFailure(String nodeId) throws HyracksException {
        LOGGER.info("Removing configuration parameters for node id {}", (Object)nodeId);
        this.failedNodes.add(nodeId);
        InetSocketAddress replicaAddress = ClusterStateManager.getReplicaLocation(this, nodeId);
        this.ncConfigMap.remove(nodeId);
        this.pendingRemoval.remove(nodeId);
        this.lifecycleCoordinator.notifyNodeFailure(nodeId, replicaAddress);
    }

    public synchronized void notifyNodeJoin(String nodeId, Map<IOption, Object> configuration) throws HyracksException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering configuration parameters for node id " + nodeId);
        }
        this.failedNodes.remove(nodeId);
        this.ncConfigMap.put(nodeId, configuration);
        this.updateNodeConfig(nodeId, configuration);
        this.lifecycleCoordinator.notifyNodeJoin(nodeId);
    }

    public synchronized void setState(IClusterManagementWork.ClusterState state) {
        if (this.state == state) {
            LOGGER.info("ignoring update to same cluster state of " + this.state);
            return;
        }
        LOGGER.info("updating cluster state from " + this.state + " to " + state.name());
        this.state = state;
        this.appCtx.getGlobalRecoveryManager().notifyStateChange(state);
        LOGGER.info("Cluster State is now " + state.name());
        this.notifyAll();
    }

    public synchronized void updateMetadataNode(String nodeId, boolean active) {
        this.currentMetadataNode = nodeId;
        this.metadataNodeActive = active;
        if (active) {
            this.metadataPartition.setActiveNodeId(this.currentMetadataNode);
            LOGGER.info("Metadata node {} is now active", (Object)this.currentMetadataNode);
        }
        this.notifyAll();
    }

    public synchronized void updateNodeState(String nodeId, boolean active, NcLocalCounters localCounters, Set<Integer> activePartitions) {
        if (active) {
            this.updateClusterCounters(nodeId, localCounters);
            this.participantNodes.add(nodeId);
            this.activateNodePartitions(nodeId, activePartitions);
        } else {
            this.participantNodes.remove(nodeId);
            this.deactivateNodePartitions(nodeId);
        }
    }

    public synchronized void updateClusterPartition(int partitionNum, String activeNode, boolean active) {
        ClusterPartition clusterPartition = (ClusterPartition)this.clusterPartitions.get(partitionNum);
        if (clusterPartition != null) {
            clusterPartition.setActive(active);
            if (active) {
                clusterPartition.setActiveNodeId(activeNode);
                clusterPartition.setPendingActivation(false);
            }
            this.notifyAll();
        }
    }

    public synchronized void refreshState() throws HyracksDataException {
        if (this.state == IClusterManagementWork.ClusterState.SHUTTING_DOWN) {
            LOGGER.info("Not refreshing final state {}", (Object)this.state);
            return;
        }
        this.resetClusterPartitionConstraint();
        if (this.clusterPartitions.isEmpty() || this.clusterPartitions.values().stream().allMatch(ClusterPartition::isPendingActivation)) {
            LOGGER.info("Cluster does not have any registered partitions");
            this.setState(IClusterManagementWork.ClusterState.UNUSABLE);
            return;
        }
        if (this.clusterPartitions.values().stream().anyMatch(p -> !p.isActive() && !p.isPendingActivation())) {
            this.setState(IClusterManagementWork.ClusterState.UNUSABLE);
            return;
        }
        if (!this.metadataNodeActive) {
            this.setState(IClusterManagementWork.ClusterState.PENDING);
            return;
        }
        if (this.state != IClusterManagementWork.ClusterState.ACTIVE && this.state != IClusterManagementWork.ClusterState.RECOVERING) {
            this.setState(IClusterManagementWork.ClusterState.PENDING);
        }
        this.appCtx.getMetadataBootstrap().init();
        if (!this.appCtx.getGlobalRecoveryManager().isRecoveryCompleted()) {
            this.setState(IClusterManagementWork.ClusterState.RECOVERING);
            this.appCtx.getGlobalRecoveryManager().startGlobalRecovery(this.appCtx);
            return;
        }
        if (this.rebalanceRequired) {
            this.setState(IClusterManagementWork.ClusterState.REBALANCE_REQUIRED);
            return;
        }
        this.setState(IClusterManagementWork.ClusterState.ACTIVE);
    }

    public synchronized void waitForState(IClusterManagementWork.ClusterState waitForState) throws InterruptedException {
        while (this.state != waitForState) {
            this.wait();
        }
    }

    public boolean waitForState(IClusterManagementWork.ClusterState waitForState, long timeout, TimeUnit unit) throws InterruptedException {
        return this.waitForState(arg_0 -> waitForState.equals(arg_0), timeout, unit) != null;
    }

    public synchronized IClusterManagementWork.ClusterState waitForState(Predicate<IClusterManagementWork.ClusterState> predicate, long timeout, TimeUnit unit) throws InterruptedException {
        long startMillis = System.currentTimeMillis();
        long endMillis = startMillis + unit.toMillis(timeout);
        while (!predicate.test(this.state)) {
            long millisToSleep = endMillis - System.currentTimeMillis();
            if (millisToSleep > 0L) {
                this.wait(millisToSleep);
                continue;
            }
            return null;
        }
        return this.state;
    }

    public synchronized String[] getIODevices(String nodeId) {
        Map<IOption, Object> ncConfig = this.ncConfigMap.get(nodeId);
        if (ncConfig == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Configuration parameters for nodeId " + nodeId + " not found. The node has not joined yet or has left.");
            }
            return new String[0];
        }
        return (String[])ncConfig.get(NCConfig.Option.IODEVICES);
    }

    public synchronized IClusterManagementWork.ClusterState getState() {
        return this.state;
    }

    public synchronized Set<String> getParticipantNodes() {
        return new HashSet<String>(this.participantNodes);
    }

    public synchronized Set<String> getFailedNodes() {
        return new HashSet<String>(this.failedNodes);
    }

    public synchronized Set<String> getNodes() {
        HashSet<String> nodes = new HashSet<String>(this.participantNodes);
        nodes.addAll(this.failedNodes);
        return nodes;
    }

    public synchronized Set<String> getParticipantNodes(boolean excludePendingRemoval) {
        Set<String> participantNodesCopy = this.getParticipantNodes();
        if (excludePendingRemoval) {
            participantNodesCopy.removeAll(this.pendingRemoval);
        }
        return participantNodesCopy;
    }

    public synchronized AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        if (this.clusterPartitionConstraint == null) {
            this.resetClusterPartitionConstraint();
        }
        return this.clusterPartitionConstraint;
    }

    private synchronized void resetClusterPartitionConstraint() {
        ArrayList<String> clusterActiveLocations = new ArrayList<String>();
        for (ClusterPartition p : this.clusterPartitions.values()) {
            if (!p.isActive()) continue;
            clusterActiveLocations.add(p.getActiveNodeId());
        }
        clusterActiveLocations.removeAll(this.pendingRemoval);
        this.clusterPartitionConstraint = new AlgebricksAbsolutePartitionConstraint(clusterActiveLocations.toArray(new String[0]));
    }

    public synchronized boolean isClusterActive() {
        return this.state == IClusterManagementWork.ClusterState.ACTIVE;
    }

    public synchronized int getNumberOfNodes() {
        return this.participantNodes.size();
    }

    public synchronized ClusterPartition[] getNodePartitions(String nodeId) {
        return this.node2PartitionsMap.get(nodeId);
    }

    public synchronized int getNodePartitionsCount(String node) {
        if (this.node2PartitionsMap.containsKey(node)) {
            return this.node2PartitionsMap.get(node).length;
        }
        return 0;
    }

    public synchronized ClusterPartition[] getClusterPartitons() {
        return this.clusterPartitions.values().toArray(new ClusterPartition[0]);
    }

    public synchronized boolean isMetadataNodeActive() {
        return this.metadataNodeActive;
    }

    public synchronized ObjectNode getClusterStateDescription() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode stateDescription = om.createObjectNode();
        stateDescription.put("state", this.state.name());
        stateDescription.put("metadata_node", this.currentMetadataNode);
        ArrayNode ncs = om.createArrayNode();
        stateDescription.set("ncs", (JsonNode)ncs);
        for (String node : new TreeSet<String>(this.node2PartitionsMap.keySet())) {
            ObjectNode nodeJSON = om.createObjectNode();
            nodeJSON.put("node_id", node);
            boolean allActive = true;
            boolean anyActive = false;
            HashSet partitions = new HashSet();
            if (this.node2PartitionsMap.containsKey(node)) {
                for (ClusterPartition part : this.node2PartitionsMap.get(node)) {
                    HashMap<String, Object> partition = new HashMap<String, Object>();
                    partition.put("partition_id", "partition_" + part.getPartitionId());
                    partition.put("active", part.isActive());
                    partitions.add(partition);
                    boolean bl = allActive = allActive && part.isActive();
                    if (!allActive) continue;
                    anyActive = true;
                }
            }
            nodeJSON.put("state", this.failedNodes.contains(node) ? "FAILED" : (allActive && anyActive ? "ACTIVE" : (anyActive ? "PARTIALLY_ACTIVE" : "INACTIVE")));
            nodeJSON.putPOJO("partitions", partitions);
            ncs.add((JsonNode)nodeJSON);
        }
        return stateDescription;
    }

    public synchronized ObjectNode getClusterStateSummary() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode stateDescription = om.createObjectNode();
        stateDescription.put("state", this.state.name());
        stateDescription.putPOJO("metadata_node", (Object)this.currentMetadataNode);
        stateDescription.putPOJO("partitions", this.clusterPartitions);
        return stateDescription;
    }

    public Map<String, Map<IOption, Object>> getNcConfiguration() {
        return Collections.unmodifiableMap(this.ncConfigMap);
    }

    public String getCurrentMetadataNodeId() {
        return this.currentMetadataNode;
    }

    public synchronized void registerNodePartitions(String nodeId, ClusterPartition[] nodePartitions) throws AlgebricksException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering node partitions for node " + nodeId + ": " + Arrays.toString(nodePartitions));
        }
        for (ClusterPartition nodePartition : nodePartitions) {
            if (!this.clusterPartitions.containsKey(nodePartition.getPartitionId())) continue;
            throw AsterixException.create((ErrorCode)ErrorCode.DUPLICATE_PARTITION_ID, (Serializable[])new Serializable[]{Integer.valueOf(nodePartition.getPartitionId()), nodeId, ((ClusterPartition)this.clusterPartitions.get(nodePartition.getPartitionId())).getNodeId()});
        }
        for (ClusterPartition nodePartition : nodePartitions) {
            nodePartition.setPendingActivation(true);
            this.clusterPartitions.put(nodePartition.getPartitionId(), nodePartition);
        }
        this.node2PartitionsMap.put(nodeId, nodePartitions);
    }

    public synchronized void deregisterNodePartitions(String nodeId) throws HyracksDataException {
        ClusterPartition[] nodePartitions = this.node2PartitionsMap.remove(nodeId);
        if (nodePartitions == null) {
            LOGGER.info("deregisterNodePartitions unknown node {} (already removed?)", (Object)nodeId);
        } else {
            LOGGER.info("deregisterNodePartitions for node {}: {}", new Supplier[]{() -> nodeId, () -> Arrays.toString(nodePartitions)});
            for (ClusterPartition nodePartition : nodePartitions) {
                this.clusterPartitions.remove(nodePartition.getPartitionId());
            }
            this.participantNodes.remove(nodeId);
        }
    }

    public synchronized void removePending(String nodeId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering intention to remove node id {}", (Object)nodeId);
        }
        if (this.participantNodes.contains(nodeId)) {
            this.pendingRemoval.add(nodeId);
        } else {
            LOGGER.warn("Cannot register unknown node {} for pending removal", (Object)nodeId);
        }
    }

    public synchronized boolean cancelRemovePending(String nodeId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Deregistering intention to remove node id " + nodeId);
        }
        if (!this.pendingRemoval.remove(nodeId)) {
            LOGGER.warn("Cannot deregister intention to remove node id " + nodeId + " that was not registered");
            return false;
        }
        return true;
    }

    public Map<String, Map<IOption, Object>> getActiveNcConfiguration() {
        return this.ncConfigMap;
    }

    public synchronized Set<String> getNodesPendingRemoval() {
        return new HashSet<String>(this.pendingRemoval);
    }

    public synchronized void setMetadataPartitionId(ClusterPartition partition) {
        this.metadataPartition = partition;
    }

    public synchronized ClusterPartition getMetadataPartition() {
        return this.metadataPartition;
    }

    public synchronized void setRebalanceRequired(boolean rebalanceRequired) throws HyracksDataException {
        this.rebalanceRequired = rebalanceRequired;
        if (rebalanceRequired) {
            this.refreshState();
        }
    }

    public Map<Integer, ClusterPartition> getClusterPartitions() {
        return Collections.unmodifiableMap(this.clusterPartitions);
    }

    public synchronized boolean nodesFailed(Set<String> nodeIds) {
        return nodeIds.stream().anyMatch(this.failedNodes::contains);
    }

    private void updateClusterCounters(String nodeId, NcLocalCounters localCounters) {
        IResourceIdManager resourceIdManager = this.appCtx.getResourceIdManager();
        resourceIdManager.report(nodeId, localCounters.getMaxResourceId());
        this.appCtx.getTxnIdFactory().ensureMinimumId(localCounters.getMaxTxnId());
        ((ClusterControllerService)this.appCtx.getServiceContext().getControllerService()).getJobIdFactory().setMaxJobId(localCounters.getMaxJobId());
    }

    private void updateNodeConfig(String nodeId, Map<IOption, Object> configuration) {
        ConfigManager configManager = ((ConfigManagerApplicationConfig)this.appCtx.getServiceContext().getAppConfig()).getConfigManager();
        configuration.forEach((key, value) -> {
            if (key.section() == Section.NC) {
                configManager.set(nodeId, key, value);
            }
        });
    }

    private synchronized void activateNodePartitions(String nodeId, Set<Integer> activePartitions) {
        for (Integer partitionId : activePartitions) {
            this.updateClusterPartition(partitionId, nodeId, true);
        }
    }

    private synchronized void deactivateNodePartitions(String nodeId) {
        this.clusterPartitions.values().stream().filter(partition -> partition.getActiveNodeId() != null && partition.getActiveNodeId().equals(nodeId)).forEach(nodeActivePartition -> this.updateClusterPartition(nodeActivePartition.getPartitionId(), nodeId, false));
    }

    private static InetSocketAddress getReplicaLocation(IClusterStateManager csm, String nodeId) {
        Map ncConfig = (Map)csm.getActiveNcConfiguration().get(nodeId);
        if (ncConfig == null) {
            return null;
        }
        Object destIP = ncConfig.get(NCConfig.Option.REPLICATION_PUBLIC_ADDRESS);
        Object destPort = ncConfig.get(NCConfig.Option.REPLICATION_PUBLIC_PORT);
        if (destIP == null || destPort == null) {
            return null;
        }
        String replicaLocation = NetworkUtil.toHostPort((String)String.valueOf(destIP), (String)String.valueOf(destPort));
        return NetworkUtil.parseInetSocketAddress((String)replicaLocation);
    }
}

