/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.ActivityPlan;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.job.Task;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.job.TaskCluster;
import org.apache.hyracks.control.cc.job.TaskClusterAttempt;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;

public abstract class AbstractTaskLifecycleWork
extends AbstractHeartbeatWork {
    protected final JobId jobId;
    protected final TaskAttemptId taId;

    public AbstractTaskLifecycleWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId) {
        super(ccs, nodeId, null);
        this.jobId = jobId;
        this.taId = taId;
    }

    @Override
    public final void runWork() {
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(this.jobId);
        if (run != null) {
            TaskClusterAttempt tca;
            TaskAttempt ta;
            Task ts;
            TaskCluster tc;
            List<TaskClusterAttempt> taskClusterAttempts;
            Map<ActivityId, ActivityPlan> taskStateMap;
            Task[] taskStates;
            TaskId tid = this.taId.getTaskId();
            Map activityClusterMap = run.getActivityClusterGraph().getActivityMap();
            ActivityCluster ac = (ActivityCluster)activityClusterMap.get(tid.getActivityId());
            if (ac != null && (taskStates = (taskStateMap = run.getActivityClusterPlanMap().get(ac.getId()).getActivityPlanMap()).get(tid.getActivityId()).getTasks()) != null && taskStates.length > tid.getPartition() && (taskClusterAttempts = (tc = (ts = taskStates[tid.getPartition()]).getTaskCluster()).getAttempts()) != null && taskClusterAttempts.size() > this.taId.getAttempt() && (ta = (tca = taskClusterAttempts.get(this.taId.getAttempt())).getTaskAttempts().get(tid)) != null) {
                this.performEvent(ta);
            }
        }
    }

    protected abstract void performEvent(TaskAttempt var1);
}

