/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class LockList {
    private final List<MutablePair<IMetadataLock, IMetadataLock.Mode>> locks = new ArrayList<MutablePair<IMetadataLock, IMetadataLock.Mode>>();
    private final Map<IMetadataLock.LockKey, Integer> indexes = new HashMap<IMetadataLock.LockKey, Integer>();
    private boolean lockPhase = true;

    public void add(IMetadataLock.Mode mode, IMetadataLock lock) throws AsterixException {
        if (this.isContained(mode, lock)) {
            return;
        }
        lock.lock(mode);
        this.indexes.put(lock.getKey(), this.locks.size());
        this.locks.add((MutablePair<IMetadataLock, IMetadataLock.Mode>)MutablePair.of((Object)lock, (Object)((Object)mode)));
    }

    private boolean isContained(IMetadataLock.Mode mode, IMetadataLock lock) throws AsterixException {
        if (!this.lockPhase) {
            throw new AsterixException(ErrorCode.COMPILATION_TWO_PHASE_LOCKING_VIOLATION, new Serializable[0]);
        }
        Integer index = this.indexes.get(lock.getKey());
        if (index != null) {
            IMetadataLock.Mode acquired = (IMetadataLock.Mode)((Object)this.locks.get((int)index.intValue()).right);
            if (!acquired.contains(mode)) {
                throw new AsterixException(ErrorCode.LOCK_WAS_ACQUIRED_DIFFERENT_OPERATION, new Serializable[]{mode, acquired});
            }
            return true;
        }
        return false;
    }

    public void upgrade(IMetadataLock.Mode to, IMetadataLock lock) throws AlgebricksException {
        if (!this.lockPhase) {
            throw new AsterixException(ErrorCode.COMPILATION_TWO_PHASE_LOCKING_VIOLATION, new Serializable[0]);
        }
        Integer index = this.indexes.get(lock.getKey());
        if (index == null) {
            throw new AsterixException(ErrorCode.UPGRADE_FAILED_LOCK_WAS_NOT_ACQUIRED, new Serializable[0]);
        }
        MutablePair<IMetadataLock, IMetadataLock.Mode> pair = this.locks.get(index);
        IMetadataLock.Mode from = (IMetadataLock.Mode)((Object)pair.getRight());
        if (from == to) {
            return;
        }
        lock.upgrade(from, to);
        pair.setRight((Object)to);
    }

    public void downgrade(IMetadataLock.Mode mode, IMetadataLock lock) throws AlgebricksException {
        if (!this.lockPhase) {
            throw new AsterixException(ErrorCode.COMPILATION_TWO_PHASE_LOCKING_VIOLATION, new Serializable[0]);
        }
        Integer index = this.indexes.get(lock.getKey());
        if (index == null) {
            throw new AsterixException(ErrorCode.DOWNGRADE_FAILED_LOCK_WAS_NOT_ACQUIRED, new Serializable[0]);
        }
        MutablePair<IMetadataLock, IMetadataLock.Mode> pair = this.locks.get(index);
        IMetadataLock.Mode acquired = (IMetadataLock.Mode)((Object)pair.getRight());
        lock.downgrade(acquired, mode);
        pair.setRight((Object)mode);
    }

    public void unlock() {
        for (int i = this.locks.size() - 1; i >= 0; --i) {
            MutablePair<IMetadataLock, IMetadataLock.Mode> pair = this.locks.get(i);
            ((IMetadataLock)pair.getLeft()).unlock((IMetadataLock.Mode)((Object)pair.getRight()));
        }
        this.locks.clear();
        this.indexes.clear();
        this.lockPhase = false;
    }

    public void reset() {
        this.unlock();
        this.lockPhase = true;
    }

    public String toString() {
        return "{\"phase\" : \"" + (this.lockPhase ? "lock" : "unlock") + "\", \"locks\" : " + this.locks + "}";
    }
}

