/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;
import org.apache.hyracks.storage.common.IIndexAccessParameters;

public class CorrelatedPrefixMergePolicy
extends PrefixMergePolicy {
    private final IDatasetLifecycleManager datasetLifecycleManager;
    private final int datasetId;

    public CorrelatedPrefixMergePolicy(IDatasetLifecycleManager datasetLifecycleManager, int datasetId) {
        this.datasetLifecycleManager = datasetLifecycleManager;
        this.datasetId = datasetId;
    }

    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        if (fullMergeIsRequested || index.isPrimaryIndex()) {
            super.diskComponentAdded(index, fullMergeIsRequested);
        }
    }

    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        if (index.isPrimaryIndex()) {
            return super.isMergeLagging(index);
        }
        return false;
    }

    protected boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        ArrayList immutableComponents = new ArrayList(index.getDiskComponents());
        Collections.reverse(immutableComponents);
        Pair mergeableIndexes = this.getMergableComponentsIndex(immutableComponents);
        if (mergeableIndexes == null) {
            return false;
        }
        ILSMComponent leftComponent = (ILSMComponent)immutableComponents.get((Integer)mergeableIndexes.getLeft());
        ILSMComponent rightComponent = (ILSMComponent)immutableComponents.get((Integer)mergeableIndexes.getRight());
        ILSMComponentId targetId = LSMComponentIdUtils.union((ILSMComponentId)leftComponent.getId(), (ILSMComponentId)rightComponent.getId());
        int partition = ((PrimaryIndexOperationTracker)index.getOperationTracker()).getPartition();
        Set<ILSMIndex> indexes = this.datasetLifecycleManager.getDatasetInfo(this.datasetId).getDatasetPartitionOpenIndexes(partition);
        this.triggerScheduledMerge(targetId, indexes);
        return true;
    }

    private void triggerScheduledMerge(ILSMComponentId targetId, Set<ILSMIndex> indexes) throws HyracksDataException {
        for (ILSMIndex lsmIndex : indexes) {
            ArrayList immutableComponents = new ArrayList(lsmIndex.getDiskComponents());
            if (this.isMergeOngoing(immutableComponents)) continue;
            ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>();
            for (ILSMDiskComponent component : immutableComponents) {
                ILSMComponentId id = component.getId();
                ILSMComponentId.IdCompareResult cmp = targetId.compareTo(id);
                if (cmp == ILSMComponentId.IdCompareResult.INCLUDE) {
                    mergableComponents.add(component);
                    continue;
                }
                if (cmp != ILSMComponentId.IdCompareResult.GREATER_THAN) continue;
                break;
            }
            ILSMIndexAccessor accessor = lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleMerge(mergableComponents);
        }
    }
}

