/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.DataOutput;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public abstract class AbstractBinaryScalarEvaluator
implements IScalarEvaluator {
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected DataOutput dataOutput = this.resultStorage.getDataOutput();
    protected IPointable[] pointables;
    protected IScalarEvaluator[] evaluators;
    protected final FunctionIdentifier funcId;
    protected final SourceLocation sourceLoc;

    public AbstractBinaryScalarEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] evaluatorFactories, FunctionIdentifier funcId, SourceLocation sourceLoc) throws HyracksDataException {
        this.pointables = new IPointable[evaluatorFactories.length];
        this.evaluators = new IScalarEvaluator[evaluatorFactories.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.pointables[i] = new VoidPointable();
            this.evaluators[i] = evaluatorFactories[i].createScalarEvaluator(context);
        }
        this.funcId = funcId;
        this.sourceLoc = sourceLoc;
    }

    protected void checkTypeMachingThrowsIfNot(ATypeTag[] expected, ATypeTag ... actual) throws HyracksDataException {
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i] || ATypeHierarchy.canPromote((ATypeTag)actual[i], (ATypeTag)expected[i]) || ATypeHierarchy.canPromote((ATypeTag)expected[i], (ATypeTag)actual[i])) continue;
            throw new TypeMismatchException(this.sourceLoc, this.funcId, i, actual[i].serialize(), expected[i].serialize());
        }
    }
}

