/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ReflectionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private ReflectionUtils() {
    }

    public static <T> T createInstance(Class<? extends T> klass) {
        T instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    public static Field getAccessibleField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field f = clazz.getDeclaredField(fieldName);
        f.setAccessible(true);
        return f;
    }

    public static Field getAccessibleField(Object obj, String fieldName) throws NoSuchFieldException {
        Class<?> cl = obj.getClass();
        while (true) {
            Field f = null;
            try {
                f = ReflectionUtils.getAccessibleField(cl, fieldName);
                return f;
            }
            catch (NoSuchFieldException e) {
                if ((cl = cl.getSuperclass()) != null) continue;
                throw new NoSuchFieldException("field: '" + fieldName + "' not found in (hierarchy of) " + obj.getClass());
            }
            break;
        }
    }

    public static Object readField(Object obj, String fieldName) throws IOException {
        try {
            return ReflectionUtils.readField(obj, ReflectionUtils.getAccessibleField(obj, fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e);
        }
    }

    public static Object readField(Object obj, Field f) throws IOException {
        Class<?> objClass = obj.getClass();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = f::getName;
        supplierArray[1] = objClass::toString;
        LOGGER.debug("reading field '{}' on object of type {}", supplierArray);
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("exception reading field '{}' on object of type {}", (Object)f.getName(), objClass, (Object)e);
            throw new IOException(e);
        }
    }

    public static void writeField(Object obj, String fieldName, Object newValue) throws IOException {
        try {
            ReflectionUtils.writeField(obj, ReflectionUtils.getAccessibleField(obj, fieldName), newValue);
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e);
        }
    }

    public static void writeField(Object obj, Field f, Object newValue) throws IOException {
        Class<?> objClass = obj.getClass();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = f::getName;
        supplierArray[1] = objClass::toString;
        supplierArray[2] = newValue::toString;
        LOGGER.debug("updating field '{}' on object of type {} to {}", supplierArray);
        try {
            f.set(obj, newValue);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("exception updating field '{}' object of type {} to {}", (Object)f.getName(), objClass, newValue, (Object)e);
            throw new IOException(e);
        }
    }
}

