/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.StridedIndexTypeCollection;

class IndexMultiList {
    StridedIndexTypeCollection m_listNodes = new StridedIndexTypeCollection(2);
    StridedIndexTypeCollection m_lists;
    int m_list_of_lists;
    boolean m_b_allow_navigation_between_lists;

    void freeNode_(int node) {
        this.m_listNodes.deleteElement(node);
    }

    int newNode_() {
        int node = this.m_listNodes.newElement();
        return node;
    }

    void freeList_(int list) {
        this.m_lists.deleteElement(list);
    }

    int newList_() {
        int list = this.m_lists.newElement();
        return list;
    }

    IndexMultiList() {
        this.m_lists = new StridedIndexTypeCollection(4);
        this.m_list_of_lists = IndexMultiList.nullNode();
        this.m_b_allow_navigation_between_lists = true;
    }

    IndexMultiList(boolean b_allow_navigation_between_lists) {
        this.m_lists = new StridedIndexTypeCollection(b_allow_navigation_between_lists ? 4 : 2);
        this.m_list_of_lists = IndexMultiList.nullNode();
        this.m_b_allow_navigation_between_lists = b_allow_navigation_between_lists;
    }

    int createList() {
        int node = this.newList_();
        if (this.m_b_allow_navigation_between_lists) {
            this.m_lists.setField(node, 3, this.m_list_of_lists);
            if (this.m_list_of_lists != IndexMultiList.nullNode()) {
                this.m_lists.setField(this.m_list_of_lists, 2, node);
            }
            this.m_list_of_lists = node;
        }
        return node;
    }

    void deleteList(int list) {
        int ptr = this.getFirst(list);
        while (ptr != IndexMultiList.nullNode()) {
            int p = ptr;
            ptr = this.getNext(ptr);
            this.freeNode_(p);
        }
        if (this.m_b_allow_navigation_between_lists) {
            int prevList = this.m_lists.getField(list, 2);
            int nextList = this.m_lists.getField(list, 3);
            if (prevList != IndexMultiList.nullNode()) {
                this.m_lists.setField(prevList, 3, nextList);
            } else {
                this.m_list_of_lists = nextList;
            }
            if (nextList != IndexMultiList.nullNode()) {
                this.m_lists.setField(nextList, 2, prevList);
            }
        }
        this.freeList_(list);
    }

    void reserveLists(int listCount) {
        this.m_lists.setCapacity(listCount);
    }

    int addElement(int list, int element) {
        int head = this.m_lists.getField(list, 0);
        int tail = this.m_lists.getField(list, 1);
        int node = this.newNode_();
        if (tail != IndexMultiList.nullNode()) {
            assert (head != IndexMultiList.nullNode());
            this.m_listNodes.setField(tail, 1, node);
            this.m_lists.setField(list, 1, node);
        } else {
            assert (head == IndexMultiList.nullNode());
            this.m_lists.setField(list, 0, node);
            this.m_lists.setField(list, 1, node);
        }
        this.m_listNodes.setField(node, 0, element);
        return node;
    }

    void reserveNodes(int nodeCount) {
        this.m_listNodes.setCapacity(nodeCount);
    }

    void deleteElement(int list, int prevNode, int node) {
        if (prevNode != IndexMultiList.nullNode()) {
            assert (this.m_listNodes.getField(prevNode, 1) == node);
            this.m_listNodes.setField(prevNode, 1, this.m_listNodes.getField(node, 1));
            if (this.m_lists.getField(list, 1) == node) {
                this.m_lists.setField(list, 1, prevNode);
            }
        } else {
            assert (this.m_lists.getField(list, 0) == node);
            this.m_lists.setField(list, 0, this.m_listNodes.getField(node, 1));
            if (this.m_lists.getField(list, 1) == node) {
                assert (this.m_listNodes.getField(node, 1) == IndexMultiList.nullNode());
                this.m_lists.setField(list, 1, IndexMultiList.nullNode());
            }
        }
        this.freeNode_(node);
    }

    int concatenateLists(int list1, int list2) {
        int tailNode1 = this.m_lists.getField(list1, 1);
        int headNode2 = this.m_lists.getField(list2, 0);
        if (headNode2 != IndexMultiList.nullNode()) {
            if (tailNode1 != IndexMultiList.nullNode()) {
                this.m_listNodes.setField(tailNode1, 1, headNode2);
                this.m_lists.setField(list1, 1, this.m_lists.getField(list2, 1));
            } else {
                this.m_lists.setField(list1, 0, headNode2);
                this.m_lists.setField(list1, 1, this.m_lists.getField(list2, 1));
            }
        }
        if (this.m_b_allow_navigation_between_lists) {
            int prevList = this.m_lists.getField(list2, 2);
            int nextList = this.m_lists.getField(list2, 3);
            if (prevList != IndexMultiList.nullNode()) {
                this.m_lists.setField(prevList, 3, nextList);
            } else {
                this.m_list_of_lists = nextList;
            }
            if (nextList != IndexMultiList.nullNode()) {
                this.m_lists.setField(nextList, 2, prevList);
            }
        }
        this.freeList_(list2);
        return list1;
    }

    int getElement(int node_index) {
        return this.m_listNodes.getField(node_index, 0);
    }

    void setElement(int node_index, int element) {
        this.m_listNodes.setField(node_index, 0, element);
    }

    int getNext(int node_index) {
        return this.m_listNodes.getField(node_index, 1);
    }

    int getFirst(int list) {
        return this.m_lists.getField(list, 0);
    }

    int getFirstElement(int list) {
        int f = this.getFirst(list);
        return this.getElement(f);
    }

    static int nullNode() {
        return -1;
    }

    void clear() {
        this.m_listNodes.deleteAll(true);
        this.m_lists.deleteAll(true);
        this.m_list_of_lists = IndexMultiList.nullNode();
    }

    boolean isEmpty(int list) {
        return this.m_lists.getField(list, 0) == IndexMultiList.nullNode();
    }

    boolean isEmpty() {
        return this.m_listNodes.size() == 0;
    }

    int getNodeCount() {
        return this.m_listNodes.size();
    }

    int getListCount() {
        return this.m_lists.size();
    }

    int getFirstList() {
        assert (this.m_b_allow_navigation_between_lists);
        return this.m_list_of_lists;
    }

    int getNextList(int list) {
        assert (this.m_b_allow_navigation_between_lists);
        return this.m_lists.getField(list, 3);
    }
}

