/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.TuplePairEvaluatorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.join.NestedLoopJoinOperatorDescriptor;

public class NestedLoopJoinPOperator
extends AbstractJoinPOperator {
    public NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType) {
        super(kind, partitioningType);
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.NESTED_LOOP;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) {
        AbstractLogicalOperator op2;
        IPhysicalPropertiesVector pv1;
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        Object pp = op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED ? ((pv1 = (op2 = (AbstractLogicalOperator)op.getInputs().get(1).getValue()).getPhysicalOperator().getDeliveredProperties()) == null ? null : pv1.getPartitioningProperty()) : IPartitioningProperty.UNPARTITIONED;
        this.deliveredProperties = new StructuralPropertiesVector((IPartitioningProperty)pp, null);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[]{OperatorPropertiesUtil.checkUnpartitionedAndGetPropertiesVector(op, new StructuralPropertiesVector(new RandomPartitioningProperty(context.getComputationNodeDomain()), null)), OperatorPropertiesUtil.checkUnpartitionedAndGetPropertiesVector(op, new StructuralPropertiesVector(new BroadcastPartitioningProperty(context.getComputationNodeDomain()), null))};
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        NestedLoopJoinOperatorDescriptor opDesc;
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        IOperatorSchema[] conditionInputSchemas = new IOperatorSchema[]{propagatedSchema};
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory cond = expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)join.getCondition().getValue(), context.getTypeEnvironment(op), conditionInputSchemas, context);
        TuplePairEvaluatorFactory comparatorFactory = new TuplePairEvaluatorFactory(cond, false, context.getBinaryBooleanInspectorFactory());
        JobSpecification spec = builder.getJobSpec();
        int memSize = this.localMemoryRequirements.getMemoryBudgetInFrames();
        switch (this.kind) {
            case INNER: {
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, memSize, false, null);
                break;
            }
            case LEFT_OUTER: {
                IMissingWriterFactory[] nonMatchWriterFactories = new IMissingWriterFactory[inputSchemas[1].getSize()];
                for (int j = 0; j < nonMatchWriterFactories.length; ++j) {
                    nonMatchWriterFactories[j] = context.getMissingWriterFactory();
                }
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, memSize, true, nonMatchWriterFactories);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        opDesc.setSourceLocation(join.getSourceLocation());
        this.contributeOpDesc(builder, join, (IOperatorDescriptor)opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }
}

