/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableUUID;
import org.apache.asterix.om.base.AUUID;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class AUUIDFromStringConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = AUUIDFromStringConstructorDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutableUUID uuid;
                    private ISerializerDeserializer<AUUID> uuidSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.uuid = new AMutableUUID();
                        this.uuidSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AUUID);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block5: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                                    return;
                                }
                                byte[] serString = this.inputArg.getByteArray();
                                int start = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[start];
                                if (tt == ATypeTag.SERIALIZED_UUID_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block5;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    this.utf8Ptr.set(serString, start + 1, len - 1);
                                    int offset = this.utf8Ptr.getCharStartOffset();
                                    this.uuid.parseUUIDHexBytes(serString, offset);
                                    this.uuidSerde.serialize((Object)this.uuid, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block5;
                                }
                                throw new TypeMismatchException(AUUIDFromStringConstructorDescriptor.this.sourceLoc, AUUIDFromStringConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (HyracksDataException e) {
                                e.setSourceLocation(AUUIDFromStringConstructorDescriptor.this.sourceLoc);
                                throw e;
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.UUID_CONSTRUCTOR;
    }
}

