/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedIntakeOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final String FEED_EXTENSION_NAME = "Feed";
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityId feedId;
    private final FeedPolicyAccessor policyAccessor;
    private final ARecordType adapterOutputType;
    private ITypedAdapterFactory adaptorFactory;
    private DataverseName adaptorLibraryDataverse;
    private String adaptorLibraryName;
    private String adaptorFactoryClassName;
    private Map<String, String> adaptorConfiguration;

    public FeedIntakeOperatorDescriptor(JobSpecification spec, IFeed primaryFeed, ITypedAdapterFactory adapterFactory, ARecordType adapterOutputType, FeedPolicyAccessor policyAccessor, RecordDescriptor rDesc) {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        this.feedId = new EntityId(FEED_EXTENSION_NAME, primaryFeed.getDataverseName(), primaryFeed.getFeedName());
        this.adaptorFactory = adapterFactory;
        this.adapterOutputType = adapterOutputType;
        this.policyAccessor = policyAccessor;
        this.outRecDescs[0] = rDesc;
    }

    public FeedIntakeOperatorDescriptor(JobSpecification spec, IFeed feed, DataverseName adapterLibraryDataverse, String adapterLibraryName, String adapterFactoryClassName, ARecordType adapterOutputType, FeedPolicyAccessor policyAccessor, RecordDescriptor rDesc) {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        this.feedId = new EntityId(FEED_EXTENSION_NAME, feed.getDataverseName(), feed.getFeedName());
        this.adaptorFactoryClassName = adapterFactoryClassName;
        this.adaptorLibraryDataverse = adapterLibraryDataverse;
        this.adaptorLibraryName = adapterLibraryName;
        this.adaptorConfiguration = feed.getConfiguration();
        this.adapterOutputType = adapterOutputType;
        this.policyAccessor = policyAccessor;
        this.outRecDescs[0] = rDesc;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        if (this.adaptorFactory == null) {
            this.adaptorFactory = this.createExternalAdapterFactory(ctx);
        }
        return new FeedIntakeOperatorNodePushable(ctx, this.feedId, this.adaptorFactory, partition, recordDescProvider, this);
    }

    private ITypedAdapterFactory createExternalAdapterFactory(IHyracksTaskContext ctx) throws HyracksDataException {
        ITypedAdapterFactory adapterFactory;
        INcApplicationContext runtimeCtx = (INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext();
        ILibraryManager libraryManager = runtimeCtx.getLibraryManager();
        ILibrary lib = libraryManager.getLibrary(this.adaptorLibraryDataverse, this.adaptorLibraryName);
        if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
            throw new HyracksDataException("Unexpected library language: " + lib.getLanguage());
        }
        ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
        if (classLoader != null) {
            try {
                adapterFactory = (ITypedAdapterFactory)classLoader.loadClass(this.adaptorFactoryClassName).newInstance();
                adapterFactory.setOutputType(this.adapterOutputType);
                adapterFactory.configure(null, this.adaptorConfiguration, ctx.getWarningCollector());
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        } else {
            RuntimeDataException err = new RuntimeDataException(3004, new Serializable[]{this.adaptorLibraryName, this.feedId.getDataverseName()});
            LOGGER.error(err.getMessage());
            throw err;
        }
        return adapterFactory;
    }

    public EntityId getEntityId() {
        return this.feedId;
    }

    public ITypedAdapterFactory getAdaptorFactory() {
        return this.adaptorFactory;
    }

    public void setAdaptorFactory(ITypedAdapterFactory factory) {
        this.adaptorFactory = factory;
    }

    public ARecordType getAdapterOutputType() {
        return this.adapterOutputType;
    }

    public FeedPolicyAccessor getPolicyAccessor() {
        return this.policyAccessor;
    }

    public DataverseName getAdaptorLibraryDataverse() {
        return this.adaptorLibraryDataverse;
    }

    public String getAdaptorLibraryName() {
        return this.adaptorLibraryName;
    }

    public String getAdaptorFactoryClassName() {
        return this.adaptorFactoryClassName;
    }
}

