/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.trident;

import backtype.storm.Config;
import backtype.storm.ILocalDRPC;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.generated.StormTopology;
import backtype.storm.task.IMetricsContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.TridentState;
import storm.trident.TridentTopology;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.Function;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.builtin.MapGet;
import storm.trident.operation.builtin.Sum;
import storm.trident.state.QueryFunction;
import storm.trident.state.ReadOnlyState;
import storm.trident.state.State;
import storm.trident.state.StateFactory;
import storm.trident.state.map.ReadOnlyMapState;
import storm.trident.tuple.TridentTuple;

public class TridentReach {
    public static Map<String, List<String>> TWEETERS_DB = new HashMap<String, List<String>>(){
        {
            this.put("foo.com/blog/1", Arrays.asList("sally", "bob", "tim", "george", "nathan"));
            this.put("engineering.twitter.com/blog/5", Arrays.asList("adam", "david", "sally", "nathan"));
            this.put("tech.backtype.com/blog/123", Arrays.asList("tim", "mike", "john"));
        }
    };
    public static Map<String, List<String>> FOLLOWERS_DB = new HashMap<String, List<String>>(){
        {
            this.put("sally", Arrays.asList("bob", "tim", "alice", "adam", "jim", "chris", "jai"));
            this.put("bob", Arrays.asList("sally", "nathan", "jim", "mary", "david", "vivian"));
            this.put("tim", Arrays.asList("alex"));
            this.put("nathan", Arrays.asList("sally", "bob", "adam", "harry", "chris", "vivian", "emily", "jordan"));
            this.put("adam", Arrays.asList("david", "carissa"));
            this.put("mike", Arrays.asList("john", "bob"));
            this.put("john", Arrays.asList("alice", "nathan", "jim", "mike", "bob"));
        }
    };

    public static StormTopology buildTopology(LocalDRPC drpc) {
        TridentTopology topology = new TridentTopology();
        TridentState urlToTweeters = topology.newStaticState((StateFactory)new StaticSingleKeyMapState.Factory(TWEETERS_DB));
        TridentState tweetersToFollowers = topology.newStaticState((StateFactory)new StaticSingleKeyMapState.Factory(FOLLOWERS_DB));
        topology.newDRPCStream("reach", (ILocalDRPC)drpc).stateQuery(urlToTweeters, new Fields(new String[]{"args"}), (QueryFunction)new MapGet(), new Fields(new String[]{"tweeters"})).each(new Fields(new String[]{"tweeters"}), (Function)new ExpandList(), new Fields(new String[]{"tweeter"})).shuffle().stateQuery(tweetersToFollowers, new Fields(new String[]{"tweeter"}), (QueryFunction)new MapGet(), new Fields(new String[]{"followers"})).each(new Fields(new String[]{"followers"}), (Function)new ExpandList(), new Fields(new String[]{"follower"})).groupBy(new Fields(new String[]{"follower"})).aggregate((CombinerAggregator)new One(), new Fields(new String[]{"one"})).aggregate(new Fields(new String[]{"one"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"reach"}));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        LocalDRPC drpc = new LocalDRPC();
        Config conf = new Config();
        LocalCluster cluster = new LocalCluster();
        cluster.submitTopology("reach", (Map)conf, TridentReach.buildTopology(drpc));
        Thread.sleep(2000L);
        System.out.println("REACH: " + drpc.execute("reach", "aaa"));
        System.out.println("REACH: " + drpc.execute("reach", "foo.com/blog/1"));
        System.out.println("REACH: " + drpc.execute("reach", "engineering.twitter.com/blog/5"));
        cluster.shutdown();
        drpc.shutdown();
    }

    public static class ExpandList
    extends BaseFunction {
        public void execute(TridentTuple tuple, TridentCollector collector) {
            List l = (List)tuple.getValue(0);
            if (l != null) {
                for (Object o : l) {
                    collector.emit((List)new Values(new Object[]{o}));
                }
            }
        }
    }

    public static class One
    implements CombinerAggregator<Integer> {
        public Integer init(TridentTuple tuple) {
            return 1;
        }

        public Integer combine(Integer val1, Integer val2) {
            return 1;
        }

        public Integer zero() {
            return 1;
        }
    }

    public static class StaticSingleKeyMapState
    extends ReadOnlyState
    implements ReadOnlyMapState<Object> {
        Map _map;

        public StaticSingleKeyMapState(Map map) {
            this._map = map;
        }

        public List<Object> multiGet(List<List<Object>> keys) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (List<Object> key : keys) {
                Object singleKey = key.get(0);
                ret.add(this._map.get(singleKey));
            }
            return ret;
        }

        public static class Factory
        implements StateFactory {
            Map _map;

            public Factory(Map map) {
                this._map = map;
            }

            public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
                return new StaticSingleKeyMapState(this._map);
            }
        }
    }
}

