/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.RabbitMQProperties;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.messaging.core.Type;
import org.apache.airavata.messaging.core.impl.ExperimentConsumer;
import org.apache.airavata.messaging.core.impl.MessageConsumer;
import org.apache.airavata.messaging.core.impl.ProcessConsumer;
import org.apache.airavata.messaging.core.impl.RabbitMQPublisher;
import org.apache.airavata.messaging.core.impl.RabbitMQSubscriber;
import org.apache.airavata.messaging.core.impl.StatusConsumer;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.messaging.event.JobStatusChangeEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessIdentifier;
import org.apache.airavata.model.messaging.event.ProcessStatusChangeEvent;
import org.apache.airavata.model.messaging.event.TaskOutputChangeEvent;
import org.apache.airavata.model.messaging.event.TaskStatusChangeEvent;

public class MessagingFactory {
    public static Subscriber getSubscriber(MessageHandler messageHandler, List<String> routingKeys, Type type) throws AiravataException {
        Subscriber subscriber = null;
        RabbitMQProperties rProperties = MessagingFactory.getProperties();
        switch (type) {
            case EXPERIMENT_LAUNCH: {
                subscriber = MessagingFactory.getExperimentSubscriber(rProperties);
                subscriber.listen((connection, channel) -> new ExperimentConsumer(messageHandler, (Connection)connection, (Channel)channel), rProperties.getQueueName(), routingKeys);
                break;
            }
            case PROCESS_LAUNCH: {
                subscriber = MessagingFactory.getProcessSubscriber(rProperties);
                subscriber.listen((connection, channel) -> new ProcessConsumer(messageHandler, (Connection)connection, (Channel)channel), rProperties.getQueueName(), routingKeys);
                break;
            }
            case STATUS: {
                subscriber = MessagingFactory.getStatusSubscriber(rProperties);
                subscriber.listen((connection, channel) -> new StatusConsumer(messageHandler, (Connection)connection, (Channel)channel), rProperties.getQueueName(), routingKeys);
                break;
            }
        }
        return subscriber;
    }

    public static Subscriber getDBEventSubscriber(MessageHandler messageHandler, final String serviceName) throws AiravataException {
        RabbitMQProperties rProperties = MessagingFactory.getProperties();
        rProperties.setExchangeName("db.event.exchange").setQueueName(DBEventManagerConstants.getQueueName((String)serviceName)).setAutoAck(false);
        RabbitMQSubscriber subscriber = new RabbitMQSubscriber(rProperties);
        subscriber.listen((connection, channel) -> new MessageConsumer(messageHandler, (Connection)connection, (Channel)channel), rProperties.getQueueName(), (List<String>)new ArrayList<String>(){
            {
                this.add(DBEventManagerConstants.getRoutingKey((String)serviceName));
            }
        });
        return subscriber;
    }

    public static Publisher getPublisher(Type type) throws AiravataException {
        RabbitMQProperties rProperties = MessagingFactory.getProperties();
        Publisher publiser = null;
        switch (type) {
            case EXPERIMENT_LAUNCH: {
                publiser = MessagingFactory.getExperimentPublisher(rProperties);
                break;
            }
            case PROCESS_LAUNCH: {
                publiser = MessagingFactory.gerProcessPublisher(rProperties);
                break;
            }
            case STATUS: {
                publiser = MessagingFactory.getStatusPublisher(rProperties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Publisher " + (Object)((Object)type) + " is not handled");
            }
        }
        return publiser;
    }

    public static Publisher getDBEventPublisher() throws AiravataException {
        RabbitMQProperties rProperties = MessagingFactory.getProperties();
        rProperties.setExchangeName("db.event.exchange");
        return new RabbitMQPublisher(rProperties);
    }

    private static Publisher getExperimentPublisher(RabbitMQProperties rProperties) throws AiravataException {
        rProperties.setExchangeName(ServerSettings.getRabbitmqExperimentExchangeName());
        return new RabbitMQPublisher(rProperties, messageContext -> rProperties.getExchangeName());
    }

    private static Publisher getStatusPublisher(RabbitMQProperties rProperties) throws AiravataException {
        rProperties.setExchangeName(ServerSettings.getRabbitmqStatusExchangeName());
        return new RabbitMQPublisher(rProperties, MessagingFactory::statusRoutingkey);
    }

    private static Publisher gerProcessPublisher(RabbitMQProperties rProperties) throws AiravataException {
        rProperties.setExchangeName(ServerSettings.getRabbitmqProcessExchangeName());
        return new RabbitMQPublisher(rProperties, messageContext -> rProperties.getExchangeName());
    }

    private static RabbitMQProperties getProperties() {
        return new RabbitMQProperties().setBrokerUrl(ServerSettings.getRabbitmqBrokerUrl()).setDurable(ServerSettings.getRabbitmqDurableQueue()).setPrefetchCount(ServerSettings.getRabbitmqPrefetchCount()).setAutoRecoveryEnable(true).setConsumerTag("default").setExchangeType(RabbitMQProperties.EXCHANGE_TYPE.TOPIC);
    }

    private static RabbitMQSubscriber getStatusSubscriber(RabbitMQProperties sp) throws AiravataException {
        sp.setExchangeName(ServerSettings.getRabbitmqStatusExchangeName()).setAutoAck(true);
        return new RabbitMQSubscriber(sp);
    }

    private static RabbitMQSubscriber getProcessSubscriber(RabbitMQProperties sp) throws AiravataException {
        sp.setExchangeName(ServerSettings.getRabbitmqProcessExchangeName()).setQueueName("process_launch").setAutoAck(false);
        return new RabbitMQSubscriber(sp);
    }

    private static Subscriber getExperimentSubscriber(RabbitMQProperties sp) throws AiravataException {
        sp.setExchangeName(ServerSettings.getRabbitmqExperimentExchangeName()).setQueueName("experiment_launch").setAutoAck(false);
        return new RabbitMQSubscriber(sp);
    }

    private static String statusRoutingkey(MessageContext msgCtx) {
        String gatewayId = msgCtx.getGatewayId();
        String routingKey = null;
        if (msgCtx.getType() == MessageType.EXPERIMENT) {
            ExperimentStatusChangeEvent event = (ExperimentStatusChangeEvent)msgCtx.getEvent();
            routingKey = gatewayId + "." + event.getExperimentId();
        } else if (msgCtx.getType() == MessageType.TASK) {
            TaskStatusChangeEvent event = (TaskStatusChangeEvent)msgCtx.getEvent();
            routingKey = gatewayId + "." + event.getTaskIdentity().getExperimentId() + "." + event.getTaskIdentity().getProcessId() + "." + event.getTaskIdentity().getTaskId();
        } else if (msgCtx.getType() == MessageType.PROCESSOUTPUT) {
            TaskOutputChangeEvent event = (TaskOutputChangeEvent)msgCtx.getEvent();
            routingKey = gatewayId + "." + event.getTaskIdentity().getExperimentId() + "." + event.getTaskIdentity().getProcessId() + "." + event.getTaskIdentity().getTaskId();
        } else if (msgCtx.getType() == MessageType.PROCESS) {
            ProcessStatusChangeEvent event = (ProcessStatusChangeEvent)msgCtx.getEvent();
            ProcessIdentifier processIdentifier = event.getProcessIdentity();
            routingKey = gatewayId + "." + processIdentifier.getExperimentId() + "." + processIdentifier.getProcessId();
        } else if (msgCtx.getType() == MessageType.JOB) {
            JobStatusChangeEvent event = (JobStatusChangeEvent)msgCtx.getEvent();
            JobIdentifier identity = event.getJobIdentity();
            routingKey = gatewayId + "." + identity.getExperimentId() + "." + identity.getProcessId() + "." + identity.getTaskId() + "." + identity.getJobId();
        }
        return routingKey;
    }
}

