/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPResponder;

public class OCSPParametes {
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int DEFAULT_CACHE = 3600;
    protected OCSPCheckingMode checkingMode;
    protected OCSPResponder[] localResponders;
    protected int conntectTimeout;
    protected boolean preferLocalResponders;
    protected boolean useNonce;
    protected int cacheTtl;
    protected String diskCachePath;

    public OCSPParametes() {
        this(OCSPCheckingMode.IF_AVAILABLE);
    }

    public OCSPParametes(OCSPCheckingMode checkingMode) {
        this(checkingMode, new OCSPResponder[0], 3600, null);
    }

    public OCSPParametes(OCSPCheckingMode checkingMode, OCSPResponder localResponder) {
        this(checkingMode, new OCSPResponder[]{localResponder}, 3600, null);
    }

    public OCSPParametes(OCSPCheckingMode checkingMode, OCSPResponder[] localResponders, int cacheTtl, String diskCachePath) {
        this(checkingMode, localResponders, 10000, true, false, cacheTtl, diskCachePath);
    }

    public OCSPParametes(OCSPCheckingMode checkingMode, OCSPResponder[] localResponders, int conntectTimeout, boolean preferLocalResponders, boolean useNonce, int cacheTtl, String diskCachePath) {
        this.checkingMode = checkingMode;
        this.localResponders = localResponders;
        this.conntectTimeout = conntectTimeout;
        this.preferLocalResponders = preferLocalResponders;
        this.useNonce = useNonce;
        this.cacheTtl = cacheTtl;
        this.diskCachePath = diskCachePath;
    }

    public OCSPCheckingMode getCheckingMode() {
        return this.checkingMode;
    }

    public void setCheckingMode(OCSPCheckingMode checkingMode) {
        this.checkingMode = checkingMode;
    }

    public OCSPResponder[] getLocalResponders() {
        return this.localResponders;
    }

    public void setLocalResponders(OCSPResponder[] localResponders) {
        this.localResponders = localResponders;
    }

    public int getConntectTimeout() {
        return this.conntectTimeout;
    }

    public void setConntectTimeout(int conntectTimeout) {
        this.conntectTimeout = conntectTimeout;
    }

    public boolean isPreferLocalResponders() {
        return this.preferLocalResponders;
    }

    public void setPreferLocalResponders(boolean preferLocalResponders) {
        this.preferLocalResponders = preferLocalResponders;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public int getCacheTtl() {
        return this.cacheTtl;
    }

    public void setCacheTtl(int cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    public String getDiskCachePath() {
        return this.diskCachePath;
    }

    public void setDiskCachePath(String diskCachePath) {
        this.diskCachePath = diskCachePath;
    }
}

