/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.workflow.catalog.model.ComponentStatus;
import org.apache.airavata.registry.core.workflow.catalog.model.Workflow;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatAbstractResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogJPAUtils;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogQueryGenerator;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogResourceType;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentStatusResource
extends WorkflowCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ComponentStatusResource.class);
    private String statusId;
    private String state;
    private String reason;
    private String templateId;
    private Timestamp updatedTime;

    @Override
    public void remove(Object identifier) throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("ComponentStatus", new Object[0][]);
            generator.setParameter("statusId", identifier.toString());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public WorkflowCatalogResource get(Object identifier) throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("ComponentStatus", new Object[0][]);
            generator.setParameter("statusId", identifier.toString());
            Query q = generator.selectQuery(em);
            ComponentStatus status = (ComponentStatus)q.getSingleResult();
            ComponentStatusResource statusResource = (ComponentStatusResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.COMPONENT_STATUS, status);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ComponentStatusResource componentStatusResource = statusResource;
            return componentStatusResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<WorkflowCatalogResource> get(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<WorkflowCatalogResource> statusResources = new ArrayList<WorkflowCatalogResource>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("ComponentStatus", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComponentStatus componentStatus = (ComponentStatus)result;
                        ComponentStatusResource statusResource = (ComponentStatusResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.COMPONENT_STATUS, componentStatus);
                        statusResources.add(statusResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Component status Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Component status Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return statusResources;
    }

    @Override
    public List<WorkflowCatalogResource> getAll() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<String> statusResourceIds = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("ComponentStatus", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComponentStatus componentStatus = (ComponentStatus)result;
                        statusResourceIds.add(componentStatus.getTemplateId());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Component Status resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Component Status Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return statusResourceIds;
    }

    @Override
    public void save() throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            ComponentStatus existingStatus = (ComponentStatus)em.find(ComponentStatus.class, (Object)this.statusId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingStatus != null) {
                existingStatus.setTemplateId(this.templateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.templateId);
                existingStatus.setWorkflow(workflow);
                existingStatus.setReason(this.reason);
                existingStatus.setState(this.state);
                existingStatus.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                em.merge((Object)existingStatus);
            } else {
                ComponentStatus status = new ComponentStatus();
                status.setTemplateId(this.templateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.templateId);
                status.setWorkflow(workflow);
                status.setReason(this.reason);
                status.setState(this.state);
                status.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                em.persist((Object)status);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            ComponentStatus status = (ComponentStatus)em.find(ComponentStatus.class, (Object)identifier.toString());
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = status != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }
}

