/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.util;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.registry.core.app.catalog.model.AppEnvironment;
import org.apache.airavata.registry.core.app.catalog.model.AppModuleMapping;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationDeployment;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationIntInput;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationIntOutput;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationInterface;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationModule;
import org.apache.airavata.registry.core.app.catalog.model.BatchQueue;
import org.apache.airavata.registry.core.app.catalog.model.CloudJobSubmission;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourceFileSystem;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourcePreference;
import org.apache.airavata.registry.core.app.catalog.model.DataMovementInterface;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHExport;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHSubmission;
import org.apache.airavata.registry.core.app.catalog.model.GatewayProfile;
import org.apache.airavata.registry.core.app.catalog.model.GlobusGKEndpoint;
import org.apache.airavata.registry.core.app.catalog.model.GlobusJobSubmission;
import org.apache.airavata.registry.core.app.catalog.model.GridftpDataMovement;
import org.apache.airavata.registry.core.app.catalog.model.GridftpEndpoint;
import org.apache.airavata.registry.core.app.catalog.model.HostAlias;
import org.apache.airavata.registry.core.app.catalog.model.HostIPAddress;
import org.apache.airavata.registry.core.app.catalog.model.JobManagerCommand;
import org.apache.airavata.registry.core.app.catalog.model.JobSubmissionInterface;
import org.apache.airavata.registry.core.app.catalog.model.LibraryApendPath;
import org.apache.airavata.registry.core.app.catalog.model.LibraryPrepandPath;
import org.apache.airavata.registry.core.app.catalog.model.LocalDataMovement;
import org.apache.airavata.registry.core.app.catalog.model.LocalSubmission;
import org.apache.airavata.registry.core.app.catalog.model.ModuleLoadCmd;
import org.apache.airavata.registry.core.app.catalog.model.ParallelismPrefixCommand;
import org.apache.airavata.registry.core.app.catalog.model.PostJobCommand;
import org.apache.airavata.registry.core.app.catalog.model.PreJobCommand;
import org.apache.airavata.registry.core.app.catalog.model.ResourceJobManager;
import org.apache.airavata.registry.core.app.catalog.model.SSHAccountProvisionerConfiguration;
import org.apache.airavata.registry.core.app.catalog.model.ScpDataMovement;
import org.apache.airavata.registry.core.app.catalog.model.SshJobSubmission;
import org.apache.airavata.registry.core.app.catalog.model.StorageInterface;
import org.apache.airavata.registry.core.app.catalog.model.StoragePreference;
import org.apache.airavata.registry.core.app.catalog.model.StorageResource;
import org.apache.airavata.registry.core.app.catalog.model.UnicoreDataMovement;
import org.apache.airavata.registry.core.app.catalog.model.UnicoreJobSubmission;
import org.apache.airavata.registry.core.app.catalog.model.UserComputeResourcePreference;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfile;
import org.apache.airavata.registry.core.app.catalog.model.UserStoragePreference;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppDeploymentResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppEnvironmentResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleMappingAppCatalogResourceAppCat;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationInputResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationOutputResource;
import org.apache.airavata.registry.core.app.catalog.resources.BatchQueueResource;
import org.apache.airavata.registry.core.app.catalog.resources.CloudSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceFileSystemResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.DataMovementInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.GSISSHExportResource;
import org.apache.airavata.registry.core.app.catalog.resources.GSISSHSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.GatewayProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.GlobusGKEndpointResource;
import org.apache.airavata.registry.core.app.catalog.resources.GlobusJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpEndpointResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostAliasAppResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostIPAddressResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobManagerCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobSubmissionInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.LibraryApendPathResource;
import org.apache.airavata.registry.core.app.catalog.resources.LibraryPrepandPathResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ModuleLoadCmdResource;
import org.apache.airavata.registry.core.app.catalog.resources.ParallelismPrefixCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.PostJobCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.PreJobCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.resources.ScpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.SshJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StoragePreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserResourceProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserStoragePreferenceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppCatalogJPAUtils {
    private static final Logger logger = LoggerFactory.getLogger(AppCatalogJPAUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "appcatalog_data";
    private static final String APPCATALOG_JDBC_DRIVER = "appcatalog.jdbc.driver";
    private static final String APPCATALOG_JDBC_URL = "appcatalog.jdbc.url";
    private static final String APPCATALOG_JDBC_USER = "appcatalog.jdbc.user";
    private static final String APPCATALOG_JDBC_PWD = "appcatalog.jdbc.password";
    private static final String APPCATALOG_VALIDATION_QUERY = "appcatalog.validationQuery";
    private static final String JPA_CACHE_SIZE = "jpa.cache.size";
    private static final String JPA_CACHE_ENABLED = "cache.enable";
    @PersistenceUnit(unitName="appcatalog_data")
    protected static EntityManagerFactory factory;
    @PersistenceContext(unitName="appcatalog_data")
    private static EntityManager appCatEntityManager;

    public static EntityManager getEntityManager() throws ApplicationSettingsException {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + AppCatalogJPAUtils.readServerProperties(APPCATALOG_JDBC_DRIVER) + ",Url=" + AppCatalogJPAUtils.readServerProperties(APPCATALOG_JDBC_URL) + "?autoReconnect=true,Username=" + AppCatalogJPAUtils.readServerProperties(APPCATALOG_JDBC_USER) + ",Password=" + AppCatalogJPAUtils.readServerProperties(APPCATALOG_JDBC_PWD) + ",validationQuery=" + AppCatalogJPAUtils.readServerProperties(APPCATALOG_VALIDATION_QUERY);
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        if (factory.getCache() != null) {
            factory.getCache().evictAll();
        }
        if ((appCatEntityManager = factory.createEntityManager()) != null) {
            appCatEntityManager.clear();
        }
        return appCatEntityManager;
    }

    private static String readServerProperties(String propertyName) throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting((String)propertyName);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata-server.properties...", (Throwable)e);
            throw new ApplicationSettingsException("Unable to read airavata-server.properties...");
        }
    }

    public static AppCatalogResource getResource(AppCatalogResourceType type, Object o) {
        switch (type) {
            case COMPUTE_RESOURCE: {
                if (o instanceof ComputeResource) {
                    return AppCatalogJPAUtils.createComputeResource((ComputeResource)o);
                }
                logger.error("Object should be a Compute Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Compute Resource.");
            }
            case HOST_ALIAS: {
                if (o instanceof HostAlias) {
                    return AppCatalogJPAUtils.createHostAlias((HostAlias)o);
                }
                logger.error("Object should be a Host Alias.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Host Alias.");
            }
            case HOST_IPADDRESS: {
                if (o instanceof HostIPAddress) {
                    return AppCatalogJPAUtils.createHostIPAddress((HostIPAddress)o);
                }
                logger.error("Object should be a Host IPAdress.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Host IPAdress.");
            }
            case GSISSH_SUBMISSION: {
                if (o instanceof GSISSHSubmission) {
                    return AppCatalogJPAUtils.createGSSISSHSubmission((GSISSHSubmission)o);
                }
                logger.error("Object should be a GSISSH Submission", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSH Submission.");
            }
            case UNICORE_JOB_SUBMISSION: {
                if (o instanceof UnicoreJobSubmission) {
                    return AppCatalogJPAUtils.createUnicoreJobSubmission((UnicoreJobSubmission)o);
                }
                logger.error("Object should be a GSISSH Submission", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSH Submission.");
            }
            case UNICORE_DATA_MOVEMENT: {
                if (o instanceof UnicoreDataMovement) {
                    return AppCatalogJPAUtils.createUnicoreDataMovement((UnicoreDataMovement)o);
                }
                logger.error("Object should be a GSISSH Submission", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSH Submission.");
            }
            case GSISSH_EXPORT: {
                if (o instanceof GSISSHExport) {
                    return AppCatalogJPAUtils.createGSISSHExport((GSISSHExport)o);
                }
                logger.error("Object should be a GSISSH Export.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSH Export.");
            }
            case PRE_JOBCOMMAND: {
                if (o instanceof PreJobCommand) {
                    return AppCatalogJPAUtils.createPreJobCommand((PreJobCommand)o);
                }
                logger.error("Object should be a GSISSHPreJobCommand.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSHPreJobCommand.");
            }
            case POST_JOBCOMMAND: {
                if (o instanceof PostJobCommand) {
                    return AppCatalogJPAUtils.createPostJObCommand((PostJobCommand)o);
                }
                logger.error("Object should be a GSISSHPostJobCommand.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GSISSHPostJobCommand.");
            }
            case GLOBUS_SUBMISSION: {
                if (o instanceof GlobusJobSubmission) {
                    return AppCatalogJPAUtils.createGlobusJobSubmission((GlobusJobSubmission)o);
                }
                logger.error("Object should be a GlobusJobSubmission.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GlobusJobSubmission.");
            }
            case GLOBUS_GK_ENDPOINT: {
                if (o instanceof GlobusGKEndpoint) {
                    return AppCatalogJPAUtils.createGlobusEndpoint((GlobusGKEndpoint)o);
                }
                logger.error("Object should be a GlobusJobSubmission.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GlobusJobSubmission.");
            }
            case SSH_JOB_SUBMISSION: {
                if (o instanceof SshJobSubmission) {
                    return AppCatalogJPAUtils.createSshJobSubmission((SshJobSubmission)o);
                }
                logger.error("Object should be a Ssh Job Submission.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Ssh Job Submission.");
            }
            case ClOUD_SUBMISSION: {
                if (o instanceof CloudJobSubmission) {
                    return AppCatalogJPAUtils.createCloudJobSubmission((CloudJobSubmission)o);
                }
                logger.error("Object should be a Cloud Job Submission.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Cloud Job Submission.");
            }
            case SCP_DATA_MOVEMENT: {
                if (o instanceof ScpDataMovement) {
                    return AppCatalogJPAUtils.createScpDataMovement((ScpDataMovement)o);
                }
                logger.error("Object should be a Scp Data Movement.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Scp Data Movement.");
            }
            case GRIDFTP_DATA_MOVEMENT: {
                if (o instanceof GridftpDataMovement) {
                    return AppCatalogJPAUtils.createGridftpDataMovement((GridftpDataMovement)o);
                }
                logger.error("Object should be a Gridftp Data Movement.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gridftp Data Movement.");
            }
            case GRIDFTP_ENDPOINT: {
                if (o instanceof GridftpEndpoint) {
                    return AppCatalogJPAUtils.createGridftpEndpoint((GridftpEndpoint)o);
                }
                logger.error("Object should be a Gridftp Endpoint.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gridftp Endpoint.");
            }
            case APPLICATION_MODULE: {
                if (o instanceof ApplicationModule) {
                    return AppCatalogJPAUtils.createApplicationModule((ApplicationModule)o);
                }
                logger.error("Object should be a Application Module.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Application Module.");
            }
            case APPLICATION_DEPLOYMENT: {
                if (o instanceof ApplicationDeployment) {
                    return AppCatalogJPAUtils.createApplicationDeployment((ApplicationDeployment)o);
                }
                logger.error("Object should be a Application Deployment.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Application Deployment.");
            }
            case LIBRARY_PREPAND_PATH: {
                if (o instanceof LibraryPrepandPath) {
                    return AppCatalogJPAUtils.createLibraryPrepPathResource((LibraryPrepandPath)o);
                }
                logger.error("Object should be a Library Prepand path.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Library Prepand path.");
            }
            case LIBRARY_APEND_PATH: {
                if (o instanceof LibraryApendPath) {
                    return AppCatalogJPAUtils.createLibraryApendPathResource((LibraryApendPath)o);
                }
                logger.error("Object should be a Library Apend path.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Library Apend.");
            }
            case APP_ENVIRONMENT: {
                if (o instanceof AppEnvironment) {
                    return AppCatalogJPAUtils.createAppEnvironmentResource((AppEnvironment)o);
                }
                logger.error("Object should be a AppEnvironment.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a AppEnvironment.");
            }
            case APPLICATION_INTERFACE: {
                if (o instanceof ApplicationInterface) {
                    return AppCatalogJPAUtils.createAppInterfaceResource((ApplicationInterface)o);
                }
                logger.error("Object should be a ApplicationInterface.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a ApplicationInterface.");
            }
            case APP_MODULE_MAPPING: {
                if (o instanceof AppModuleMapping) {
                    return AppCatalogJPAUtils.createAppModMappingResource((AppModuleMapping)o);
                }
                logger.error("Object should be a AppModuleMapping.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a AppModuleMapping.");
            }
            case APPLICATION_OUTPUT: {
                if (o instanceof ApplicationIntOutput) {
                    return AppCatalogJPAUtils.createApplicationOutput((ApplicationIntOutput)o);
                }
                logger.error("Object should be a ApplicationOutput.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a ApplicationOutput.");
            }
            case GATEWAY_PROFILE: {
                if (o instanceof GatewayProfile) {
                    return AppCatalogJPAUtils.createGatewayProfile((GatewayProfile)o);
                }
                logger.error("Object should be a GatewayProfile.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GatewayProfile.");
            }
            case USER_RESOURCE_PROFILE: {
                if (o instanceof UserResourceProfile) {
                    return AppCatalogJPAUtils.createUserResourceProfile((UserResourceProfile)o);
                }
                logger.error("Object should be a UserResourceProfile.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a UserResourceProfile.");
            }
            case COMPUTE_RESOURCE_PREFERENCE: {
                if (o instanceof ComputeResourcePreference) {
                    return AppCatalogJPAUtils.createComputeResourcePref((ComputeResourcePreference)o);
                }
                logger.error("Object should be a Compute Resource Preference.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Compute Resource Preference.");
            }
            case USER_COMPUTE_RESOURCE_PREFERENCE: {
                if (o instanceof UserComputeResourcePreference) {
                    return AppCatalogJPAUtils.createUserComputeResourcePref((UserComputeResourcePreference)o);
                }
                logger.error("Object should be a User Compute Resource Preference.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User Compute Resource Preference.");
            }
            case STORAGE_PREFERENCE: {
                if (o instanceof StoragePreference) {
                    return AppCatalogJPAUtils.createStoragePref((StoragePreference)o);
                }
                logger.error("Object should be a data storage Preference.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a data storage Preference.");
            }
            case USER_STORAGE_PREFERENCE: {
                if (o instanceof UserStoragePreference) {
                    return AppCatalogJPAUtils.createUserStoragePref((UserStoragePreference)o);
                }
                logger.error("Object should be a User data storage Preference.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User data storage Preference.");
            }
            case STORAGE_RESOURCE: {
                if (o instanceof StorageResource) {
                    return AppCatalogJPAUtils.createStorageResource((StorageResource)o);
                }
                logger.error("Object should be a storage resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a storage resource.");
            }
            case STORAGE_INTERFACE: {
                if (o instanceof StorageInterface) {
                    return AppCatalogJPAUtils.createStorageInterface((StorageInterface)o);
                }
                logger.error("Object should be a storage interface.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a storage interface.");
            }
            case APPLICATION_INPUT: {
                if (o instanceof ApplicationIntInput) {
                    return AppCatalogJPAUtils.createApplicationInput((ApplicationIntInput)o);
                }
                logger.error("Object should be a ApplicationInput.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a ApplicationInput.");
            }
            case BATCH_QUEUE: {
                if (o instanceof BatchQueue) {
                    return AppCatalogJPAUtils.createBatchQueue((BatchQueue)o);
                }
                logger.error("Object should be a Batch Queue.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Batch Queue.");
            }
            case COMPUTE_RESOURCE_FILE_SYSTEM: {
                if (o instanceof ComputeResourceFileSystem) {
                    return AppCatalogJPAUtils.createComputeResourceFileSystem((ComputeResourceFileSystem)o);
                }
                logger.error("Object should be a Compute Resource File System.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Compute Resource File System.");
            }
            case JOB_SUBMISSION_INTERFACE: {
                if (o instanceof JobSubmissionInterface) {
                    return AppCatalogJPAUtils.createJobSubmissionInterface((JobSubmissionInterface)o);
                }
                logger.error("Object should be a Job Submission Interface.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Job Submission Interface.");
            }
            case DATA_MOVEMENT_INTERFACE: {
                if (o instanceof DataMovementInterface) {
                    return AppCatalogJPAUtils.createDataMovementInterface((DataMovementInterface)o);
                }
                logger.error("Object should be a Data Movement Interface.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Data Movement Interface.");
            }
            case RESOURCE_JOB_MANAGER: {
                if (o instanceof ResourceJobManager) {
                    return AppCatalogJPAUtils.createResourceJobManager((ResourceJobManager)o);
                }
                logger.error("Object should be a Resource Job Manager.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Resource Job Manager.");
            }
            case JOB_MANAGER_COMMAND: {
                if (o instanceof JobManagerCommand) {
                    return AppCatalogJPAUtils.createJobManagerCommand((JobManagerCommand)o);
                }
                logger.error("Object should be a Job Manager Command.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Job Manager Command.");
            }
            case PARALLELISM_PREFIX_COMMAND: {
                if (o instanceof ParallelismPrefixCommand) {
                    return AppCatalogJPAUtils.createParallelismCommand((ParallelismPrefixCommand)o);
                }
                logger.error("Object should be a Parallelism Prefix Command.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Parallelism Prefix Command.");
            }
            case LOCAL_SUBMISSION: {
                if (o instanceof LocalSubmission) {
                    return AppCatalogJPAUtils.createLocalSubmission((LocalSubmission)o);
                }
                logger.error("Object should be a Local Submission.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Local Submission.");
            }
            case LOCAL_DATA_MOVEMENT: {
                if (o instanceof LocalDataMovement) {
                    return AppCatalogJPAUtils.createLocalDataMovement((LocalDataMovement)o);
                }
                logger.error("Object should be a Local Data Movement.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Local Data Movement.");
            }
            case MODULE_LOAD_CMD: {
                if (o instanceof ModuleLoadCmd) {
                    return AppCatalogJPAUtils.createModuleLoadCmd((ModuleLoadCmd)o);
                }
                logger.error("Object should be a Module Load Cmd.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Module Load Cmd.");
            }
        }
        logger.error("Illegal data type..", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Illegal data type..");
    }

    private static AppCatalogResource createLocalDataMovement(LocalDataMovement o) {
        LocalDataMovementResource localDataMovementResource = new LocalDataMovementResource();
        if (o != null) {
            localDataMovementResource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
        }
        return localDataMovementResource;
    }

    private static AppCatalogResource createLocalSubmission(LocalSubmission o) {
        LocalSubmissionResource localSubmissionResource = new LocalSubmissionResource();
        if (o != null) {
            localSubmissionResource.setResourceJobManagerId(o.getResourceJobManagerId());
            localSubmissionResource.setResourceJobManagerResource((ResourceJobManagerResource)AppCatalogJPAUtils.createResourceJobManager(o.getResourceJobManager()));
            localSubmissionResource.setJobSubmissionInterfaceId(o.getJobSubmissionInterfaceId());
            localSubmissionResource.setCreatedTime(o.getCreationTime());
            localSubmissionResource.setSecurityProtocol(o.getSecurityProtocol());
            if (o.getUpdateTime() != null) {
                localSubmissionResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return localSubmissionResource;
    }

    private static AppCatalogResource createJobManagerCommand(JobManagerCommand o) {
        JobManagerCommandResource jobManagerCommandResource = new JobManagerCommandResource();
        if (o != null) {
            jobManagerCommandResource.setResourceJobManagerId(o.getResourceJobManagerId());
            jobManagerCommandResource.setResourceJobManagerResource((ResourceJobManagerResource)AppCatalogJPAUtils.createResourceJobManager(o.getResourceJobManager()));
            jobManagerCommandResource.setCommandType(o.getCommandType());
            jobManagerCommandResource.setCommand(o.getCommand());
        }
        return jobManagerCommandResource;
    }

    private static AppCatalogResource createParallelismCommand(ParallelismPrefixCommand o) {
        ParallelismPrefixCommandResource parallelismPrefixCommandResource = new ParallelismPrefixCommandResource();
        if (o != null) {
            parallelismPrefixCommandResource.setResourceJobManagerId(o.getResourceJobManagerId());
            parallelismPrefixCommandResource.setResourceJobManagerResource((ResourceJobManagerResource)AppCatalogJPAUtils.createResourceJobManager(o.getResourceJobManager()));
            parallelismPrefixCommandResource.setCommandType(o.getCommandType());
            parallelismPrefixCommandResource.setCommand(o.getCommand());
        }
        return parallelismPrefixCommandResource;
    }

    private static AppCatalogResource createResourceJobManager(ResourceJobManager o) {
        ResourceJobManagerResource resourceJobManagerResource = new ResourceJobManagerResource();
        if (o != null) {
            resourceJobManagerResource.setResourceJobManagerId(o.getResourceJobManagerId());
            resourceJobManagerResource.setPushMonitoringEndpoint(o.getPushMonitoringEndpoint());
            resourceJobManagerResource.setJobManagerBinPath(o.getJobManagerBinPath());
            resourceJobManagerResource.setResourceJobManagerType(o.getResourceJobManagerType());
            resourceJobManagerResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                resourceJobManagerResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return resourceJobManagerResource;
    }

    private static AppCatalogResource createDataMovementInterface(DataMovementInterface o) {
        DataMovementInterfaceResource dataMovementInterfaceResource = new DataMovementInterfaceResource();
        if (o != null) {
            dataMovementInterfaceResource.setComputeResourceId(o.getComputeResourceId());
            dataMovementInterfaceResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
            dataMovementInterfaceResource.setDataMovementProtocol(o.getDataMovementProtocol());
            dataMovementInterfaceResource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
            dataMovementInterfaceResource.setPriorityOrder(o.getPriorityOrder());
            dataMovementInterfaceResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                dataMovementInterfaceResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return dataMovementInterfaceResource;
    }

    private static AppCatalogResource createJobSubmissionInterface(JobSubmissionInterface o) {
        JobSubmissionInterfaceResource jobSubmissionInterfaceResource = new JobSubmissionInterfaceResource();
        if (o != null) {
            jobSubmissionInterfaceResource.setJobSubmissionInterfaceId(o.getJobSubmissionInterfaceId());
            jobSubmissionInterfaceResource.setComputeResourceId(o.getComputeResourceId());
            jobSubmissionInterfaceResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
            jobSubmissionInterfaceResource.setJobSubmissionProtocol(o.getJobSubmissionProtocol());
            jobSubmissionInterfaceResource.setPriorityOrder(o.getPriorityOrder());
            jobSubmissionInterfaceResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                jobSubmissionInterfaceResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return jobSubmissionInterfaceResource;
    }

    private static AppCatalogResource createComputeResourceFileSystem(ComputeResourceFileSystem o) {
        ComputeResourceFileSystemResource computeResourceFileSystemResource = new ComputeResourceFileSystemResource();
        if (o != null) {
            computeResourceFileSystemResource.setComputeResourceId(o.getComputeResourceId());
            computeResourceFileSystemResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
            computeResourceFileSystemResource.setPath(o.getPath());
            computeResourceFileSystemResource.setFileSystem(o.getFileSystem());
        }
        return computeResourceFileSystemResource;
    }

    private static AppCatalogResource createBatchQueue(BatchQueue o) {
        BatchQueueResource batchQueueResource = new BatchQueueResource();
        if (o != null) {
            batchQueueResource.setComputeResourceId(o.getComputeResourceId());
            batchQueueResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
            batchQueueResource.setMaxRuntime(o.getMaxRuntime());
            batchQueueResource.setMaxJobInQueue(o.getMaxJobInQueue());
            batchQueueResource.setQueueDescription(o.getQueueDescription());
            batchQueueResource.setQueueName(o.getQueueName());
            batchQueueResource.setMaxProcessors(o.getMaxProcessors());
            batchQueueResource.setMaxNodes(o.getMaxNodes());
            batchQueueResource.setMaxMemory(o.getMaxMemory());
            batchQueueResource.setCpuPerNode(o.getCpuPerNode());
            batchQueueResource.setDefaultNodeCount(o.getDefaultNodeCount());
            batchQueueResource.setDefaultCPUCount(o.getDefaultCPUCount());
            batchQueueResource.setDefaultWalltime(o.getDefaultWalltime());
            batchQueueResource.setQueueSpecificMacros(o.getQueueSpecificMacros());
            batchQueueResource.setIsDefaultQueue(o.getIsDefaultQueue());
        }
        return batchQueueResource;
    }

    private static AppCatalogResource createComputeResource(ComputeResource o) {
        ComputeResourceResource computeResourceResource = new ComputeResourceResource();
        if (o != null) {
            computeResourceResource.setResourceDescription(o.getResourceDescription());
            computeResourceResource.setResourceId(o.getResourceId());
            computeResourceResource.setHostName(o.getHostName());
            computeResourceResource.setCreatedTime(o.getCreationTime());
            computeResourceResource.setEnabled(o.getEnabled());
            computeResourceResource.setMaxMemoryPerNode(o.getMaxMemoryPerNode());
            computeResourceResource.setCpusPerNode(o.getCpusPerNode());
            computeResourceResource.setDefaultNodeCount(o.getDefaultNodeCount());
            computeResourceResource.setDefaultCPUCount(o.getDefaultCPUCount());
            computeResourceResource.setDefaultWalltime(o.getDefaultWalltime());
            computeResourceResource.setGatewayUsageExec(o.getGatewayUsageExec());
            computeResourceResource.setGatewayUsageModLoadCMD(o.getGatewayUsageModLoadCMD());
            computeResourceResource.setGatewayUsageReporting(o.isGatewayUsageReporting());
            if (o.getUpdateTime() != null) {
                computeResourceResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return computeResourceResource;
    }

    private static AppCatalogResource createHostAlias(HostAlias o) {
        HostAliasAppResource aliasResource = new HostAliasAppResource();
        if (o != null) {
            aliasResource.setResourceID(o.getResourceID());
            aliasResource.setAlias(o.getAlias());
            aliasResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
        }
        return aliasResource;
    }

    private static AppCatalogResource createHostIPAddress(HostIPAddress o) {
        HostIPAddressResource ipAddressResource = new HostIPAddressResource();
        if (o != null) {
            ipAddressResource.setResourceID(o.getResourceID());
            ipAddressResource.setIpaddress(o.getIpaddress());
            ipAddressResource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
        }
        return ipAddressResource;
    }

    private static AppCatalogResource createGSSISSHSubmission(GSISSHSubmission o) {
        GSISSHSubmissionResource submissionResource = new GSISSHSubmissionResource();
        if (o != null) {
            submissionResource.setSubmissionID(o.getSubmissionID());
            submissionResource.setResourceJobManager(o.getResourceJobManager());
            submissionResource.setSshPort(o.getSshPort());
            submissionResource.setInstalledPath(o.getInstalledPath());
            submissionResource.setMonitorMode(o.getMonitorMode());
        }
        return submissionResource;
    }

    private static AppCatalogResource createUnicoreJobSubmission(UnicoreJobSubmission o) {
        UnicoreJobSubmissionResource submissionResource = new UnicoreJobSubmissionResource();
        if (o != null) {
            submissionResource.setjobSubmissionInterfaceId(o.getSubmissionID());
            submissionResource.setUnicoreEndpointUrl(o.getUnicoreEndpointUrl());
            submissionResource.setSecurityProtocol(o.getSecurityProtocol());
        }
        return submissionResource;
    }

    private static AppCatalogResource createUnicoreDataMovement(UnicoreDataMovement o) {
        UnicoreDataMovementResource dataMovementResource = new UnicoreDataMovementResource();
        if (o != null) {
            dataMovementResource.setDataMovementId(o.getDataMovementId());
            dataMovementResource.setUnicoreEndpointUrl(o.getUnicoreEndpointUrl());
            dataMovementResource.setSecurityProtocol(o.getSecurityProtocol());
        }
        return dataMovementResource;
    }

    private static AppCatalogResource createGSISSHExport(GSISSHExport o) {
        GSISSHExportResource resource = new GSISSHExportResource();
        if (o != null) {
            resource.setSubmissionID(o.getSubmissionID());
            resource.setExport(o.getExport());
            resource.setGsisshSubmissionResource((GSISSHSubmissionResource)AppCatalogJPAUtils.createGSSISSHSubmission(o.getGsisshJobSubmission()));
        }
        return resource;
    }

    private static AppCatalogResource createPreJobCommand(PreJobCommand o) {
        PreJobCommandResource resource = new PreJobCommandResource();
        if (o != null) {
            resource.setAppDeploymentId(o.getDeploymentId());
            resource.setCommand(o.getCommand());
            resource.setOrder(o.getOrder());
            resource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getApplicationDeployment()));
        }
        return resource;
    }

    private static AppCatalogResource createPostJObCommand(PostJobCommand o) {
        PostJobCommandResource resource = new PostJobCommandResource();
        if (o != null) {
            resource.setAppDeploymentId(o.getDeploymentId());
            resource.setCommand(o.getCommand());
            resource.setOrder(o.getOrder());
            resource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getDeployment()));
        }
        return resource;
    }

    private static AppCatalogResource createGlobusJobSubmission(GlobusJobSubmission o) {
        GlobusJobSubmissionResource resource = new GlobusJobSubmissionResource();
        if (o != null) {
            resource.setSubmissionID(o.getSubmissionID());
            resource.setResourceJobManager(o.getResourceJobManager());
            resource.setSecurityProtocol(o.getSecurityProtocol());
        }
        return resource;
    }

    private static AppCatalogResource createGlobusEndpoint(GlobusGKEndpoint o) {
        GlobusGKEndpointResource resource = new GlobusGKEndpointResource();
        if (o != null) {
            resource.setSubmissionID(o.getSubmissionID());
            resource.setEndpoint(o.getEndpoint());
            resource.setGlobusJobSubmissionResource((GlobusJobSubmissionResource)AppCatalogJPAUtils.createGlobusJobSubmission(o.getGlobusSubmission()));
        }
        return resource;
    }

    private static AppCatalogResource createSshJobSubmission(SshJobSubmission o) {
        SshJobSubmissionResource sshJobSubmissionResource = new SshJobSubmissionResource();
        if (o != null) {
            sshJobSubmissionResource.setResourceJobManagerId(o.getResourceJobManagerId());
            sshJobSubmissionResource.setResourceJobManagerResource((ResourceJobManagerResource)AppCatalogJPAUtils.createResourceJobManager(o.getResourceJobManager()));
            sshJobSubmissionResource.setJobSubmissionInterfaceId(o.getJobSubmissionInterfaceId());
            sshJobSubmissionResource.setAlternativeSshHostname(o.getAlternativeSshHostname());
            sshJobSubmissionResource.setSecurityProtocol(o.getSecurityProtocol());
            sshJobSubmissionResource.setSshPort(o.getSshPort());
            sshJobSubmissionResource.setMonitorMode(o.getMonitorMode());
            sshJobSubmissionResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                sshJobSubmissionResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return sshJobSubmissionResource;
    }

    private static AppCatalogResource createCloudJobSubmission(CloudJobSubmission o) {
        CloudSubmissionResource cloudSubmissionResource = new CloudSubmissionResource();
        if (o != null) {
            cloudSubmissionResource.setJobSubmissionInterfaceId(o.getJobSubmissionInterfaceId());
            cloudSubmissionResource.setSecurityProtocol(o.getSecurityProtocol());
            cloudSubmissionResource.setExecutableType(o.getExecutableType());
            cloudSubmissionResource.setUserAccountName(o.getUserAccountName());
            cloudSubmissionResource.setNodeId(o.getNodeId());
            cloudSubmissionResource.setProviderName(o.getProviderName());
        }
        return cloudSubmissionResource;
    }

    private static AppCatalogResource createScpDataMovement(ScpDataMovement o) {
        ScpDataMovementResource scpDataMovementResource = new ScpDataMovementResource();
        if (o != null) {
            scpDataMovementResource.setQueueDescription(o.getQueueDescription());
            scpDataMovementResource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
            scpDataMovementResource.setSecurityProtocol(o.getSecurityProtocol());
            scpDataMovementResource.setAlternativeScpHostname(o.getAlternativeScpHostname());
            scpDataMovementResource.setSshPort(o.getSshPort());
            scpDataMovementResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                scpDataMovementResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return scpDataMovementResource;
    }

    private static AppCatalogResource createGridftpDataMovement(GridftpDataMovement o) {
        GridftpDataMovementResource gridftpDataMovementResource = new GridftpDataMovementResource();
        if (o != null) {
            gridftpDataMovementResource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
            gridftpDataMovementResource.setSecurityProtocol(o.getSecurityProtocol());
            gridftpDataMovementResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                gridftpDataMovementResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return gridftpDataMovementResource;
    }

    private static AppCatalogResource createGridftpEndpoint(GridftpEndpoint o) {
        GridftpEndpointResource gridftpEndpointResource = new GridftpEndpointResource();
        if (o != null) {
            gridftpEndpointResource.setEndpoint(o.getEndpoint());
            gridftpEndpointResource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
            gridftpEndpointResource.setGridftpDataMovementResource((GridftpDataMovementResource)AppCatalogJPAUtils.createGridftpDataMovement(o.getGridftpDataMovement()));
            gridftpEndpointResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                gridftpEndpointResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return gridftpEndpointResource;
    }

    private static AppCatalogResource createApplicationModule(ApplicationModule o) {
        AppModuleResource moduleResource = new AppModuleResource();
        if (o != null) {
            moduleResource.setModuleId(o.getModuleID());
            moduleResource.setModuleDesc(o.getModuleDesc());
            moduleResource.setGatewayId(o.getGatewayId());
            moduleResource.setModuleName(o.getModuleName());
            moduleResource.setModuleVersion(o.getModuleVersion());
            moduleResource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                moduleResource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return moduleResource;
    }

    private static AppCatalogResource createApplicationDeployment(ApplicationDeployment o) {
        AppDeploymentResource resource = new AppDeploymentResource();
        if (o != null) {
            resource.setDeploymentId(o.getDeploymentID());
            resource.setAppDes(o.getApplicationDesc());
            resource.setAppModuleId(o.getAppModuleID());
            resource.setHostId(o.getHostID());
            resource.setExecutablePath(o.getExecutablePath());
            resource.setGatewayId(o.getGatewayId());
            resource.setParallelism(o.getParallelism());
            resource.setDefaultQueueName(o.getDefaultQueueName());
            resource.setDefaultNodeCount(o.getDefaultNodeCount());
            resource.setDefaultCPUCount(o.getDefaultCPUCount());
            resource.setDefaultWalltime(o.getDefaultWalltime());
            resource.setEditableByUser(o.isEditableByUser());
            resource.setModuleResource((AppModuleResource)AppCatalogJPAUtils.createApplicationModule(o.getApplicationModule()));
            resource.setHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeResource()));
            resource.setCreatedTime(o.getCreationTime());
            if (o.getUpdateTime() != null) {
                resource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return resource;
    }

    private static AppCatalogResource createLibraryPrepPathResource(LibraryPrepandPath o) {
        LibraryPrepandPathResource resource = new LibraryPrepandPathResource();
        if (o != null) {
            resource.setDeploymentId(o.getDeploymentID());
            resource.setName(o.getName());
            resource.setValue(o.getValue());
            resource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getApplicationDeployment()));
        }
        return resource;
    }

    private static AppCatalogResource createLibraryApendPathResource(LibraryApendPath o) {
        LibraryApendPathResource resource = new LibraryApendPathResource();
        if (o != null) {
            resource.setDeploymentId(o.getDeploymentID());
            resource.setName(o.getName());
            resource.setValue(o.getValue());
            resource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getApplicationDeployment()));
        }
        return resource;
    }

    private static AppCatalogResource createAppEnvironmentResource(AppEnvironment o) {
        AppEnvironmentResource resource = new AppEnvironmentResource();
        if (o != null) {
            resource.setDeploymentId(o.getDeploymentID());
            resource.setName(o.getName());
            resource.setValue(o.getValue());
            resource.setOrder(o.getOrder());
            resource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getApplicationDeployment()));
        }
        return resource;
    }

    private static AppCatalogResource createAppInterfaceResource(ApplicationInterface o) {
        AppInterfaceResource resource = new AppInterfaceResource();
        if (o != null) {
            resource.setInterfaceId(o.getInterfaceID());
            resource.setAppName(o.getAppName());
            resource.setAppDescription(o.getAppDescription());
            resource.setCreatedTime(o.getCreationTime());
            resource.setGatewayId(o.getGatewayId());
            resource.setArchiveWorkingDirectory(o.isArchiveWorkingDirectory());
            resource.setHasOptionalFileInputs(o.isHasOptionalFileInputs());
            if (o.getUpdateTime() != null) {
                resource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return resource;
    }

    private static AppCatalogResource createAppModMappingResource(AppModuleMapping o) {
        AppModuleMappingAppCatalogResourceAppCat resource = new AppModuleMappingAppCatalogResourceAppCat();
        if (o != null) {
            resource.setInterfaceId(o.getInterfaceID());
            resource.setModuleId(o.getModuleID());
        }
        return resource;
    }

    private static AppCatalogResource createApplicationInput(ApplicationIntInput o) {
        ApplicationInputResource resource = new ApplicationInputResource();
        if (o != null) {
            resource.setInterfaceID(o.getInterfaceID());
            resource.setInputKey(o.getInputKey());
            resource.setInputVal(o.getInputVal());
            resource.setDataType(o.getDataType());
            resource.setMetadata(o.getMetadata());
            resource.setAppArgument(o.getAppArgument());
            resource.setUserFriendlyDesc(o.getUserFriendlyDesc());
            resource.setStandardInput(o.isStandardInput());
            resource.setInputOrder(o.getInputOrder());
            resource.setRequired(o.isRequired());
            resource.setRequiredToCMD(o.isRequiredToCMD());
            resource.setDataStaged(o.isDataStaged());
            resource.setIsReadOnly(o.isReadOnly());
            resource.setAppInterfaceResource((AppInterfaceResource)AppCatalogJPAUtils.createAppInterfaceResource(o.getApplicationInterface()));
        }
        return resource;
    }

    private static AppCatalogResource createApplicationOutput(ApplicationIntOutput o) {
        ApplicationOutputResource resource = new ApplicationOutputResource();
        if (o != null) {
            resource.setInterfaceID(o.getInterfaceID());
            resource.setOutputKey(o.getOutputKey());
            resource.setOutputVal(o.getOutputVal());
            resource.setDataType(o.getDataType());
            resource.setRequired(o.isRequired());
            resource.setRequiredToCMD(o.isRequiredToCMD());
            resource.setDataMovement(o.isDataMovement());
            resource.setDataNameLocation(o.getDataNameLocation());
            resource.setSearchQuery(o.getSearchQuery());
            resource.setAppArgument(o.getApplicationArgument());
            resource.setOutputStreaming(o.isOutputStreaming());
            resource.setAppInterfaceResource((AppInterfaceResource)AppCatalogJPAUtils.createAppInterfaceResource(o.getApplicationInterface()));
        }
        return resource;
    }

    private static AppCatalogResource createGatewayProfile(GatewayProfile o) {
        GatewayProfileResource resource = new GatewayProfileResource();
        if (o != null) {
            resource.setGatewayID(o.getGatewayID());
            resource.setCreatedTime(o.getCreationTime());
            resource.setCredentialStoreToken(o.getCredentialStoreToken());
            resource.setIdentityServerTenant(o.getIdentityServerTenant());
            resource.setIdentityServerPwdCredToken(o.getIdentityServerPwdCredToken());
            if (o.getUpdateTime() != null) {
                resource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return resource;
    }

    private static AppCatalogResource createUserResourceProfile(UserResourceProfile o) {
        UserResourceProfileResource resource = new UserResourceProfileResource();
        if (o != null) {
            resource.setGatewayID(o.getGatewayID());
            resource.setUserId(o.getUserID());
            resource.setCreatedTime(o.getCreationTime());
            resource.setCredentialStoreToken(o.getCredentialStoreToken());
            resource.setIdentityServerTenant(o.getIdentityServerTenant());
            resource.setIdentityServerPwdCredToken(o.getIdentityServerPwdCredToken());
            if (o.getUpdateTime() != null) {
                resource.setUpdatedTime(o.getUpdateTime());
            }
        }
        return resource;
    }

    private static AppCatalogResource createComputeResourcePref(ComputeResourcePreference o) {
        ComputeHostPreferenceResource resource = new ComputeHostPreferenceResource();
        if (o != null) {
            resource.setGatewayId(o.getGatewayId());
            resource.setResourceId(o.getResourceId());
            resource.setOverrideByAiravata(o.isOverrideByAiravata());
            resource.setPreferredJobProtocol(o.getPreferedJobSubmissionProtocol());
            resource.setPreferedDMProtocol(o.getPreferedDataMoveProtocol());
            resource.setBatchQueue(o.getBatchQueue());
            resource.setScratchLocation(o.getScratchLocation());
            resource.setProjectNumber(o.getProjectNumber());
            resource.setLoginUserName(o.getLoginUserName());
            resource.setResourceCSToken(o.getComputeResourceCSToken());
            resource.setUsageReportingGatewayId(o.getUsageReportingGWId());
            resource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeHostResource()));
            resource.setGatewayProfile((GatewayProfileResource)AppCatalogJPAUtils.createGatewayProfile(o.getGatewayProfile()));
            resource.setQualityOfService(o.getQualityOfService());
            resource.setReservation(o.getReservation());
            resource.setReservationStartTime(o.getReservationStartTime());
            resource.setReservationEndTime(o.getReservationEndTime());
            resource.setSshAccountProvisioner(o.getSshAccountProvisioner());
            if (o.getSshAccountProvisionerConfigurations() != null && !o.getSshAccountProvisionerConfigurations().isEmpty()) {
                HashMap<String, String> sshAccountProvisionerConfigurations = new HashMap<String, String>();
                for (SSHAccountProvisionerConfiguration config : o.getSshAccountProvisionerConfigurations()) {
                    sshAccountProvisionerConfigurations.put(config.getConfigName(), config.getConfigValue());
                }
                resource.setSshAccountProvisionerConfigurations(sshAccountProvisionerConfigurations);
            }
            resource.setSshAccountProvisionerAdditionalInfo(o.getSshAccountProvisionerAdditionalInfo());
        }
        return resource;
    }

    private static AppCatalogResource createUserComputeResourcePref(UserComputeResourcePreference o) {
        UserComputeHostPreferenceResource resource = new UserComputeHostPreferenceResource();
        if (o != null) {
            resource.setGatewayId(o.getGatewayID());
            resource.setUserId(o.getUserId());
            resource.setResourceId(o.getResourceId());
            resource.setBatchQueue(o.getBatchQueue());
            resource.setScratchLocation(o.getScratchLocation());
            resource.setProjectNumber(o.getProjectNumber());
            resource.setLoginUserName(o.getLoginUserName());
            resource.setResourceCSToken(o.getComputeResourceCSToken());
            resource.setComputeHostResource((ComputeResourceResource)AppCatalogJPAUtils.createComputeResource(o.getComputeHostResource()));
            resource.setUserResourceProfileResource((UserResourceProfileResource)AppCatalogJPAUtils.createUserResourceProfile(o.getUserResouceProfile()));
            resource.setQualityOfService(o.getQualityOfService());
            resource.setReservation(o.getReservation());
            resource.setReservationStartTime(o.getReservationStartTime());
            resource.setReservationEndTime(o.getReservationEndTime());
            resource.setValidated(o.isValidated());
        }
        return resource;
    }

    private static AppCatalogResource createStoragePref(StoragePreference o) {
        StoragePreferenceResource resource = new StoragePreferenceResource();
        if (o != null) {
            resource.setGatewayId(o.getGatewayId());
            resource.setStorageResourceId(o.getStorageResourceId());
            resource.setLoginUserName(o.getLoginUserName());
            resource.setResourceCSToken(o.getComputeResourceCSToken());
            resource.setFsRootLocation(o.getFsRootLocation());
            resource.setGatewayProfile((GatewayProfileResource)AppCatalogJPAUtils.createGatewayProfile(o.getGatewayProfile()));
        }
        return resource;
    }

    private static AppCatalogResource createUserStoragePref(UserStoragePreference o) {
        UserStoragePreferenceResource resource = new UserStoragePreferenceResource();
        if (o != null) {
            resource.setGatewayId(o.getGatewayID());
            resource.setUserId(o.getUserId());
            resource.setStorageResourceId(o.getStorageResourceId());
            resource.setLoginUserName(o.getLoginUserName());
            resource.setResourceCSToken(o.getComputeResourceCSToken());
            resource.setFsRootLocation(o.getFsRootLocation());
            resource.setUserResourceProfileResource((UserResourceProfileResource)AppCatalogJPAUtils.createUserResourceProfile(o.getUserResourceProfile()));
        }
        return resource;
    }

    private static AppCatalogResource createStorageResource(StorageResource o) {
        StorageResourceResource resource = new StorageResourceResource();
        if (o != null) {
            resource.setStorageResourceId(o.getStorageResourceId());
            resource.setHostName(o.getHostName());
            resource.setEnabled(o.getEnabled());
            resource.setResourceDescription(o.getDescription());
        }
        return resource;
    }

    private static AppCatalogResource createStorageInterface(StorageInterface o) {
        StorageInterfaceResource resource = new StorageInterfaceResource();
        if (o != null) {
            resource.setStorageResourceId(o.getStorageResourceId());
            resource.setDataMovementInterfaceId(o.getDataMovementInterfaceId());
            resource.setDataMovementProtocol(o.getDataMovementProtocol());
            resource.setPriorityOrder(o.getPriorityOrder());
            resource.setStorageResourceResource((StorageResourceResource)AppCatalogJPAUtils.createStorageResource(o.getStorageResource()));
        }
        return resource;
    }

    private static AppCatalogResource createModuleLoadCmd(ModuleLoadCmd o) {
        ModuleLoadCmdResource moduleLoadCmdResource = new ModuleLoadCmdResource();
        if (o != null) {
            moduleLoadCmdResource.setCmd(o.getCmd());
            moduleLoadCmdResource.setAppDeploymentId(o.getAppDeploymentId());
            moduleLoadCmdResource.setOrder(o.getOrder());
            moduleLoadCmdResource.setAppDeploymentResource((AppDeploymentResource)AppCatalogJPAUtils.createApplicationDeployment(o.getApplicationDeployment()));
        }
        return moduleLoadCmdResource;
    }
}

