/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.utils.CarbonUtils;

public class CarbonConfigurationContextFactory {
    private static Log log = LogFactory.getLog(CarbonConfigurationContextFactory.class);
    private static ConfigurationContext configCtx;

    public static ConfigurationContext getConfigurationContext() {
        CarbonUtils.checkSecurity();
        return configCtx;
    }

    public static ConfigurationContext createNewConfigurationContext(AxisConfigurator configurator, BundleContext bundleContext) throws AxisFault {
        CarbonUtils.checkSecurity();
        configCtx = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)configurator);
        configCtx.setProperty("primaryBundleContext", (Object)bundleContext);
        return configCtx;
    }

    public static void clear() {
        CarbonUtils.checkSecurity();
        if (configCtx != null) {
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            if (axisConfig != null) {
                axisConfig.cleanup();
            }
            try {
                configCtx.terminate();
            }
            catch (AxisFault e) {
                log.error((Object)"Error occurred while terminating ConfigurationContext", (Throwable)e);
            }
            configCtx = null;
        }
    }
}

