/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.saxpath.com.werken.saxpath;

import java.util.LinkedList;
import org.xmlpull.v1.builder.xpath.saxpath.Axis;
import org.xmlpull.v1.builder.xpath.saxpath.SAXPathException;
import org.xmlpull.v1.builder.xpath.saxpath.XPathHandler;
import org.xmlpull.v1.builder.xpath.saxpath.XPathSyntaxException;
import org.xmlpull.v1.builder.xpath.saxpath.com.werken.saxpath.DefaultXPathHandler;
import org.xmlpull.v1.builder.xpath.saxpath.com.werken.saxpath.Token;
import org.xmlpull.v1.builder.xpath.saxpath.com.werken.saxpath.TokenTypes;
import org.xmlpull.v1.builder.xpath.saxpath.com.werken.saxpath.XPathLexer;

public class XPathReader
implements org.xmlpull.v1.builder.xpath.saxpath.XPathReader,
TokenTypes {
    private LinkedList tokens;
    private XPathLexer lexer;
    private XPathHandler handler;

    public XPathReader() {
        this.setXPathHandler(DefaultXPathHandler.getInstance());
    }

    @Override
    public void setXPathHandler(XPathHandler handler) {
        this.handler = handler;
    }

    @Override
    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    @Override
    public void parse(String xpath) throws SAXPathException {
        this.setUpParse(xpath);
        this.getXPathHandler().startXPath();
        this.expr();
        this.getXPathHandler().endXPath();
        if (this.LA(1) != -1) {
            this.throwUnexpected();
        }
        this.lexer = null;
        this.tokens = null;
    }

    void setUpParse(String xpath) {
        this.tokens = new LinkedList();
        this.lexer = new XPathLexer(xpath);
    }

    void pathExpr() throws SAXPathException {
        this.getXPathHandler().startPathExpr();
        switch (this.LA(1)) {
            case 1: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                this.filterExpr();
                if (this.LA(1) != 11 && this.LA(1) != 12) break;
                this.locationPath(false);
                break;
            }
            case 15: {
                if (this.LA(2) == 1 && !this.isNodeTypeName(this.LT(1))) {
                    this.filterExpr();
                    if (this.LA(1) != 11 && this.LA(1) != 12) break;
                    this.locationPath(false);
                    break;
                }
                this.locationPath(false);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                this.locationPath(false);
                break;
            }
            case 11: 
            case 12: {
                this.locationPath(true);
                break;
            }
            default: {
                this.throwUnexpected();
            }
        }
        this.getXPathHandler().endPathExpr();
    }

    void numberDouble() throws SAXPathException {
        Token token = this.match(31);
        this.getXPathHandler().number(Double.parseDouble(token.getTokenText()));
    }

    void numberInteger() throws SAXPathException {
        Token token = this.match(30);
        this.getXPathHandler().number(Integer.parseInt(token.getTokenText()));
    }

    void literal() throws SAXPathException {
        Token token = this.match(27);
        this.getXPathHandler().literal(token.getTokenText());
    }

    void functionCall() throws SAXPathException {
        String prefix = null;
        String functionName = null;
        if (this.LA(2) == 18) {
            prefix = this.match(15).getTokenText();
            this.match(18);
        } else {
            prefix = "";
        }
        functionName = this.match(15).getTokenText();
        this.getXPathHandler().startFunction(prefix, functionName);
        this.match(1);
        this.arguments();
        this.match(2);
        this.getXPathHandler().endFunction();
    }

    void arguments() throws SAXPathException {
        while (this.LA(1) != 2) {
            this.expr();
            if (this.LA(1) != 32) break;
            this.match(32);
        }
    }

    void filterExpr() throws SAXPathException {
        this.getXPathHandler().startFilterExpr();
        switch (this.LA(1)) {
            case 30: {
                this.numberInteger();
                break;
            }
            case 31: {
                this.numberDouble();
                break;
            }
            case 27: {
                this.literal();
                break;
            }
            case 1: {
                this.match(1);
                this.expr();
                this.match(2);
                break;
            }
            case 15: {
                this.functionCall();
                break;
            }
            case 26: {
                this.variableReference();
            }
        }
        this.predicates();
        this.getXPathHandler().endFilterExpr();
    }

    void variableReference() throws SAXPathException {
        this.match(26);
        String prefix = null;
        String variableName = null;
        if (this.LA(2) == 18) {
            prefix = this.match(15).getTokenText();
            this.match(18);
        } else {
            prefix = "";
        }
        variableName = this.match(15).getTokenText();
        this.getXPathHandler().variableReference(prefix, variableName);
    }

    void locationPath(boolean isAbsolute) throws SAXPathException {
        switch (this.LA(1)) {
            case 11: 
            case 12: {
                if (isAbsolute) {
                    this.absoluteLocationPath();
                    break;
                }
                this.relativeLocationPath();
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                this.relativeLocationPath();
                break;
            }
            default: {
                this.throwUnexpected();
            }
        }
    }

    void absoluteLocationPath() throws SAXPathException {
        this.getXPathHandler().startAbsoluteLocationPath();
        block0 : switch (this.LA(1)) {
            case 11: {
                this.match(11);
                switch (this.LA(1)) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: {
                        this.steps();
                        break block0;
                    }
                    case -1: {
                        return;
                    }
                }
                break;
            }
            case 12: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(12);
                switch (this.LA(1)) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: {
                        this.steps();
                    }
                }
            }
        }
        this.getXPathHandler().endAbsoluteLocationPath();
    }

    void relativeLocationPath() throws SAXPathException {
        this.getXPathHandler().startRelativeLocationPath();
        switch (this.LA(1)) {
            case 11: {
                this.match(11);
                break;
            }
            case 12: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(12);
            }
        }
        this.steps();
        this.getXPathHandler().endRelativeLocationPath();
    }

    void steps() throws SAXPathException {
        switch (this.LA(1)) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                this.step(true);
                break;
            }
            case -1: {
                return;
            }
            default: {
                this.throwSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
            }
        }
        block11: while (true) {
            if (this.LA(1) == 11 || this.LA(1) == 12) {
                switch (this.LA(1)) {
                    case 11: {
                        this.match(11);
                        break;
                    }
                    case 12: {
                        this.getXPathHandler().startAllNodeStep(12);
                        this.getXPathHandler().endAllNodeStep();
                        this.match(12);
                    }
                }
            } else {
                return;
            }
            switch (this.LA(1)) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: {
                    this.step(false);
                    continue block11;
                }
            }
            this.throwSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
        }
    }

    void step(boolean first) throws SAXPathException {
        int axis = 0;
        switch (this.LA(1)) {
            case 13: 
            case 14: {
                this.abbrStep();
                return;
            }
            case 16: {
                axis = this.axisSpecifier();
                break;
            }
            case 15: {
                if (this.LA(2) == 19) {
                    axis = this.axisSpecifier();
                    break;
                }
                axis = 1;
                break;
            }
            case 20: {
                axis = 1;
            }
        }
        this.nodeTest(axis);
    }

    int axisSpecifier() throws SAXPathException {
        int axis = 0;
        switch (this.LA(1)) {
            case 16: {
                this.match(16);
                axis = 9;
                break;
            }
            case 15: {
                Token token = this.LT(1);
                axis = Axis.lookup(token.getTokenText());
                if (axis == 0) {
                    this.throwInvalidAxis(token.getTokenText());
                }
                this.match(15);
                this.match(19);
                break;
            }
        }
        return axis;
    }

    void nodeTest(int axis) throws SAXPathException {
        block0 : switch (this.LA(1)) {
            case 15: {
                switch (this.LA(2)) {
                    case 1: {
                        this.nodeTypeTest(axis);
                        break block0;
                    }
                }
                this.nameTest(axis);
                break;
            }
            case 20: {
                this.nameTest(axis);
            }
        }
    }

    void nodeTypeTest(int axis) throws SAXPathException {
        Token nodeTypeToken = this.match(15);
        String nodeType = nodeTypeToken.getTokenText();
        this.match(1);
        if ("processing-instruction".equals(nodeType)) {
            String piName = "";
            if (this.LA(1) == 27) {
                piName = this.match(27).getTokenText();
            }
            this.match(2);
            this.getXPathHandler().startProcessingInstructionNodeStep(axis, piName);
            this.predicates();
            this.getXPathHandler().endProcessingInstructionNodeStep();
        } else if ("node".equals(nodeType)) {
            this.match(2);
            this.getXPathHandler().startAllNodeStep(axis);
            this.predicates();
            this.getXPathHandler().endAllNodeStep();
        } else if ("text".equals(nodeType)) {
            this.match(2);
            this.getXPathHandler().startTextNodeStep(axis);
            this.predicates();
            this.getXPathHandler().endTextNodeStep();
        } else if ("comment".equals(nodeType)) {
            this.match(2);
            this.getXPathHandler().startCommentNodeStep(axis);
            this.predicates();
            this.getXPathHandler().endCommentNodeStep();
        } else {
            this.throwSyntaxException("Expected node-type");
        }
    }

    void nameTest(int axis) throws SAXPathException {
        String prefix = null;
        String localName = null;
        switch (this.LA(2)) {
            case 18: {
                switch (this.LA(1)) {
                    case 15: {
                        prefix = this.match(15).getTokenText();
                        this.match(18);
                    }
                }
            }
        }
        switch (this.LA(1)) {
            case 15: {
                localName = this.match(15).getTokenText();
                break;
            }
            case 20: {
                this.match(20);
                localName = "*";
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        this.getXPathHandler().startNameStep(axis, prefix, localName);
        this.predicates();
        this.getXPathHandler().endNameStep();
    }

    void abbrStep() throws SAXPathException {
        switch (this.LA(1)) {
            case 13: {
                this.match(13);
                this.getXPathHandler().startAllNodeStep(11);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
                break;
            }
            case 14: {
                this.match(14);
                this.getXPathHandler().startAllNodeStep(3);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
            }
        }
    }

    void predicates() throws SAXPathException {
        while (this.LA(1) == 3) {
            this.predicate();
        }
    }

    void predicate() throws SAXPathException {
        this.getXPathHandler().startPredicate();
        this.match(3);
        this.predicateExpr();
        this.match(4);
        this.getXPathHandler().endPredicate();
    }

    void predicateExpr() throws SAXPathException {
        this.expr();
    }

    void expr() throws SAXPathException {
        this.orExpr();
    }

    void orExpr() throws SAXPathException {
        this.getXPathHandler().startOrExpr();
        this.andExpr();
        boolean create = false;
        switch (this.LA(1)) {
            case 29: {
                create = true;
                this.match(29);
                this.orExpr();
            }
        }
        this.getXPathHandler().endOrExpr(create);
    }

    void andExpr() throws SAXPathException {
        this.getXPathHandler().startAndExpr();
        this.equalityExpr();
        boolean create = false;
        switch (this.LA(1)) {
            case 28: {
                create = true;
                this.match(28);
                this.andExpr();
            }
        }
        this.getXPathHandler().endAndExpr(create);
    }

    void equalityExpr() throws SAXPathException {
        this.getXPathHandler().startEqualityExpr();
        this.relationalExpr();
        int operator = 0;
        switch (this.LA(1)) {
            case 21: {
                this.match(21);
                this.equalityExpr();
                operator = 1;
                break;
            }
            case 22: {
                this.match(22);
                this.equalityExpr();
                operator = 2;
            }
        }
        this.getXPathHandler().endEqualityExpr(operator);
    }

    void relationalExpr() throws SAXPathException {
        this.getXPathHandler().startRelationalExpr();
        this.additiveExpr();
        int operator = 0;
        switch (this.LA(1)) {
            case 7: {
                this.match(7);
                this.relationalExpr();
                operator = 3;
                break;
            }
            case 9: {
                this.match(9);
                this.relationalExpr();
                operator = 5;
                break;
            }
            case 8: {
                this.match(8);
                this.relationalExpr();
                operator = 4;
                break;
            }
            case 10: {
                this.match(10);
                this.relationalExpr();
                operator = 6;
            }
        }
        this.getXPathHandler().endRelationalExpr(operator);
    }

    void additiveExpr() throws SAXPathException {
        this.getXPathHandler().startAdditiveExpr();
        this.multiplicativeExpr();
        int operator = 0;
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                operator = 7;
                this.additiveExpr();
                break;
            }
            case 6: {
                this.match(6);
                operator = 8;
                this.additiveExpr();
            }
        }
        this.getXPathHandler().endAdditiveExpr(operator);
    }

    void multiplicativeExpr() throws SAXPathException {
        this.getXPathHandler().startMultiplicativeExpr();
        this.unaryExpr();
        int operator = 0;
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                this.multiplicativeExpr();
                operator = 9;
                break;
            }
            case 24: {
                this.match(24);
                this.multiplicativeExpr();
                operator = 11;
                break;
            }
            case 25: {
                this.match(25);
                this.multiplicativeExpr();
                operator = 10;
            }
        }
        this.getXPathHandler().endMultiplicativeExpr(operator);
    }

    void unaryExpr() throws SAXPathException {
        this.getXPathHandler().startUnaryExpr();
        int operator = 0;
        switch (this.LA(1)) {
            case 6: {
                this.match(6);
                operator = 12;
                this.unaryExpr();
                break;
            }
            default: {
                this.unionExpr();
            }
        }
        this.getXPathHandler().endUnaryExpr(operator);
    }

    void unionExpr() throws SAXPathException {
        this.getXPathHandler().startUnionExpr();
        this.pathExpr();
        boolean create = false;
        switch (this.LA(1)) {
            case 17: {
                this.match(17);
                create = true;
                this.expr();
            }
        }
        this.getXPathHandler().endUnionExpr(create);
    }

    Token match(int tokenType) {
        this.LT(1);
        Token token = (Token)this.tokens.get(0);
        if (token.getTokenType() == tokenType) {
            this.tokens.removeFirst();
            return token;
        }
        return null;
    }

    int LA(int position) {
        return this.LT(position).getTokenType();
    }

    Token LT(int position) {
        if (this.tokens.size() <= position - 1) {
            for (int i = 0; i < position; ++i) {
                this.tokens.add(this.lexer.nextToken());
            }
        }
        return (Token)this.tokens.get(position - 1);
    }

    boolean isNodeTypeName(Token name) {
        String text = name.getTokenText();
        return "node".equals(text) || "comment".equals(text) || "text".equals(text) || "processing-instruction".equals(text);
    }

    void throwSyntaxException(String message) throws SAXPathException {
        String xpath = this.lexer.getXPath();
        int position = this.LT(1).getTokenBegin();
        throw new XPathSyntaxException(xpath, position, message);
    }

    void throwInvalidAxis(String invalidAxis) throws SAXPathException {
        String xpath = this.lexer.getXPath();
        int position = this.LT(1).getTokenBegin();
        String message = "Expected valid axis name instead of [" + invalidAxis + "]";
        throw new XPathSyntaxException(xpath, position, message);
    }

    void throwUnexpected() throws SAXPathException {
        this.throwSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
    }
}

