/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.error.AuthenticationException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.AuthResponse;
import org.apache.airavata.service.security.oauth.DefaultOAuthClient;
import org.apache.airavata.service.security.xacml.DefaultXACMLPEP;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static String username = "scigap_admin";
    private static String password = "sci9067@min";
    private static String hostName = "https://idp.scigap.org:7443";
    private static String clientId = "O3iUdkkVYyHgzWPiVTQpY_tb96Ma";
    private static String clientSecret = "6Ck1jZoa2oRtrzodSqkUZ2iINkUa";

    public static void main(String[] args) throws AuthenticationException, AiravataSecurityException, AxisFault {
        String accessToken = Main.authenticate("master@master.airavata", "master").getAccess_token();
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        DefaultOAuthClient defaultOAuthClient = new DefaultOAuthClient(hostName + "/services/", username, password, configContext);
        OAuth2TokenValidationResponseDTO tokenValidationRequestDTO = defaultOAuthClient.validateAccessToken(accessToken);
        String authorizedUser = tokenValidationRequestDTO.getAuthorizedUser();
        AuthzToken authzToken = new AuthzToken();
        authzToken.setAccessToken(accessToken);
        HashMap<String, String> claimsMap = new HashMap<String, String>();
        claimsMap.put("userName", "scigap_admin");
        claimsMap.put("api.method.name", "/airavata/getAPIVersion");
        authzToken.setClaimsMap(claimsMap);
        DefaultXACMLPEP defaultXACMLPEP = new DefaultXACMLPEP(hostName + "/services/", username, password, configContext);
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        boolean result = defaultXACMLPEP.getAuthorizationDecision(authzToken, metaDataMap);
        System.out.println(result);
    }

    public static AuthResponse authenticate(String username, String password) throws AuthenticationException {
        try {
            AuthResponse authResponse;
            OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)(hostName + "/oauth2/token")).setClientId(clientId).setClientSecret(clientSecret).setGrantType(GrantType.PASSWORD).setRedirectURI("").setUsername(username).setPassword(password).setScope("openid").buildBodyMessage();
            URLConnectionClient ucc = new URLConnectionClient();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)ucc);
            OAuthResourceResponse resp = (OAuthResourceResponse)oAuthClient.resource(request, "POST", OAuthResourceResponse.class);
            ObjectMapper mapper = new ObjectMapper();
            try {
                authResponse = (AuthResponse)mapper.readValue(resp.getBody(), AuthResponse.class);
            }
            catch (Exception e) {
                return null;
            }
            String accessToken = authResponse.getAccess_token();
            if (accessToken != null && !accessToken.isEmpty()) {
                request = new OAuthBearerClientRequest(hostName + "/oauth2/userinfo?schema=openid").buildQueryMessage();
                ucc = new URLConnectionClient();
                request.setHeader("Authorization", "Bearer " + accessToken);
                oAuthClient = new OAuthClient((HttpClient)ucc);
                resp = (OAuthResourceResponse)oAuthClient.resource(request, "GET", OAuthResourceResponse.class);
                Map profile = (Map)mapper.readValue(resp.getBody(), Map.class);
                return authResponse;
            }
        }
        catch (Exception ex) {
            throw new AuthenticationException(ex.getMessage());
        }
        return null;
    }
}

