/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary.summarizers;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.accumulo.core.client.summary.CountingSummarizer;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;

public class AuthorizationSummarizer
extends CountingSummarizer<ByteSequence> {
    @Override
    protected CountingSummarizer.Converter<ByteSequence> converter() {
        return new AuthsConverter();
    }

    private static class AuthsConverter
    implements CountingSummarizer.Converter<ByteSequence> {
        final int MAX_ENTRIES = 1000;
        private Map<ByteSequence, Set<ByteSequence>> cache = new LinkedHashMap<ByteSequence, Set<ByteSequence>>(1001, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<ByteSequence, Set<ByteSequence>> eldest) {
                return this.size() > 1000;
            }
        };

        private AuthsConverter() {
        }

        @Override
        public void convert(Key k, Value v, Consumer<ByteSequence> consumer) {
            ByteSequence vis = k.getColumnVisibilityData();
            if (vis.length() > 0) {
                Set<ByteSequence> auths = this.cache.get(vis);
                if (auths == null) {
                    auths = this.findAuths(vis);
                    this.cache.put(new ArrayByteSequence(vis), auths);
                }
                for (ByteSequence auth : auths) {
                    consumer.accept(auth);
                }
            }
        }

        private Set<ByteSequence> findAuths(ByteSequence vis) {
            HashSet<ByteSequence> auths = new HashSet<ByteSequence>();
            byte[] expression = vis.toArray();
            ColumnVisibility.Node root = new ColumnVisibility(expression).getParseTree();
            this.findAuths(root, expression, auths);
            return auths;
        }

        private void findAuths(ColumnVisibility.Node node, byte[] expression, HashSet<ByteSequence> auths) {
            switch (node.getType()) {
                case AND: 
                case OR: {
                    for (ColumnVisibility.Node child : node.getChildren()) {
                        this.findAuths(child, expression, auths);
                    }
                    break;
                }
                case TERM: {
                    auths.add(node.getTerm(expression));
                    break;
                }
                case EMPTY: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node type " + node.getType());
                }
            }
        }
    }
}

