/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.compactor;

import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.accumulo.compactor.CompactionJobHolder;
import org.apache.accumulo.compactor.ExtCEnv;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.CompactorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TNextCompactionJob;
import org.apache.accumulo.core.compaction.thrift.UnknownCompactionIdException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.InputFile;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionStats;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TIteratorSetting;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.CompactionWatcher;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.compaction.RetryableThriftCall;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compactor
extends AbstractServer
implements MetricsProducer,
CompactorService.Iface {
    private static final SecureRandom random = new SecureRandom();
    private static final Logger LOG = LoggerFactory.getLogger(Compactor.class);
    private static final long TIME_BETWEEN_GC_CHECKS = 5000L;
    private static final long TIME_BETWEEN_CANCEL_CHECKS = TimeUnit.MINUTES.toMillis(5L);
    private static final long TEN_MEGABYTES = 0xA00000L;
    protected static final CompactionJobHolder JOB_HOLDER = new CompactionJobHolder();
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    private final UUID compactorId = UUID.randomUUID();
    private final String queueName;
    protected final AtomicReference<ExternalCompactionId> currentCompactionId = new AtomicReference();
    private ServiceLock compactorLock;
    private ServerAddress compactorAddress = null;
    protected volatile boolean shutdown = false;
    private final AtomicBoolean compactionRunning = new AtomicBoolean(false);

    protected Compactor(CompactorServerOpts opts, String[] args) {
        super("compactor", (ServerOpts)opts, args);
        this.queueName = opts.getQueueName();
    }

    private long getTotalEntriesRead() {
        return FileCompactor.getTotalEntriesRead();
    }

    private long getTotalEntriesWritten() {
        return FileCompactor.getTotalEntriesWritten();
    }

    public void registerMetrics(MeterRegistry registry) {
        super.registerMetrics(registry);
        FunctionCounter.builder((String)"accumulo.compactor.entries.read", (Object)((Object)this), Compactor::getTotalEntriesRead).description("Number of entries read by all compactions that have run on this compactor").register(registry);
        FunctionCounter.builder((String)"accumulo.compactor.entries.written", (Object)((Object)this), Compactor::getTotalEntriesWritten).description("Number of entries written by all compactions that have run on this compactor").register(registry);
        LongTaskTimer timer = LongTaskTimer.builder((String)"accumulo.compactor.majc.stuck").description("Number and duration of stuck major compactions").register(registry);
        CompactionWatcher.setTimer((LongTaskTimer)timer);
    }

    protected void startGCLogger(ScheduledThreadPoolExecutor schedExecutor) {
        ScheduledFuture<?> future = schedExecutor.scheduleWithFixedDelay(() -> this.gcLogger.logGCInfo(this.getConfiguration()), 0L, 5000L, TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void startCancelChecker(ScheduledThreadPoolExecutor schedExecutor, long timeBetweenChecks) {
        ThreadPools.watchCriticalScheduledTask(schedExecutor.scheduleWithFixedDelay(this::checkIfCanceled, 0L, timeBetweenChecks, TimeUnit.MILLISECONDS));
    }

    protected void checkIfCanceled() {
        TExternalCompactionJob job = JOB_HOLDER.getJob();
        if (job != null) {
            try {
                KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                ExternalCompactionId ecid = ExternalCompactionId.of((String)job.getExternalCompactionId());
                TabletMetadata tabletMeta = this.getContext().getAmple().readTablet(extent, new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP, TabletMetadata.ColumnType.PREV_ROW});
                if (tabletMeta == null || !tabletMeta.getExternalCompactions().containsKey(ecid)) {
                    LOG.info("Cancelling compaction {} that no longer has a metadata entry at {}", (Object)ecid, (Object)extent);
                    JOB_HOLDER.cancel(job.getExternalCompactionId());
                    return;
                }
                if (job.getKind() == TCompactionKind.USER) {
                    String zTablePath = "/accumulo/" + this.getContext().getInstanceID() + "/tables/" + extent.tableId() + "/compact-cancel-id";
                    byte[] id = this.getContext().getZooCache().get(zTablePath);
                    if (id == null) {
                        LOG.info("Cancelling compaction {} for table that no longer exists {}", (Object)ecid, (Object)extent);
                        JOB_HOLDER.cancel(job.getExternalCompactionId());
                    } else {
                        long cancelId = Long.parseLong(new String(id, StandardCharsets.UTF_8));
                        if (cancelId >= job.getUserCompactionId()) {
                            LOG.info("Cancelling compaction {} because user compaction was canceled", (Object)ecid);
                            JOB_HOLDER.cancel(job.getExternalCompactionId());
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to check if compaction {} for {} was canceled.", new Object[]{job.getExternalCompactionId(), KeyExtent.fromThrift((TKeyExtent)job.getExtent()), e});
            }
        }
    }

    protected void announceExistence(HostAndPort clientAddress) throws KeeperException, InterruptedException {
        String hostPort = ExternalCompactionUtil.getHostPortString((HostAndPort)clientAddress);
        ZooReaderWriter zoo = this.getContext().getZooReaderWriter();
        String compactorQueuePath = this.getContext().getZooKeeperRoot() + "/compactors/" + this.queueName;
        String zPath = compactorQueuePath + "/" + hostPort;
        try {
            zoo.mkdirs(compactorQueuePath);
            zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NOAUTH) {
                LOG.error("Failed to write to ZooKeeper. Ensure that accumulo.properties, specifically instance.secret, is consistent.");
            }
            throw e;
        }
        this.compactorLock = new ServiceLock(this.getContext().getZooReaderWriter().getZooKeeper(), ServiceLock.path((String)zPath), this.compactorId);
        ServiceLock.LockWatcher lw = new ServiceLock.LockWatcher(){

            public void lostLock(ServiceLock.LockLossReason reason) {
                Halt.halt((int)1, () -> {
                    LOG.error("Compactor lost lock (reason = {}), exiting.", (Object)reason);
                    Compactor.this.gcLogger.logGCInfo(Compactor.this.getConfiguration());
                });
            }

            public void unableToMonitorLockNode(Exception e) {
                Halt.halt((int)1, () -> LOG.error("Lost ability to monitor Compactor lock, exiting.", (Throwable)e));
            }
        };
        try {
            byte[] lockContent = new ServerServices(hostPort, ServerServices.Service.COMPACTOR_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < 25; ++i) {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.compactorLock.tryLock(lw, lockContent)) {
                    LOG.debug("Obtained Compactor lock {}", (Object)this.compactorLock.getLockPath());
                    return;
                }
                LOG.info("Waiting for Compactor lock");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            LOG.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            LOG.info("Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected ServerAddress startCompactorClientService() throws UnknownHostException {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getCompactorTProcessor((CompactorService.Iface)this, (ServerContext)this.getContext());
        Property maxMessageSizeProperty = this.getConfiguration().resolve(Property.RPC_MAX_MESSAGE_SIZE, new Property[]{Property.GENERAL_MAX_MESSAGE_SIZE});
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)this.getHostname(), (Property)Property.COMPACTOR_CLIENTPORT, (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.COMPACTOR_PORTSEARCH, (Property)Property.COMPACTOR_MINTHREADS, (Property)Property.COMPACTOR_MINTHREADS_TIMEOUT, (Property)Property.COMPACTOR_THREADCHECK, (Property)maxMessageSizeProperty);
        LOG.info("address = {}", (Object)sp.address);
        return sp;
    }

    private void cancel(String externalCompactionId) throws TException {
        if (!JOB_HOLDER.cancel(externalCompactionId)) {
            throw new UnknownCompactionIdException();
        }
        LOG.info("Cancel requested for compaction job {}", (Object)externalCompactionId);
    }

    public void cancel(TInfo tinfo, TCredentials credentials, String externalCompactionId) throws TException {
        TableId tableId = JOB_HOLDER.getTableId();
        try {
            NamespaceId nsId = this.getContext().getNamespaceId(tableId);
            if (!this.getContext().getSecurityOperation().canCompact(credentials, tableId, nsId)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.COMPACT_CANCEL, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        this.cancel(externalCompactionId);
    }

    protected void updateCompactionState(TExternalCompactionJob job, TCompactionStatusUpdate update) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                coordinatorClient.updateCompactionStatus(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), update, System.currentTimeMillis());
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected void updateCompactionFailed(TExternalCompactionJob job) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                coordinatorClient.compactionFailed(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), job.extent);
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected void updateCompactionCompleted(TExternalCompactionJob job, TCompactionStats stats) throws RetryableThriftCall.RetriesExceededException {
        RetryableThriftCall thriftCall = new RetryableThriftCall(1000L, 60000L, 25, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                coordinatorClient.compactionCompleted(TraceUtil.traceInfo(), this.getContext().rpcCreds(), job.getExternalCompactionId(), job.extent, stats);
                String string = "";
                return string;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        thriftCall.run();
    }

    protected TNextCompactionJob getNextJob(Supplier<UUID> uuid) throws RetryableThriftCall.RetriesExceededException {
        long startingWaitTime = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MIN_JOB_WAIT_TIME);
        long maxWaitTime = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MAX_JOB_WAIT_TIME);
        RetryableThriftCall nextJobThriftCall = new RetryableThriftCall(startingWaitTime, maxWaitTime, 0, () -> {
            CompactionCoordinatorService.Client coordinatorClient = this.getCoordinatorClient();
            try {
                ExternalCompactionId eci = ExternalCompactionId.generate((UUID)((UUID)uuid.get()));
                LOG.trace("Attempting to get next job, eci = {}", (Object)eci);
                this.currentCompactionId.set(eci);
                TNextCompactionJob tNextCompactionJob = coordinatorClient.getCompactionJob(TraceUtil.traceInfo(), this.getContext().rpcCreds(), this.queueName, ExternalCompactionUtil.getHostPortString((HostAndPort)this.compactorAddress.getAddress()), eci.toString());
                return tNextCompactionJob;
            }
            catch (Exception e) {
                this.currentCompactionId.set(null);
                throw e;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)coordinatorClient, (ClientContext)this.getContext());
            }
        });
        return (TNextCompactionJob)nextJobThriftCall.run();
    }

    protected CompactionCoordinatorService.Client getCoordinatorClient() throws TTransportException {
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)this.getContext());
        if (coordinatorHost.isEmpty()) {
            throw new TTransportException("Unable to get CompactionCoordinator address from ZooKeeper");
        }
        LOG.trace("CompactionCoordinator address is: {}", coordinatorHost.orElseThrow());
        return (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)((HostAndPort)coordinatorHost.orElseThrow()), (ClientContext)this.getContext());
    }

    protected FileCompactorRunnable createCompactionJob(final TExternalCompactionJob job, final LongAdder totalInputEntries, final LongAdder totalInputBytes, final CountDownLatch started, final CountDownLatch stopped, final AtomicReference<Throwable> err) {
        return new FileCompactorRunnable(){
            private final AtomicReference<FileCompactor> compactor = new AtomicReference();
            private volatile long startTimeNanos = -1L;

            @Override
            public void initialize() throws RetryableThriftCall.RetriesExceededException {
                TableConfiguration aConfig;
                LOG.info("Starting up compaction runnable for job: {}", (Object)job);
                this.startTimeNanos = System.nanoTime();
                TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.STARTED, "Compaction started", -1L, -1L, -1L, this.getCompactionAge().toNanos());
                Compactor.this.updateCompactionState(job, update);
                KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                TableConfiguration tConfig = Compactor.this.getContext().getTableConfiguration(extent.tableId());
                if (!job.getOverrides().isEmpty()) {
                    aConfig = new ConfigurationCopy((Iterable)tConfig);
                    job.getOverrides().forEach((arg_0, arg_1) -> ((ConfigurationCopy)((ConfigurationCopy)aConfig)).set(arg_0, arg_1));
                    LOG.debug("Overriding table properties with {}", (Object)job.getOverrides());
                } else {
                    aConfig = tConfig;
                }
                TabletFile outputFile = new TabletFile(new Path(job.getOutputFile()));
                TreeMap files = new TreeMap();
                job.getFiles().forEach(arg_0 -> this.lambda$initialize$0(extent, (AccumuloConfiguration)aConfig, tConfig, files, totalInputEntries, totalInputBytes, arg_0));
                ArrayList iters = new ArrayList();
                job.getIteratorSettings().getIterators().forEach(tis -> iters.add(SystemIteratorUtil.toIteratorSetting((TIteratorSetting)tis)));
                ExtCEnv cenv = new ExtCEnv(JOB_HOLDER, Compactor.this.queueName);
                this.compactor.set(new FileCompactor(Compactor.this.getContext(), extent, files, outputFile, job.isPropagateDeletes(), (FileCompactor.CompactionEnv)cenv, iters, (AccumuloConfiguration)aConfig, tConfig.getCryptoService()));
            }

            @Override
            public AtomicReference<FileCompactor> getFileCompactor() {
                return this.compactor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Preconditions.checkState((this.compactor.get() != null ? 1 : 0) != 0, (Object)"initialize not called");
                Preconditions.checkState((boolean)Compactor.this.compactionRunning.compareAndSet(false, true));
                try {
                    LOG.trace("Starting compactor");
                    started.countDown();
                    CompactionStats stat = this.compactor.get().call();
                    TCompactionStats cs = new TCompactionStats();
                    cs.setEntriesRead(stat.getEntriesRead());
                    cs.setEntriesWritten(stat.getEntriesWritten());
                    cs.setFileSize(stat.getFileSize());
                    JOB_HOLDER.setStats(cs);
                    LOG.info("Compaction completed successfully {} ", (Object)job.getExternalCompactionId());
                    TCompactionStatusUpdate update2 = new TCompactionStatusUpdate(TCompactionState.SUCCEEDED, "Compaction completed successfully", -1L, -1L, -1L, this.getCompactionAge().toNanos());
                    Compactor.this.updateCompactionState(job, update2);
                }
                catch (FileCompactor.CompactionCanceledException cce) {
                    LOG.debug("Compaction canceled {}", (Object)job.getExternalCompactionId());
                    err.set(cce);
                }
                catch (Exception e) {
                    KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                    LOG.error("Compaction failed: id: {}, extent: {}", new Object[]{job.getExternalCompactionId(), fromThriftExtent, e});
                    err.set(e);
                }
                finally {
                    stopped.countDown();
                    Preconditions.checkState((boolean)Compactor.this.compactionRunning.compareAndSet(true, false));
                }
            }

            @Override
            public Duration getCompactionAge() {
                if (this.startTimeNanos == -1L) {
                    return Duration.ZERO;
                }
                return Duration.ofNanos(System.nanoTime() - this.startTimeNanos);
            }

            private /* synthetic */ void lambda$initialize$0(KeyExtent extent, AccumuloConfiguration aConfig, TableConfiguration tConfig, Map files, LongAdder totalInputEntries2, LongAdder totalInputBytes2, InputFile f) {
                long estEntries = f.getEntries();
                StoredTabletFile stf = new StoredTabletFile(f.getMetadataFileEntry());
                if (estEntries == 0L) {
                    estEntries = Compactor.this.estimateOverlappingEntries(extent, stf, aConfig, tConfig.getCryptoService());
                }
                files.put(stf, new DataFileValue(f.getSize(), estEntries, f.getTimestamp()));
                totalInputEntries2.add(estEntries);
                totalInputBytes2.add(f.getSize());
            }
        };
    }

    private long estimateOverlappingEntries(KeyExtent extent, StoredTabletFile file, AccumuloConfiguration tableConf, CryptoService cryptoService) {
        long l;
        block8: {
            FileOperations fileFactory = FileOperations.getInstance();
            FileSystem fs = this.getContext().getVolumeManager().getFileSystemByPath(file.getPath());
            FileSKVIterator reader = fileFactory.newReaderBuilder().forFile(file.getPathStr(), fs, fs.getConf(), cryptoService).withTableConfiguration(tableConf).dropCachesBehind().build();
            try {
                l = reader.estimateOverlappingEntries(extent);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            reader.close();
        }
        return l;
    }

    static long calculateProgressCheckTime(long numBytes) {
        return Math.max(1L, numBytes / 0xA00000L);
    }

    protected Supplier<UUID> getNextId() {
        return UUID::randomUUID;
    }

    protected long getWaitTimeBetweenCompactionChecks(int numCompactors) {
        long minWait = this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MIN_JOB_WAIT_TIME);
        long sleepTime = (long)numCompactors * minWait / 3L;
        sleepTime = Math.max(minWait, sleepTime);
        sleepTime = Math.min(this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MAX_JOB_WAIT_TIME), sleepTime);
        sleepTime = (long)(0.9 * (double)sleepTime + (double)sleepTime * 0.2 * random.nextDouble());
        LOG.trace("Sleeping {}ms based on {} compactors", (Object)sleepTime, (Object)numCompactors);
        return sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.compactorAddress = this.startCompactorClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the compactor client service", e1);
        }
        HostAndPort clientAddress = this.compactorAddress.getAddress();
        try {
            this.announceExistence(clientAddress);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Error registering compactor in ZooKeeper", e);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.addServiceTags(this.getApplicationName(), clientAddress);
        metricsInfo.addMetricsProducers(new MetricsProducer[]{this});
        metricsInfo.init();
        CompactionWatcher watcher = new CompactionWatcher(this.getConfiguration());
        ScheduledThreadPoolExecutor schedExecutor = ThreadPools.getServerThreadPools().createGeneralScheduledExecutorService(this.getConfiguration());
        this.startGCLogger(schedExecutor);
        this.startCancelChecker(schedExecutor, TIME_BETWEEN_CANCEL_CHECKS);
        LOG.info("Compactor started, waiting for work");
        try {
            AtomicReference<Throwable> err = new AtomicReference<Throwable>();
            while (!this.shutdown) {
                TExternalCompactionJob job;
                this.updateIdleStatus(true);
                this.currentCompactionId.set(null);
                err.set(null);
                JOB_HOLDER.reset();
                try {
                    TNextCompactionJob next = this.getNextJob(this.getNextId());
                    job = next.getJob();
                    if (!job.isSetExternalCompactionId()) {
                        LOG.trace("No external compactions in queue {}", (Object)this.queueName);
                        UtilWaitThread.sleep((long)this.getWaitTimeBetweenCompactionChecks(next.getCompactorCount()));
                        continue;
                    }
                    if (!job.getExternalCompactionId().equals(this.currentCompactionId.get().toString())) {
                        throw new IllegalStateException("Returned eci " + job.getExternalCompactionId() + " does not match supplied eci " + this.currentCompactionId.get());
                    }
                }
                catch (RetryableThriftCall.RetriesExceededException e2) {
                    LOG.warn("Retries exceeded getting next job. Retrying...");
                    continue;
                }
                LOG.debug("Received next compaction job: {}", (Object)job);
                LongAdder totalInputEntries = new LongAdder();
                LongAdder totalInputBytes = new LongAdder();
                CountDownLatch started = new CountDownLatch(1);
                CountDownLatch stopped = new CountDownLatch(1);
                FileCompactorRunnable fcr = this.createCompactionJob(job, totalInputEntries, totalInputBytes, started, stopped, err);
                Thread compactionThread = Threads.createThread((String)("Compaction job for tablet " + job.getExtent().toString()), (Runnable)fcr);
                JOB_HOLDER.set(job, compactionThread, fcr.getFileCompactor());
                try {
                    this.updateIdleStatus(false);
                    fcr.initialize();
                    compactionThread.start();
                    started.await();
                    long inputEntries = totalInputEntries.sum();
                    long waitTime = Compactor.calculateProgressCheckTime(totalInputBytes.sum());
                    LOG.debug("Progress checks will occur every {} seconds", (Object)waitTime);
                    String percentComplete = "unknown";
                    while (!stopped.await(waitTime, TimeUnit.SECONDS)) {
                        List running = FileCompactor.getRunningCompactions();
                        if (!running.isEmpty()) {
                            CompactionInfo info = (CompactionInfo)running.get(0);
                            if (info == null) continue;
                            long entriesRead = info.getEntriesRead();
                            long entriesWritten = info.getEntriesWritten();
                            if (inputEntries > 0L) {
                                percentComplete = Float.toString((float)entriesRead / (float)inputEntries * 100.0f);
                            }
                            String message = String.format("Compaction in progress, read %d of %d input entries ( %s %s ), written %d entries", entriesRead, inputEntries, percentComplete, "%", entriesWritten);
                            watcher.run();
                            try {
                                LOG.debug("Updating coordinator with compaction progress: {}.", (Object)message);
                                TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.IN_PROGRESS, message, inputEntries, entriesRead, entriesWritten, fcr.getCompactionAge().toNanos());
                                this.updateCompactionState(job, update);
                            }
                            catch (RetryableThriftCall.RetriesExceededException e) {
                                LOG.warn("Error updating coordinator with compaction progress, error: {}", (Object)e.getMessage());
                            }
                            continue;
                        }
                        LOG.debug("Waiting on compaction thread to finish, but no RUNNING compaction");
                    }
                    compactionThread.join();
                    LOG.trace("Compaction thread finished.");
                    watcher.run();
                    if (err.get() != null) {
                        this.checkIfCanceled();
                    }
                    if (compactionThread.isInterrupted() || JOB_HOLDER.isCancelled() || err.get() != null && err.get().getClass().equals(InterruptedException.class)) {
                        LOG.warn("Compaction thread was interrupted, sending CANCELLED state");
                        try {
                            TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.CANCELLED, "Compaction cancelled", -1L, -1L, -1L, fcr.getCompactionAge().toNanos());
                            this.updateCompactionState(job, update);
                            this.updateCompactionFailed(job);
                            continue;
                        }
                        catch (RetryableThriftCall.RetriesExceededException e) {
                            LOG.error("Error updating coordinator with compaction cancellation.", (Throwable)e);
                            continue;
                        }
                        finally {
                            this.currentCompactionId.set(null);
                            continue;
                        }
                    }
                    if (err.get() != null) {
                        KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                        try {
                            LOG.info("Updating coordinator with compaction failure: id: {}, extent: {}", (Object)job.getExternalCompactionId(), (Object)fromThriftExtent);
                            TCompactionStatusUpdate update = new TCompactionStatusUpdate(TCompactionState.FAILED, "Compaction failed due to: " + err.get().getMessage(), -1L, -1L, -1L, fcr.getCompactionAge().toNanos());
                            this.updateCompactionState(job, update);
                            this.updateCompactionFailed(job);
                            continue;
                        }
                        catch (RetryableThriftCall.RetriesExceededException e) {
                            LOG.error("Error updating coordinator with compaction failure: id: {}, extent: {}", new Object[]{job.getExternalCompactionId(), fromThriftExtent, e});
                            continue;
                        }
                        finally {
                            this.currentCompactionId.set(null);
                            continue;
                        }
                    }
                    try {
                        LOG.trace("Updating coordinator with compaction completion.");
                        this.updateCompactionCompleted(job, JOB_HOLDER.getStats());
                    }
                    catch (RetryableThriftCall.RetriesExceededException e) {
                        LOG.error("Error updating coordinator with compaction completion, cancelling compaction.", (Throwable)e);
                        try {
                            this.cancel(job.getExternalCompactionId());
                        }
                        catch (TException e1) {
                            LOG.error("Error cancelling compaction.", (Throwable)e1);
                        }
                    }
                    finally {
                        this.currentCompactionId.set(null);
                    }
                }
                catch (RuntimeException e1) {
                    LOG.error("Compactor thread was interrupted waiting for compaction to start, cancelling job", (Throwable)e1);
                    try {
                        this.cancel(job.getExternalCompactionId());
                    }
                    catch (TException e2) {
                        LOG.error("Error cancelling compaction.", (Throwable)e2);
                    }
                }
                finally {
                    this.currentCompactionId.set(null);
                    this.updateIdleStatus(true);
                    while (compactionThread.isAlive()) {
                        compactionThread.interrupt();
                        compactionThread.join(1000L);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred in Compactor", (Throwable)e);
        }
        finally {
            LOG.info("Stopping Thrift Servers");
            if (this.compactorAddress.server != null) {
                this.compactorAddress.server.stop();
            }
            try {
                LOG.debug("Closing filesystems");
                VolumeManager mgr = this.getContext().getVolumeManager();
                if (null != mgr) {
                    mgr.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close filesystem : {}", (Object)e.getMessage(), (Object)e);
            }
            this.gcLogger.logGCInfo(this.getConfiguration());
            LOG.info("stop requested. exiting ... ");
            try {
                if (null != this.compactorLock) {
                    this.compactorLock.unlock();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to release compactor lock", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try (Compactor compactor = new Compactor(new CompactorServerOpts(), args);){
            compactor.runServer();
        }
    }

    public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        List compactions = FileCompactor.getRunningCompactions();
        ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
        for (CompactionInfo compactionInfo : compactions) {
            ret.add(compactionInfo.toThrift());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TExternalCompactionJob getRunningCompaction(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionJob job = null;
        CompactionJobHolder compactionJobHolder = JOB_HOLDER;
        synchronized (compactionJobHolder) {
            job = JOB_HOLDER.getJob();
        }
        if (null == job) {
            return new TExternalCompactionJob();
        }
        return job;
    }

    public String getRunningCompactionId(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.getContext().getSecurityOperation().canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExternalCompactionId eci = this.currentCompactionId.get();
        if (null == eci) {
            return "";
        }
        return eci.canonical();
    }

    public static class CompactorServerOpts
    extends ServerOpts {
        @Parameter(required=true, names={"-q", "--queue"}, description="compaction queue name")
        private String queueName = null;

        public String getQueueName() {
            return this.queueName;
        }
    }

    public static interface FileCompactorRunnable
    extends Runnable {
        public void initialize() throws RetryableThriftCall.RetriesExceededException;

        public AtomicReference<FileCompactor> getFileCompactor();

        public Duration getCompactionAge();
    }
}

