/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.metadata.schema.SortSkew;
import org.apache.accumulo.core.schema.Section;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;

public class MetadataSchema {
    public static final String RESERVED_PREFIX = "~";

    @Deprecated(since="2.1")
    public static class OldScanServerFileReferenceSection {
        private static final Section section = new Section("~sserv", true, "~sserx", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class ScanServerFileReferenceSection {
        private static final Section section = new Section("~scanfileref", true, "~scanfilereg", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class ExternalCompactionSection {
        private static final Section section = new Section("~ecomp", true, "~ecomq", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class ReplicationSection {
        public static final Text COLF = new Text("stat");
        private static final ArrayByteSequence COLF_BYTE_SEQ = new ArrayByteSequence(COLF.toString());
        private static final Section section = new Section("~repl", true, "~repm", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }

        public static TableId getTableId(Key k) {
            Objects.requireNonNull(k);
            return TableId.of(k.getColumnQualifier().toString());
        }

        public static void getFile(Key k, Text buff) {
            Objects.requireNonNull(k);
            Objects.requireNonNull(buff);
            Preconditions.checkArgument((boolean)COLF_BYTE_SEQ.equals(k.getColumnFamilyData()), (Object)"Given metadata replication status key with incorrect colfam");
            k.getRow(buff);
            buff.set(buff.getBytes(), section.getRowPrefix().length(), buff.getLength() - section.getRowPrefix().length());
        }
    }

    public static class ProblemSection {
        private static final Section section = new Section("~err_", true, "~err`", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class BlipSection {
        private static final Section section = new Section("~blip", true, "~bliq", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class DeletesSection {
        private static final Section section = new Section("~del", true, "~dem", false);
        private static final int encoded_prefix_length = section.getRowPrefix().length() + 8;

        public static Range getRange() {
            return section.getRange();
        }

        public static String encodeRow(String value) {
            return section.getRowPrefix() + SortSkew.getCode(value) + value;
        }

        public static String decodeRow(String row) {
            return row.substring(encoded_prefix_length);
        }

        public static class SkewedKeyValue {
            public static final String STR_NAME = "skewed";
            public static final Value NAME = new Value("skewed");
        }
    }

    public static class ReservedSection {
        private static final Section section = new Section("~", true, null, false);

        public static Range getRange() {
            return section.getRange();
        }

        public static String getRowPrefix() {
            return section.getRowPrefix();
        }
    }

    public static class TabletsSection {
        private static final Section section = new Section(null, false, "~", false);

        public static Range getRange() {
            return section.getRange();
        }

        public static Range getRange(TableId tableId) {
            return new Range(new Key(tableId.canonical() + ";"), true, new Key(tableId.canonical() + "<").followingKey(PartialKey.ROW), false);
        }

        public static Text encodeRow(TableId tableId, Text endRow) {
            Text entry = new Text(tableId.canonical());
            if (endRow == null) {
                entry.append(new byte[]{60}, 0, 1);
            } else {
                entry.append(new byte[]{59}, 0, 1);
                entry.append(endRow.getBytes(), 0, endRow.getLength());
            }
            return entry;
        }

        public static Pair<TableId, Text> decodeRow(Text metadataRow) {
            int semiPos = -1;
            int ltPos = -1;
            for (int i = 0; i < metadataRow.getLength(); ++i) {
                if (metadataRow.getBytes()[i] == 59 && semiPos < 0) {
                    semiPos = i;
                }
                if (metadataRow.getBytes()[i] != 60) continue;
                ltPos = i;
            }
            if (semiPos < 0 && ltPos < 0) {
                throw new IllegalArgumentException("Metadata row does not contain ; or <  " + metadataRow);
            }
            if (semiPos < 0) {
                if (ltPos != metadataRow.getLength() - 1) {
                    throw new IllegalArgumentException("< must come at end of Metadata row  " + metadataRow);
                }
                TableId tableId = TableId.of(new String(metadataRow.getBytes(), 0, ltPos, StandardCharsets.UTF_8));
                return new Pair<TableId, Object>(tableId, null);
            }
            TableId tableId = TableId.of(new String(metadataRow.getBytes(), 0, semiPos, StandardCharsets.UTF_8));
            Text endRow = new Text();
            endRow.set(metadataRow.getBytes(), semiPos + 1, metadataRow.getLength() - (semiPos + 1));
            return new Pair<TableId, Text>(tableId, endRow);
        }

        public static class ExternalCompactionColumnFamily {
            public static final String STR_NAME = "ecomp";
            public static final Text NAME = new Text("ecomp");
        }

        public static class ChoppedColumnFamily {
            public static final String STR_NAME = "chopped";
            public static final Text NAME = new Text("chopped");
            public static final ColumnFQ CHOPPED_COLUMN = new ColumnFQ(NAME, new Text("chopped"));
        }

        public static class LogColumnFamily {
            public static final String STR_NAME = "log";
            public static final Text NAME = new Text("log");
        }

        public static class ScanFileColumnFamily {
            public static final String STR_NAME = "scan";
            public static final Text NAME = new Text("scan");
        }

        public static class DataFileColumnFamily {
            public static final String STR_NAME = "file";
            public static final Text NAME = new Text("file");
        }

        public static class ClonedColumnFamily {
            public static final String STR_NAME = "!cloned";
            public static final Text NAME = new Text("!cloned");
        }

        public static class BulkFileColumnFamily {
            public static final String STR_NAME = "loaded";
            public static final Text NAME = new Text("loaded");

            public static long getBulkLoadTid(Value v) {
                return BulkFileColumnFamily.getBulkLoadTid(v.toString());
            }

            public static long getBulkLoadTid(String vs) {
                if (FateTxId.isFormatedTid(vs)) {
                    return FateTxId.fromString(vs);
                }
                return Long.parseLong(vs);
            }
        }

        public static class SuspendLocationColumn {
            public static final String STR_NAME = "suspend";
            public static final ColumnFQ SUSPEND_COLUMN = new ColumnFQ(new Text("suspend"), new Text("loc"));
        }

        public static class LastLocationColumnFamily {
            public static final String STR_NAME = "last";
            public static final Text NAME = new Text("last");
        }

        public static class FutureLocationColumnFamily {
            public static final String STR_NAME = "future";
            public static final Text NAME = new Text("future");
        }

        public static class CurrentLocationColumnFamily {
            public static final String STR_NAME = "loc";
            public static final Text NAME = new Text("loc");
        }

        public static class ServerColumnFamily {
            public static final String STR_NAME = "srv";
            public static final Text NAME = new Text("srv");
            public static final String DIRECTORY_QUAL = "dir";
            public static final ColumnFQ DIRECTORY_COLUMN = new ColumnFQ(NAME, new Text("dir"));
            public static final String DEFAULT_TABLET_DIR_NAME = "default_tablet";
            private static final Pattern DIRCOL_MATCH_PATTERN = Pattern.compile("[\\dA-Za-z_-]+");
            public static final String TIME_QUAL = "time";
            public static final ColumnFQ TIME_COLUMN = new ColumnFQ(NAME, new Text("time"));
            public static final String FLUSH_QUAL = "flush";
            public static final ColumnFQ FLUSH_COLUMN = new ColumnFQ(NAME, new Text("flush"));
            public static final String COMPACT_QUAL = "compact";
            public static final ColumnFQ COMPACT_COLUMN = new ColumnFQ(NAME, new Text("compact"));
            public static final String LOCK_QUAL = "lock";
            public static final ColumnFQ LOCK_COLUMN = new ColumnFQ(NAME, new Text("lock"));

            public static boolean isValidDirCol(String dirName) {
                return DIRCOL_MATCH_PATTERN.matcher(dirName).matches();
            }

            public static void validateDirCol(String dirName) {
                Preconditions.checkArgument((boolean)ServerColumnFamily.isValidDirCol(dirName), (String)"Invalid dir name %s", (Object)dirName);
            }
        }

        public static class TabletColumnFamily {
            public static final String STR_NAME = "~tab";
            public static final Text NAME = new Text("~tab");
            public static final String PREV_ROW_QUAL = "~pr";
            public static final ColumnFQ PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("~pr"));
            public static final String OLD_PREV_ROW_QUAL = "oldprevrow";
            public static final ColumnFQ OLD_PREV_ROW_COLUMN = new ColumnFQ(NAME, new Text("oldprevrow"));
            public static final String SPLIT_RATIO_QUAL = "splitRatio";
            public static final ColumnFQ SPLIT_RATIO_COLUMN = new ColumnFQ(NAME, new Text("splitRatio"));

            public static Value encodePrevEndRow(Text per) {
                if (per == null) {
                    return new Value(new byte[]{0});
                }
                byte[] b = new byte[per.getLength() + 1];
                b[0] = 1;
                System.arraycopy(per.getBytes(), 0, b, 1, per.getLength());
                return new Value(b);
            }

            public static Text decodePrevEndRow(Value ibw) {
                Text per = null;
                if (ibw.get()[0] != 0) {
                    per = new Text();
                    per.set(ibw.get(), 1, ibw.get().length - 1);
                }
                return per;
            }

            public static Mutation createPrevRowMutation(KeyExtent ke) {
                Mutation m = new Mutation(ke.toMetaRow());
                PREV_ROW_COLUMN.put(m, TabletColumnFamily.encodePrevEndRow(ke.prevEndRow()));
                return m;
            }
        }
    }
}

