/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.Base64;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;

public class ExternalCompactionFinalState {
    private static final Gson GSON = new Gson();
    private final ExternalCompactionId ecid;
    private final KeyExtent extent;
    private final FinalState state;
    private final long fileSize;
    private final long fileEntries;

    public ExternalCompactionFinalState(ExternalCompactionId ecid, KeyExtent extent, FinalState state, long fileSize, long fileEntries) {
        this.ecid = ecid;
        this.extent = extent;
        this.state = state;
        this.fileSize = fileSize;
        this.fileEntries = fileEntries;
    }

    public ExternalCompactionId getExternalCompactionId() {
        return this.ecid;
    }

    public FinalState getFinalState() {
        return this.state;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public long getFileSize() {
        Preconditions.checkState((this.state == FinalState.FINISHED ? 1 : 0) != 0);
        return this.fileSize;
    }

    public long getEntries() {
        Preconditions.checkState((this.state == FinalState.FINISHED ? 1 : 0) != 0);
        return this.fileEntries;
    }

    public String toJson() {
        JsonData jd = new JsonData();
        jd.state = this.state.name();
        jd.fileSize = this.fileSize;
        jd.entries = this.fileEntries;
        jd.extent = new Extent(this.extent);
        return GSON.toJson((Object)jd);
    }

    public static ExternalCompactionFinalState fromJson(ExternalCompactionId ecid, String json) {
        JsonData jd = (JsonData)GSON.fromJson(json, JsonData.class);
        return new ExternalCompactionFinalState(ecid, jd.extent.toKeyExtent(), FinalState.valueOf(jd.state), jd.fileSize, jd.entries);
    }

    public String toString() {
        return this.toJson();
    }

    public static enum FinalState {
        FINISHED,
        FAILED;

    }

    private static class JsonData {
        Extent extent;
        String state;
        long fileSize;
        long entries;

        private JsonData() {
        }
    }

    private static class Extent {
        final String tableId;
        final String er;
        final String per;

        Extent(KeyExtent extent) {
            this.tableId = extent.tableId().canonical();
            this.er = extent.endRow() != null ? Base64.getEncoder().encodeToString(TextUtil.getBytes(extent.endRow())) : null;
            this.per = extent.prevEndRow() != null ? Base64.getEncoder().encodeToString(TextUtil.getBytes(extent.prevEndRow())) : null;
        }

        private Text decode(String s) {
            if (s == null) {
                return null;
            }
            return new Text(Base64.getDecoder().decode(s));
        }

        KeyExtent toKeyExtent() {
            return new KeyExtent(TableId.of(this.tableId), this.decode(this.er), this.decode(this.per));
        }
    }
}

