/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class GrepIterator
extends Filter {
    private static final String TERM_OPT = "term";
    private static final String MATCH_ROW_OPT = "matchRow";
    private static final String MATCH_COLFAM_OPT = "matchColumnFamily";
    private static final String MATCH_COLQUAL_OPT = "matchColumnQualifier";
    private static final String MATCH_COLVIS_OPT = "matchColumnVisibility";
    private static final String MATCH_VALUE_OPT = "matchValue";
    private byte[] term;
    private int[] right = new int[256];
    private boolean matchRow = true;
    private boolean matchColFam = true;
    private boolean matchColQual = true;
    private boolean matchColVis = false;
    private boolean matchValue = true;

    @Override
    public boolean accept(Key k, Value v) {
        return this.matchValue && this.match(v.get()) || this.matchRow && this.match(k.getRowData()) || this.matchColFam && this.match(k.getColumnFamilyData()) || this.matchColQual && this.match(k.getColumnQualifierData()) || this.matchColVis && this.match(k.getColumnVisibilityData());
    }

    protected boolean match(ByteSequence bs) {
        return this.indexOf(bs.getBackingArray(), bs.offset(), bs.length()) >= 0;
    }

    protected boolean match(byte[] ba) {
        return this.indexOf(ba, 0, ba.length) >= 0;
    }

    protected int indexOf(byte[] value, int offset, int length) {
        int skip;
        int M = this.term.length;
        int N = offset + length;
        for (int i = offset; i <= N - M; i += skip) {
            skip = 0;
            for (int j = M - 1; j >= 0; --j) {
                if (this.term[j] == value[i + j]) continue;
                skip = Math.max(1, j - this.right[value[i + j] & 0xFF]);
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        GrepIterator copy = (GrepIterator)super.deepCopy(env);
        copy.term = Arrays.copyOf(this.term, this.term.length);
        copy.matchRow = this.matchRow;
        copy.matchColFam = this.matchColFam;
        copy.matchColQual = this.matchColQual;
        copy.matchColVis = this.matchColVis;
        copy.matchValue = this.matchValue;
        return copy;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        int i;
        super.init(source, options, env);
        this.term = options.get(TERM_OPT).getBytes(StandardCharsets.UTF_8);
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = -1;
        }
        for (i = 0; i < this.term.length; ++i) {
            this.right[this.term[i] & 0xFF] = i;
        }
        String matchItem = null;
        matchItem = options.get(MATCH_ROW_OPT);
        if (matchItem != null) {
            this.matchRow = Boolean.parseBoolean(matchItem);
        }
        if ((matchItem = options.get(MATCH_COLFAM_OPT)) != null) {
            this.matchColFam = Boolean.parseBoolean(matchItem);
        }
        if ((matchItem = options.get(MATCH_COLQUAL_OPT)) != null) {
            this.matchColQual = Boolean.parseBoolean(matchItem);
        }
        if ((matchItem = options.get(MATCH_COLVIS_OPT)) != null) {
            this.matchColVis = Boolean.parseBoolean(matchItem);
        }
        if ((matchItem = options.get(MATCH_VALUE_OPT)) != null) {
            this.matchValue = Boolean.parseBoolean(matchItem);
        }
    }

    public static void setTerm(IteratorSetting cfg, String term) {
        cfg.addOption(TERM_OPT, term);
    }

    public static void matchRow(IteratorSetting cfg, boolean match) {
        cfg.addOption(MATCH_ROW_OPT, Boolean.toString(match));
    }

    public static void matchColumnFamily(IteratorSetting cfg, boolean match) {
        cfg.addOption(MATCH_COLFAM_OPT, Boolean.toString(match));
    }

    public static void matchColumnQualifier(IteratorSetting cfg, boolean match) {
        cfg.addOption(MATCH_COLQUAL_OPT, Boolean.toString(match));
    }

    public static void matchColumnVisibility(IteratorSetting cfg, boolean match) {
        cfg.addOption(MATCH_COLVIS_OPT, Boolean.toString(match));
    }

    public static void matchValue(IteratorSetting cfg, boolean match) {
        cfg.addOption(MATCH_VALUE_OPT, Boolean.toString(match));
    }
}

