/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.DispatchingFileFactory;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;

public abstract class FileOperations {
    private static final String HADOOP_JOBHISTORY_LOCATION = "_logs";
    private static final Set<String> validExtensions = Set.of("map", "rf");
    private static final Set<String> bulkWorkingFiles = Set.of("loadmap.json", "renames.json", "_SUCCESS", "_logs");

    public static Set<String> getValidExtensions() {
        return validExtensions;
    }

    public static Set<String> getBulkWorkingFiles() {
        return bulkWorkingFiles;
    }

    public static String getNewFileExtension(AccumuloConfiguration acuconf) {
        return acuconf.get(Property.TABLE_FILE_TYPE);
    }

    public static FileOperations getInstance() {
        return new DispatchingFileFactory();
    }

    protected abstract long getFileSize(FileOptions var1) throws IOException;

    protected abstract FileSKVWriter openWriter(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openIndex(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openScanReader(FileOptions var1) throws IOException;

    protected abstract FileSKVIterator openReader(FileOptions var1) throws IOException;

    public WriterBuilder newWriterBuilder() {
        return new WriterBuilder();
    }

    public IndexReaderBuilder newIndexReaderBuilder() {
        return new IndexReaderBuilder();
    }

    public ScanReaderBuilder newScanReaderBuilder() {
        return new ScanReaderBuilder();
    }

    public ReaderBuilder newReaderBuilder() {
        return new ReaderBuilder();
    }

    public class WriterBuilder
    extends FileHelper
    implements WriterTableConfiguration {
        private String compression;
        private FSDataOutputStream outputStream;
        private boolean enableAccumuloStart = true;

        public WriterTableConfiguration forOutputStream(String extension, FSDataOutputStream outputStream, Configuration fsConf, CryptoService cs) {
            this.outputStream = outputStream;
            this.filename("foo" + extension).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        public WriterTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public WriterBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public WriterBuilder withStartDisabled() {
            this.enableAccumuloStart = false;
            return this;
        }

        public WriterBuilder withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public WriterBuilder withRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter(rateLimiter);
            return this;
        }

        public WriterBuilder dropCachesBehind() {
            this.dropCacheBehind(true);
            return this;
        }

        public FileSKVWriter build() throws IOException {
            return FileOperations.this.openWriter(this.toWriterBuilderOptions(this.compression, this.outputStream, this.enableAccumuloStart));
        }
    }

    public class IndexReaderBuilder
    extends FileHelper
    implements IndexReaderTableConfiguration {
        private Cache<String, Long> fileLenCache = null;

        public IndexReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public IndexReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public IndexReaderBuilder withFileLenCache(Cache<String, Long> fileLenCache) {
            this.fileLenCache = fileLenCache;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            return FileOperations.this.openIndex(this.toIndexReaderBuilderOptions(this.fileLenCache));
        }
    }

    public class ScanReaderBuilder
    extends FileHelper
    implements ScanReaderTableConfiguration {
        private Range range;
        private Set<ByteSequence> columnFamilies;
        private boolean inclusive;

        public ScanReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public ScanReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public ScanReaderBuilder overRange(Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            Objects.requireNonNull(range);
            Objects.requireNonNull(columnFamilies);
            this.range = range;
            this.columnFamilies = columnFamilies;
            this.inclusive = inclusive;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            return FileOperations.this.openScanReader(this.toScanReaderBuilderOptions(this.range, this.columnFamilies, this.inclusive));
        }
    }

    public class ReaderBuilder
    extends FileHelper
    implements ReaderTableConfiguration {
        private CacheProvider cacheProvider;
        private Cache<String, Long> fileLenCache;
        private boolean seekToBeginning = false;

        public ReaderTableConfiguration forFile(String filename, FileSystem fs, Configuration fsConf, CryptoService cs) {
            this.filename(filename).fs(fs).fsConf(fsConf).cryptoService(cs);
            return this;
        }

        @Override
        public ReaderBuilder withTableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration(tableConfiguration);
            return this;
        }

        public ReaderBuilder withCacheProvider(CacheProvider cacheProvider) {
            this.cacheProvider = cacheProvider;
            return this;
        }

        public ReaderBuilder withFileLenCache(Cache<String, Long> fileLenCache) {
            this.fileLenCache = fileLenCache;
            return this;
        }

        public ReaderBuilder withRateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter(rateLimiter);
            return this;
        }

        public ReaderBuilder dropCachesBehind() {
            this.dropCacheBehind(true);
            return this;
        }

        public ReaderBuilder seekToBeginning() {
            this.seekToBeginning(true);
            return this;
        }

        public ReaderBuilder seekToBeginning(boolean seekToBeginning) {
            this.seekToBeginning = seekToBeginning;
            return this;
        }

        public FileSKVIterator build() throws IOException {
            return FileOperations.this.openReader(this.toReaderBuilderOptions(this.cacheProvider, this.fileLenCache, this.seekToBeginning));
        }
    }

    public static interface ScanReaderTableConfiguration {
        public ScanReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public static interface IndexReaderTableConfiguration {
        public IndexReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public static interface ReaderTableConfiguration {
        public ReaderBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public static interface WriterTableConfiguration {
        public WriterBuilder withTableConfiguration(AccumuloConfiguration var1);
    }

    public static class FileHelper {
        private AccumuloConfiguration tableConfiguration;
        private String filename;
        private FileSystem fs;
        private Configuration fsConf;
        private RateLimiter rateLimiter;
        private CryptoService cryptoService;
        private boolean dropCacheBehind = false;

        protected FileHelper fs(FileSystem fs) {
            this.fs = Objects.requireNonNull(fs);
            return this;
        }

        protected FileHelper fsConf(Configuration fsConf) {
            this.fsConf = Objects.requireNonNull(fsConf);
            return this;
        }

        protected FileHelper filename(String filename) {
            this.filename = Objects.requireNonNull(filename);
            return this;
        }

        protected FileHelper tableConfiguration(AccumuloConfiguration tableConfiguration) {
            this.tableConfiguration = Objects.requireNonNull(tableConfiguration);
            return this;
        }

        protected FileHelper rateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        protected FileHelper cryptoService(CryptoService cs) {
            this.cryptoService = Objects.requireNonNull(cs);
            return this;
        }

        protected FileHelper dropCacheBehind(boolean drop) {
            this.dropCacheBehind = drop;
            return this;
        }

        protected FileOptions toWriterBuilderOptions(String compression, FSDataOutputStream outputStream, boolean startEnabled) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, compression, outputStream, startEnabled, CacheProvider.NULL_PROVIDER, null, false, this.cryptoService, null, null, true, this.dropCacheBehind);
        }

        protected FileOptions toReaderBuilderOptions(CacheProvider cacheProvider, Cache<String, Long> fileLenCache, boolean seekToBeginning) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, cacheProvider == null ? CacheProvider.NULL_PROVIDER : cacheProvider, fileLenCache, seekToBeginning, this.cryptoService, null, null, true, this.dropCacheBehind);
        }

        protected FileOptions toIndexReaderBuilderOptions(Cache<String, Long> fileLenCache) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, CacheProvider.NULL_PROVIDER, fileLenCache, false, this.cryptoService, null, null, true, this.dropCacheBehind);
        }

        protected FileOptions toScanReaderBuilderOptions(Range range, Set<ByteSequence> columnFamilies, boolean inclusive) {
            return new FileOptions(this.tableConfiguration, this.filename, this.fs, this.fsConf, this.rateLimiter, null, null, false, CacheProvider.NULL_PROVIDER, null, false, this.cryptoService, range, columnFamilies, inclusive, this.dropCacheBehind);
        }

        protected AccumuloConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }
    }

    public static class FileOptions {
        public final AccumuloConfiguration tableConfiguration;
        public final String filename;
        public final FileSystem fs;
        public final Configuration fsConf;
        public final RateLimiter rateLimiter;
        public final String compression;
        public final FSDataOutputStream outputStream;
        public final boolean enableAccumuloStart;
        public final CacheProvider cacheProvider;
        public final Cache<String, Long> fileLenCache;
        public final boolean seekToBeginning;
        public final CryptoService cryptoService;
        public final Range range;
        public final Set<ByteSequence> columnFamilies;
        public final boolean inclusive;
        public final boolean dropCacheBehind;

        public FileOptions(AccumuloConfiguration tableConfiguration, String filename, FileSystem fs, Configuration fsConf, RateLimiter rateLimiter, String compression, FSDataOutputStream outputStream, boolean enableAccumuloStart, CacheProvider cacheProvider, Cache<String, Long> fileLenCache, boolean seekToBeginning, CryptoService cryptoService, Range range, Set<ByteSequence> columnFamilies, boolean inclusive, boolean dropCacheBehind) {
            this.tableConfiguration = tableConfiguration;
            this.filename = filename;
            this.fs = fs;
            this.fsConf = fsConf;
            this.rateLimiter = rateLimiter;
            this.compression = compression;
            this.outputStream = outputStream;
            this.enableAccumuloStart = enableAccumuloStart;
            this.cacheProvider = cacheProvider;
            this.fileLenCache = fileLenCache;
            this.seekToBeginning = seekToBeginning;
            this.cryptoService = Objects.requireNonNull(cryptoService);
            this.range = range;
            this.columnFamilies = columnFamilies;
            this.inclusive = inclusive;
            this.dropCacheBehind = dropCacheBehind;
        }

        public AccumuloConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }

        public String getFilename() {
            return this.filename;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        public Configuration getConfiguration() {
            return this.fsConf;
        }

        public RateLimiter getRateLimiter() {
            return this.rateLimiter;
        }

        public String getCompression() {
            return this.compression;
        }

        public FSDataOutputStream getOutputStream() {
            return this.outputStream;
        }

        public boolean isAccumuloStartEnabled() {
            return this.enableAccumuloStart;
        }

        public CacheProvider getCacheProvider() {
            return this.cacheProvider;
        }

        public Cache<String, Long> getFileLenCache() {
            return this.fileLenCache;
        }

        public boolean isSeekToBeginning() {
            return this.seekToBeginning;
        }

        public CryptoService getCryptoService() {
            return this.cryptoService;
        }

        public Range getRange() {
            return this.range;
        }

        public Set<ByteSequence> getColumnFamilies() {
            return this.columnFamilies;
        }

        public boolean isRangeInclusive() {
            return this.inclusive;
        }
    }
}

