/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.CompressedIterators;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.SyncingTabletLocator;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TCMResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMStatus;
import org.apache.accumulo.core.dataImpl.thrift.TCondition;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalSession;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalWriterImpl
implements ConditionalWriter {
    private static final Logger log = LoggerFactory.getLogger(ConditionalWriterImpl.class);
    private static final int MAX_SLEEP = 30000;
    private Authorizations auths;
    private VisibilityEvaluator ve;
    private Map<Text, Boolean> cache = Collections.synchronizedMap(new LRUMap(1000));
    private final ClientContext context;
    private TabletLocator locator;
    private final TableId tableId;
    private final String tableName;
    private long timeout;
    private final Durability durability;
    private final String classLoaderContext;
    private final ConditionalWriterConfig config;
    private Map<String, ServerQueue> serverQueues;
    private DelayQueue<QCMutation> failedMutations = new DelayQueue();
    private ScheduledThreadPoolExecutor threadPool;
    private final ScheduledFuture<?> failureTaskFuture;
    private HashMap<HostAndPort, SessionID> cachedSessionIDs = new HashMap();
    private static final Comparator<Long> TIMESTAMP_COMPARATOR = Comparator.nullsFirst(Comparator.reverseOrder());
    static final Comparator<Condition> CONDITION_COMPARATOR = Comparator.comparing(Condition::getFamily).thenComparing(Condition::getQualifier).thenComparing(Condition::getVisibility).thenComparing(Condition::getTimestamp, TIMESTAMP_COMPARATOR);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerQueue getServerQueue(String location) {
        ServerQueue serverQueue;
        Map<String, ServerQueue> map = this.serverQueues;
        synchronized (map) {
            serverQueue = this.serverQueues.get(location);
            if (serverQueue == null) {
                serverQueue = new ServerQueue();
                this.serverQueues.put(location, serverQueue);
            }
        }
        return serverQueue;
    }

    private void queueRetry(List<QCMutation> mutations, HostAndPort server) {
        if (this.timeout < Long.MAX_VALUE) {
            long time = System.currentTimeMillis();
            ArrayList<QCMutation> mutations2 = new ArrayList<QCMutation>(mutations.size());
            for (QCMutation qcm : mutations) {
                qcm.resetDelay();
                if (time + qcm.getDelay(TimeUnit.MILLISECONDS) > qcm.entryTime + this.timeout) {
                    TimedOutException toe = server != null ? new TimedOutException(Collections.singleton(server.toString())) : new TimedOutException("Conditional mutation timed out");
                    qcm.queueResult(new ConditionalWriter.Result(toe, (ConditionalMutation)qcm, server == null ? null : server.toString()));
                    continue;
                }
                mutations2.add(qcm);
            }
            if (!mutations2.isEmpty()) {
                this.failedMutations.addAll(mutations2);
            }
        } else {
            mutations.forEach(QCMutation::resetDelay);
            this.failedMutations.addAll(mutations);
        }
    }

    private void queue(List<QCMutation> mutations) {
        ArrayList<QCMutation> failures = new ArrayList<QCMutation>();
        HashMap binnedMutations = new HashMap();
        try {
            this.locator.binMutations(this.context, mutations, binnedMutations, failures);
            if (failures.size() == mutations.size()) {
                this.context.requireNotDeleted(this.tableId);
                this.context.requireNotOffline(this.tableId, this.tableName);
            }
        }
        catch (Exception e) {
            mutations.forEach(qcm -> qcm.queueResult(new ConditionalWriter.Result(e, (ConditionalMutation)qcm, null)));
            failures.clear();
            binnedMutations.clear();
        }
        if (!failures.isEmpty()) {
            this.queueRetry(failures, null);
        }
        binnedMutations.forEach(this::queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(String location, TabletLocator.TabletServerMutations<QCMutation> mutations) {
        ServerQueue serverQueue;
        ServerQueue serverQueue2 = serverQueue = this.getServerQueue(location);
        synchronized (serverQueue2) {
            serverQueue.queue.add(mutations);
            if (!serverQueue.taskQueued) {
                this.threadPool.execute(new SendTask(location));
                serverQueue.taskQueued = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SendTask task) {
        ServerQueue serverQueue;
        ServerQueue serverQueue2 = serverQueue = this.getServerQueue(task.location);
        synchronized (serverQueue2) {
            if (serverQueue.queue.isEmpty()) {
                serverQueue.taskQueued = false;
            } else {
                this.threadPool.execute(task);
            }
        }
    }

    private TabletLocator.TabletServerMutations<QCMutation> dequeue(String location) {
        BlockingQueue<TabletLocator.TabletServerMutations<QCMutation>> queue = this.getServerQueue((String)location).queue;
        ArrayList mutations = new ArrayList();
        queue.drainTo(mutations);
        if (mutations.isEmpty()) {
            return null;
        }
        if (mutations.size() == 1) {
            return (TabletLocator.TabletServerMutations)mutations.get(0);
        }
        TabletLocator.TabletServerMutations tsm = (TabletLocator.TabletServerMutations)mutations.get(0);
        for (int i = 1; i < mutations.size(); ++i) {
            ((TabletLocator.TabletServerMutations)mutations.get(i)).getMutations().forEach((keyExtent, mutationList) -> tsm.getMutations().computeIfAbsent((KeyExtent)keyExtent, k -> new ArrayList()).addAll(mutationList));
        }
        return tsm;
    }

    ConditionalWriterImpl(ClientContext context, TableId tableId, String tableName, ConditionalWriterConfig config) {
        this.config = config;
        this.context = context;
        this.auths = config.getAuthorizations();
        this.ve = new VisibilityEvaluator(config.getAuthorizations());
        this.threadPool = context.threadPools().createScheduledExecutorService(config.getMaxWriteThreads(), ThreadPoolNames.CONDITIONAL_WRITER_POOL.poolName);
        this.locator = new SyncingTabletLocator(context, tableId);
        this.serverQueues = new HashMap<String, ServerQueue>();
        this.tableId = tableId;
        this.tableName = tableName;
        this.timeout = config.getTimeout(TimeUnit.MILLISECONDS);
        this.durability = config.getDurability();
        this.classLoaderContext = config.getClassLoaderContext();
        Runnable failureHandler = () -> {
            ArrayList<QCMutation> mutations = new ArrayList<QCMutation>();
            this.failedMutations.drainTo(mutations);
            if (!mutations.isEmpty()) {
                this.queue(mutations);
            }
        };
        this.failureTaskFuture = this.threadPool.scheduleAtFixedRate(failureHandler, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Iterator<ConditionalWriter.Result> write(Iterator<ConditionalMutation> mutations) {
        ThreadPools.ensureRunning(this.failureTaskFuture, "Background task that re-queues failed mutations has exited.");
        LinkedBlockingQueue<ConditionalWriter.Result> resultQueue = new LinkedBlockingQueue<ConditionalWriter.Result>();
        ArrayList<QCMutation> mutationList = new ArrayList<QCMutation>();
        int count = 0;
        long entryTime = System.currentTimeMillis();
        block0: while (mutations.hasNext()) {
            ConditionalMutation mut = mutations.next();
            ++count;
            if (mut.getConditions().isEmpty()) {
                throw new IllegalArgumentException("ConditionalMutation had no conditions " + new String(mut.getRow(), StandardCharsets.UTF_8));
            }
            for (Condition cond : mut.getConditions()) {
                if (this.isVisible(cond.getVisibility())) continue;
                resultQueue.add(new ConditionalWriter.Result(ConditionalWriter.Status.INVISIBLE_VISIBILITY, mut, null));
                continue block0;
            }
            mutationList.add(new QCMutation(mut, resultQueue, entryTime));
        }
        this.queue(mutationList);
        return new RQIterator(resultQueue, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionID reserveSessionID(HostAndPort location, TabletClientService.Iface client, TInfo tinfo) throws ThriftSecurityException, TException {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            SessionID sid = this.cachedSessionIDs.get(location);
            if (sid != null) {
                if (sid.reserved) {
                    throw new IllegalStateException();
                }
                if (sid.isActive()) {
                    sid.reserved = true;
                    return sid;
                }
                this.cachedSessionIDs.remove(location);
            }
        }
        TConditionalSession tcs = client.startConditionalUpdate(tinfo, this.context.rpcCreds(), ByteBufferUtil.toByteBuffers(this.auths.getAuthorizations()), this.tableId.canonical(), DurabilityImpl.toThrift(this.durability), this.classLoaderContext);
        HashMap<HostAndPort, SessionID> hashMap2 = this.cachedSessionIDs;
        synchronized (hashMap2) {
            SessionID sid = new SessionID();
            sid.reserved = true;
            sid.sessionID = tcs.sessionId;
            sid.lockId = tcs.tserverLock;
            sid.ttl = tcs.ttl;
            sid.location = location;
            if (this.cachedSessionIDs.put(location, sid) != null) {
                throw new IllegalStateException();
            }
            return sid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSessionID(HostAndPort location) {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            this.cachedSessionIDs.remove(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveSessionID(HostAndPort location) {
        HashMap<HostAndPort, SessionID> hashMap = this.cachedSessionIDs;
        synchronized (hashMap) {
            SessionID sid = this.cachedSessionIDs.get(location);
            if (sid != null) {
                if (!sid.reserved) {
                    throw new IllegalStateException();
                }
                sid.reserved = false;
                sid.lastAccessTime = System.currentTimeMillis();
            }
        }
    }

    List<SessionID> getActiveSessions() {
        ArrayList<SessionID> activeSessions = new ArrayList<SessionID>();
        for (SessionID sid : this.cachedSessionIDs.values()) {
            if (!sid.isActive()) continue;
            activeSessions.add(sid);
        }
        return activeSessions;
    }

    private TabletClientService.Iface getClient(HostAndPort location) throws TTransportException {
        TabletClientService.Iface client = this.timeout < this.context.getClientTimeoutInMillis() ? (TabletClientService.Iface)ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, location, this.context, this.timeout) : (TabletClientService.Iface)ThriftUtil.getClient(ThriftClientTypes.TABLET_SERVER, location, this.context);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToServer(HostAndPort location, TabletLocator.TabletServerMutations<QCMutation> mutations) {
        TabletClientService.Iface client = null;
        TInfo tinfo = TraceUtil.traceInfo();
        HashMap<Long, CMK> cmidToCm = new HashMap<Long, CMK>();
        MutableLong cmid = new MutableLong(0L);
        SessionID sessionId = null;
        try {
            HashMap<TKeyExtent, List<TConditionalMutation>> tmutations = new HashMap<TKeyExtent, List<TConditionalMutation>>();
            CompressedIterators compressedIters = new CompressedIterators();
            this.convertMutations(mutations, cmidToCm, cmid, tmutations, compressedIters);
            client = this.getClient(location);
            List<TCMResult> tresults = null;
            while (tresults == null) {
                try {
                    sessionId = this.reserveSessionID(location, client, tinfo);
                    tresults = client.conditionalUpdate(tinfo, sessionId.sessionID, tmutations, compressedIters.getSymbolTable());
                }
                catch (NoSuchScanIDException nssie) {
                    sessionId = null;
                    this.invalidateSessionID(location);
                }
            }
            HashSet<KeyExtent> extentsToInvalidate = new HashSet<KeyExtent>();
            ArrayList<QCMutation> ignored = new ArrayList<QCMutation>();
            for (TCMResult tcmResult : tresults) {
                if (tcmResult.status == TCMStatus.IGNORED) {
                    CMK cmk = (CMK)cmidToCm.get(tcmResult.cmid);
                    ignored.add(cmk.cm);
                    extentsToInvalidate.add(cmk.ke);
                    continue;
                }
                QCMutation qcm = ((CMK)cmidToCm.get((Object)Long.valueOf((long)tcmResult.cmid))).cm;
                qcm.queueResult(new ConditionalWriter.Result(this.fromThrift(tcmResult.status), (ConditionalMutation)qcm, location.toString()));
            }
            for (KeyExtent ke : extentsToInvalidate) {
                this.locator.invalidateCache(ke);
            }
            this.queueRetry(ignored, location);
        }
        catch (ThriftSecurityException tse) {
            AccumuloSecurityException ase = new AccumuloSecurityException(this.context.getCredentials().getPrincipal(), tse.getCode(), this.context.getPrintableTableInfoFromId(this.tableId), (Throwable)((Object)tse));
            this.queueException(location, cmidToCm, ase);
        }
        catch (TApplicationException tae) {
            this.queueException(location, cmidToCm, new AccumuloServerException(location.toString(), tae));
        }
        catch (TException e) {
            this.locator.invalidateCache(this.context, location.toString());
            this.invalidateSession(location, cmidToCm, sessionId);
        }
        catch (Exception e) {
            this.queueException(location, cmidToCm, e);
        }
        finally {
            if (sessionId != null) {
                this.unreserveSessionID(location);
            }
            ThriftUtil.returnClient((TServiceClient)client, this.context);
        }
    }

    private void queueRetry(Map<Long, CMK> cmidToCm, HostAndPort location) {
        ArrayList<QCMutation> ignored = new ArrayList<QCMutation>();
        for (CMK cmk : cmidToCm.values()) {
            ignored.add(cmk.cm);
        }
        this.queueRetry(ignored, location);
    }

    private void queueException(HostAndPort location, Map<Long, CMK> cmidToCm, Exception e) {
        for (CMK cmk : cmidToCm.values()) {
            cmk.cm.queueResult(new ConditionalWriter.Result(e, (ConditionalMutation)cmk.cm, location.toString()));
        }
    }

    private void invalidateSession(HostAndPort location, Map<Long, CMK> cmidToCm, SessionID sessionId) {
        if (sessionId == null) {
            this.queueRetry(cmidToCm, location);
        } else {
            try {
                this.invalidateSession(sessionId, location);
                for (CMK cmk : cmidToCm.values()) {
                    cmk.cm.queueResult(new ConditionalWriter.Result(ConditionalWriter.Status.UNKNOWN, (ConditionalMutation)cmk.cm, location.toString()));
                }
            }
            catch (Exception e2) {
                this.queueException(location, cmidToCm, e2);
            }
        }
    }

    private void invalidateSession(SessionID sessionId, HostAndPort location) throws AccumuloException {
        long sleepTime = 50L;
        long startTime = System.currentTimeMillis();
        ZooUtil.LockID lid = new ZooUtil.LockID(this.context.getZooKeeperRoot() + "/tservers", sessionId.lockId);
        while (true) {
            if (!ServiceLock.isLockHeld(this.context.getZooCache(), lid)) {
                this.locator.invalidateCache(this.context, location.toString());
                log.trace("tablet server {} {} is dead, so no need to invalidate {}", new Object[]{location, sessionId.lockId, sessionId.sessionID});
                return;
            }
            try {
                log.trace("Attempting to invalidate {} at {}", (Object)sessionId.sessionID, (Object)location);
                this.invalidateSession(sessionId.sessionID, location);
                log.trace("Invalidated {} at {}", (Object)sessionId.sessionID, (Object)location);
                return;
            }
            catch (TApplicationException tae) {
                throw new AccumuloServerException(location.toString(), tae);
            }
            catch (TException e) {
                this.locator.invalidateCache(this.context, location.toString());
                log.trace("Failed to invalidate {} at {} {}", new Object[]{sessionId.sessionID, location, e.getMessage()});
                if (System.currentTimeMillis() - startTime + sleepTime > this.timeout) {
                    throw new TimedOutException(Collections.singleton(location.toString()));
                }
                UtilWaitThread.sleepUninterruptibly(sleepTime, TimeUnit.MILLISECONDS);
                sleepTime = Math.min(2L * sleepTime, 30000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(long sessionId, HostAndPort location) throws TException {
        TabletClientService.Iface client = null;
        TInfo tinfo = TraceUtil.traceInfo();
        try {
            client = this.getClient(location);
            client.invalidateConditionalUpdate(tinfo, sessionId);
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client, this.context);
        }
    }

    private ConditionalWriter.Status fromThrift(TCMStatus status) {
        switch (status) {
            case ACCEPTED: {
                return ConditionalWriter.Status.ACCEPTED;
            }
            case REJECTED: {
                return ConditionalWriter.Status.REJECTED;
            }
            case VIOLATED: {
                return ConditionalWriter.Status.VIOLATED;
            }
        }
        throw new IllegalArgumentException(status.toString());
    }

    private void convertMutations(TabletLocator.TabletServerMutations<QCMutation> mutations, Map<Long, CMK> cmidToCm, MutableLong cmid, Map<TKeyExtent, List<TConditionalMutation>> tmutations, CompressedIterators compressedIters) {
        mutations.getMutations().forEach((keyExtent, mutationList) -> {
            ArrayList<TConditionalMutation> tcondMutaions = new ArrayList<TConditionalMutation>();
            for (QCMutation cm : mutationList) {
                TMutation tm = cm.toThrift();
                List<TCondition> conditions = this.convertConditions(cm, compressedIters);
                cmidToCm.put(cmid.longValue(), new CMK((KeyExtent)keyExtent, cm));
                TConditionalMutation tcm = new TConditionalMutation(conditions, tm, cmid.longValue());
                cmid.increment();
                tcondMutaions.add(tcm);
            }
            tmutations.put(keyExtent.toThrift(), tcondMutaions);
        });
    }

    private List<TCondition> convertConditions(ConditionalMutation cm, CompressedIterators compressedIters) {
        ArrayList<TCondition> conditions = new ArrayList<TCondition>(cm.getConditions().size());
        Condition[] ca = cm.getConditions().toArray(new Condition[cm.getConditions().size()]);
        Arrays.sort(ca, CONDITION_COMPARATOR);
        for (Condition cond : ca) {
            long ts = 0L;
            boolean hasTs = false;
            if (cond.getTimestamp() != null) {
                ts = cond.getTimestamp();
                hasTs = true;
            }
            ByteBuffer iters = compressedIters.compress(cond.getIterators());
            TCondition tc = new TCondition(ByteBufferUtil.toByteBuffers(cond.getFamily()), ByteBufferUtil.toByteBuffers(cond.getQualifier()), ByteBufferUtil.toByteBuffers(cond.getVisibility()), ts, hasTs, ByteBufferUtil.toByteBuffers(cond.getValue()), iters);
            conditions.add(tc);
        }
        return conditions;
    }

    private boolean isVisible(ByteSequence cv) {
        Text testVis = new Text(cv.toArray());
        if (testVis.getLength() == 0) {
            return true;
        }
        Boolean b = this.cache.get(testVis);
        if (b != null) {
            return b;
        }
        try {
            boolean bb = this.ve.evaluate(new ColumnVisibility(testVis));
            this.cache.put(new Text(testVis), bb);
            return bb;
        }
        catch (VisibilityParseException | BadArgumentException e) {
            return false;
        }
    }

    @VisibleForTesting
    public ConditionalWriterConfig getConfig() {
        return this.config;
    }

    @Override
    public ConditionalWriter.Result write(ConditionalMutation mutation) {
        return this.write(Collections.singleton(mutation).iterator()).next();
    }

    @Override
    public void close() {
        this.threadPool.shutdownNow();
        this.context.executeCleanupTask(Threads.createNamedRunnable("ConditionalWriterCleanupTask", new CleanupTask(this.getActiveSessions())));
    }

    private static class ServerQueue {
        BlockingQueue<TabletLocator.TabletServerMutations<QCMutation>> queue = new LinkedBlockingQueue<TabletLocator.TabletServerMutations<QCMutation>>();
        boolean taskQueued = false;

        private ServerQueue() {
        }
    }

    private static class QCMutation
    extends ConditionalMutation
    implements Delayed {
        private BlockingQueue<ConditionalWriter.Result> resultQueue;
        private long resetTime;
        private long delay = 50L;
        private long entryTime;

        QCMutation(ConditionalMutation cm, BlockingQueue<ConditionalWriter.Result> resultQueue, long entryTime) {
            super(cm);
            this.resultQueue = resultQueue;
            this.entryTime = entryTime;
        }

        @Override
        public int compareTo(Delayed o) {
            QCMutation oqcm = (QCMutation)o;
            return Long.compare(this.resetTime, oqcm.resetTime);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof QCMutation) {
                return this.compareTo((QCMutation)o) == 0;
            }
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delay - (System.currentTimeMillis() - this.resetTime), TimeUnit.MILLISECONDS);
        }

        void resetDelay() {
            this.delay = Math.min(this.delay * 2L, 30000L);
            this.resetTime = System.currentTimeMillis();
        }

        void queueResult(ConditionalWriter.Result result) {
            this.resultQueue.add(result);
        }
    }

    private class SendTask
    implements Runnable {
        String location;

        public SendTask(String location) {
            this.location = location;
        }

        @Override
        public void run() {
            try {
                TabletLocator.TabletServerMutations<QCMutation> mutations = ConditionalWriterImpl.this.dequeue(this.location);
                if (mutations != null) {
                    ConditionalWriterImpl.this.sendToServer(HostAndPort.fromString(this.location), mutations);
                }
            }
            finally {
                ConditionalWriterImpl.this.reschedule(this);
            }
        }
    }

    private class RQIterator
    implements Iterator<ConditionalWriter.Result> {
        private BlockingQueue<ConditionalWriter.Result> rq;
        private int count;

        public RQIterator(BlockingQueue<ConditionalWriter.Result> resultQueue, int count) {
            this.rq = resultQueue;
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public ConditionalWriter.Result next() {
            if (this.count <= 0) {
                throw new NoSuchElementException();
            }
            try {
                ConditionalWriter.Result result = this.rq.poll(1L, TimeUnit.SECONDS);
                while (result == null) {
                    if (ConditionalWriterImpl.this.threadPool.isShutdown()) {
                        throw new NoSuchElementException("ConditionalWriter closed");
                    }
                    result = this.rq.poll(1L, TimeUnit.SECONDS);
                }
                --this.count;
                return result;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SessionID {
        HostAndPort location;
        String lockId;
        long sessionID;
        boolean reserved;
        long lastAccessTime;
        long ttl;

        private SessionID() {
        }

        boolean isActive() {
            return (double)(System.currentTimeMillis() - this.lastAccessTime) < (double)this.ttl * 0.95;
        }
    }

    private static class CMK {
        QCMutation cm;
        KeyExtent ke;

        public CMK(KeyExtent ke, QCMutation cm) {
            this.ke = ke;
            this.cm = cm;
        }
    }

    private class CleanupTask
    implements Runnable {
        private List<SessionID> sessions;

        CleanupTask(List<SessionID> activeSessions) {
            this.sessions = activeSessions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TabletClientService.Iface client = null;
            for (SessionID sid : this.sessions) {
                if (!sid.isActive()) continue;
                TInfo tinfo = TraceUtil.traceInfo();
                try {
                    client = ConditionalWriterImpl.this.getClient(sid.location);
                    client.closeConditionalUpdate(tinfo, sid.sessionID);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    ThriftUtil.returnClient((TServiceClient)client, ConditionalWriterImpl.this.context);
                }
            }
        }
    }
}

