/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.cache.Cache;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.CompressedIterators;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.AbstractId;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.dataImpl.thrift.TCMResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMStatus;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalSession;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest;
import org.apache.accumulo.core.dataImpl.thrift.UpdateErrors;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionQueueSummary;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.fs.TooManyFilesException;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.tserver.AssignmentHandler;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.OnlineTablets;
import org.apache.accumulo.tserver.RowLocks;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.UnloadTabletHandler;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.compactions.ExternalCompactionJob;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.accumulo.tserver.session.ConditionalSession;
import org.apache.accumulo.tserver.session.SummarySession;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.PreparedMutations;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletClientHandler
implements TabletClientService.Iface {
    private static final Logger log = LoggerFactory.getLogger(TabletClientHandler.class);
    private final long MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS;
    private static final long RECENTLY_SPLIT_MILLIES = TimeUnit.MINUTES.toMillis(1L);
    private final TabletServer server;
    protected final TransactionWatcher watcher;
    protected final ServerContext context;
    protected final SecurityOperation security;
    private final WriteTracker writeTracker;
    private final RowLocks rowLocks = new RowLocks();

    public TabletClientHandler(TabletServer server, TransactionWatcher watcher, WriteTracker writeTracker) {
        this.context = server.getContext();
        this.watcher = watcher;
        this.writeTracker = writeTracker;
        this.security = this.context.getSecurityOperation();
        this.server = server;
        this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS = server.getContext().getConfiguration().getTimeInMillis(Property.TSERV_SCAN_RESULTS_MAX_TIMEOUT);
        log.debug("{} created", (Object)TabletClientHandler.class.getName());
    }

    public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, long tid, Map<TKeyExtent, Map<String, MapFileInfo>> files, boolean setTime) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            return (List)this.watcher.run("bulkTx", tid, () -> {
                ArrayList<TKeyExtent> failures = new ArrayList<TKeyExtent>();
                for (Map.Entry entry : files.entrySet()) {
                    TKeyExtent tke = (TKeyExtent)entry.getKey();
                    Map fileMap = (Map)entry.getValue();
                    HashMap<TabletFile, MapFileInfo> fileRefMap = new HashMap<TabletFile, MapFileInfo>();
                    for (Map.Entry mapping : fileMap.entrySet()) {
                        Path path = new Path((String)mapping.getKey());
                        FileSystem ns = this.context.getVolumeManager().getFileSystemByPath(path);
                        path = ns.makeQualified(path);
                        fileRefMap.put(new TabletFile(path), (MapFileInfo)mapping.getValue());
                    }
                    Tablet importTablet = this.server.getOnlineTablet(KeyExtent.fromThrift((TKeyExtent)tke));
                    if (importTablet == null) {
                        failures.add(tke);
                        continue;
                    }
                    try {
                        importTablet.importMapFiles(tid, fileRefMap, setTime);
                    }
                    catch (IOException ioe) {
                        log.info("files {} not imported to {}: {}", new Object[]{fileMap.keySet(), KeyExtent.fromThrift((TKeyExtent)tke), ioe.getMessage()});
                        failures.add(tke);
                    }
                }
                return failures;
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadFiles(TInfo tinfo, TCredentials credentials, long tid, String dir, Map<TKeyExtent, Map<String, MapFileInfo>> tabletImports, boolean setTime) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.watcher.runQuietly("bulkTx", tid, () -> tabletImports.forEach((tke, fileMap) -> {
            HashMap<TabletFile, MapFileInfo> newFileMap = new HashMap<TabletFile, MapFileInfo>();
            for (Map.Entry mapping : fileMap.entrySet()) {
                Path path = new Path(dir, (String)mapping.getKey());
                FileSystem ns = this.context.getVolumeManager().getFileSystemByPath(path);
                path = ns.makeQualified(path);
                newFileMap.put(new TabletFile(path), (MapFileInfo)mapping.getValue());
            }
            List<String> files = newFileMap.keySet().stream().map(TabletFile::getPathStr).collect(Collectors.toList());
            this.server.updateBulkImportState(files, BulkImportState.INITIAL);
            Tablet importTablet = this.server.getOnlineTablet(KeyExtent.fromThrift((TKeyExtent)tke));
            if (importTablet != null) {
                try {
                    this.server.updateBulkImportState(files, BulkImportState.PROCESSING);
                    importTablet.importMapFiles(tid, newFileMap, setTime);
                }
                catch (IOException ioe) {
                    log.debug("files {} not imported to {}: {}", new Object[]{fileMap.keySet(), KeyExtent.fromThrift((TKeyExtent)tke), ioe.getMessage()});
                }
                finally {
                    this.server.removeBulkImportState(files);
                }
            }
        }));
    }

    public long startUpdate(TInfo tinfo, TCredentials credentials, TDurability tdurabilty) throws ThriftSecurityException {
        Durability durability = DurabilityImpl.fromThrift((TDurability)tdurabilty);
        this.security.authenticateUser(credentials, credentials);
        this.server.updateMetrics.addPermissionErrors(0L);
        UpdateSession us = new UpdateSession(new TservConstraintEnv(this.server.getContext(), this.security, credentials), credentials, durability);
        return this.server.sessionManager.createSession(us, false);
    }

    private void setUpdateTablet(UpdateSession us, KeyExtent keyExtent) {
        long t1 = System.currentTimeMillis();
        if (us.currentTablet != null && us.currentTablet.getExtent().equals((Object)keyExtent)) {
            return;
        }
        if (us.currentTablet == null && (us.failures.containsKey(keyExtent) || us.authFailures.containsKey(keyExtent))) {
            return;
        }
        TableId tableId = null;
        try {
            boolean sameTable = us.currentTablet != null && us.currentTablet.getExtent().tableId().equals((Object)keyExtent.tableId());
            tableId = keyExtent.tableId();
            if (sameTable || this.security.canWrite(us.getCredentials(), tableId, this.server.getContext().getNamespaceId(tableId))) {
                long t2 = System.currentTimeMillis();
                us.authTimes.addStat(t2 - t1);
                us.currentTablet = this.server.getOnlineTablet(keyExtent);
                if (us.currentTablet != null) {
                    us.queuedMutations.put(us.currentTablet, new ArrayList());
                } else {
                    us.failures.put(keyExtent, 0L);
                    this.server.updateMetrics.addUnknownTabletErrors(0L);
                }
            } else {
                log.warn("Denying access to table {} for user {}", (Object)keyExtent.tableId(), (Object)us.getUser());
                long t2 = System.currentTimeMillis();
                us.authTimes.addStat(t2 - t1);
                us.currentTablet = null;
                us.authFailures.put(keyExtent, SecurityErrorCode.PERMISSION_DENIED);
                this.server.updateMetrics.addPermissionErrors(0L);
            }
        }
        catch (TableNotFoundException tnfe) {
            log.error("Table " + tableId + " not found ", (Throwable)tnfe);
            long t2 = System.currentTimeMillis();
            us.authTimes.addStat(t2 - t1);
            us.currentTablet = null;
            us.authFailures.put(keyExtent, SecurityErrorCode.TABLE_DOESNT_EXIST);
            this.server.updateMetrics.addUnknownTabletErrors(0L);
            return;
        }
        catch (ThriftSecurityException e) {
            log.error("Denying permission to check user " + us.getUser() + " with user " + e.getUser(), (Throwable)e);
            long t2 = System.currentTimeMillis();
            us.authTimes.addStat(t2 - t1);
            us.currentTablet = null;
            us.authFailures.put(keyExtent, e.getCode());
            this.server.updateMetrics.addPermissionErrors(0L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent tkeyExtent, List<TMutation> tmutations) {
        UpdateSession us = (UpdateSession)this.server.sessionManager.reserveSession(updateID);
        if (us == null) {
            return;
        }
        boolean reserved = true;
        try {
            KeyExtent keyExtent = KeyExtent.fromThrift((TKeyExtent)tkeyExtent);
            this.setUpdateTablet(us, keyExtent);
            if (us.currentTablet != null) {
                long total;
                long additionalMutationSize = 0L;
                List<Mutation> mutations = us.queuedMutations.get(us.currentTablet);
                for (TMutation tmutation : tmutations) {
                    ServerMutation mutation = new ServerMutation(tmutation);
                    mutations.add((Mutation)mutation);
                    additionalMutationSize += mutation.numBytes();
                }
                us.queuedMutationSize += additionalMutationSize;
                long totalQueued = this.server.updateTotalQueuedMutationSize(additionalMutationSize);
                if (totalQueued > (total = this.server.getConfiguration().getAsBytes(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX))) {
                    try {
                        this.flush(us);
                    }
                    catch (HoldTimeoutException hte) {
                        log.debug("HoldTimeoutException during applyUpdates, removing session");
                        this.server.sessionManager.removeSession(updateID, true);
                        reserved = false;
                    }
                }
            }
        }
        finally {
            if (reserved) {
                this.server.sessionManager.unreserveSession(us);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(UpdateSession us) {
        int mutationCount = 0;
        HashMap<CommitSession, List> sendables = new HashMap<CommitSession, List>();
        HashMap<CommitSession, TabletMutations> loggables = new HashMap<CommitSession, TabletMutations>();
        Exception error = null;
        long pt1 = System.currentTimeMillis();
        boolean containsMetadataTablet = false;
        for (Tablet tablet : us.queuedMutations.keySet()) {
            if (!tablet.getExtent().isMeta()) continue;
            containsMetadataTablet = true;
        }
        if (!containsMetadataTablet && !us.queuedMutations.isEmpty()) {
            this.server.resourceManager.waitUntilCommitsAreEnabled();
        }
        Span span = TraceUtil.startSpan(this.getClass(), (String)"flush::prep");
        try (Scope scope = span.makeCurrent();){
            for (Map.Entry<Tablet, List<Mutation>> entry : us.queuedMutations.entrySet()) {
                Tablet tablet = entry.getKey();
                Durability durability = DurabilityImpl.resolveDurabilty((Durability)us.durability, (Durability)tablet.getDurability());
                List<Mutation> mutations2 = entry.getValue();
                if (mutations2.isEmpty()) continue;
                try {
                    this.server.updateMetrics.addMutationArraySize(mutations2.size());
                    PreparedMutations prepared = tablet.prepareMutationsForCommit(us.cenv, mutations2);
                    if (prepared.tabletClosed()) {
                        if (us.currentTablet == tablet) {
                            us.currentTablet = null;
                        }
                        us.failures.put(tablet.getExtent(), us.successfulCommits.get((Object)tablet));
                        continue;
                    }
                    if (!prepared.getNonViolators().isEmpty()) {
                        List<Mutation> validMutations = prepared.getNonViolators();
                        CommitSession session = prepared.getCommitSession();
                        if (durability != Durability.NONE) {
                            loggables.put(session, new TabletMutations(session, validMutations, durability));
                        }
                        sendables.put(session, validMutations);
                    }
                    if (!prepared.getViolations().isEmpty()) {
                        us.violations.add(prepared.getViolations());
                        this.server.updateMetrics.addConstraintViolations(0L);
                    }
                    mutationCount += mutations2.size();
                }
                catch (Exception t) {
                    error = t;
                    log.error("Unexpected error preparing for commit", (Throwable)error);
                    TraceUtil.setException((Span)span, (Throwable)t, (boolean)false);
                    break;
                }
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
        long pt2 = System.currentTimeMillis();
        us.prepareTimes.addStat(pt2 - pt1);
        this.updateAvgPrepTime(pt2 - pt1, us.queuedMutations.size());
        if (error != null) {
            sendables.forEach((commitSession, value) -> commitSession.abortCommit());
            throw new RuntimeException(error);
        }
        try {
            Span span2 = TraceUtil.startSpan(this.getClass(), (String)"flush::wal");
            try (Scope scope = span2.makeCurrent();){
                while (true) {
                    try {
                        long t1 = System.currentTimeMillis();
                        this.server.logger.logManyTablets(loggables);
                        long t2 = System.currentTimeMillis();
                        us.walogTimes.addStat(t2 - t1);
                        this.updateWalogWriteTime(t2 - t1);
                    }
                    catch (IOException | FSError ex) {
                        log.warn("logging mutations failed, retrying");
                        continue;
                    }
                    catch (Exception t) {
                        log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", (Throwable)t);
                        throw new RuntimeException(t);
                    }
                    break;
                }
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span2.end();
            }
            Span span3 = TraceUtil.startSpan(this.getClass(), (String)"flush::commit");
            try (Scope scope = span3.makeCurrent();){
                long t1 = System.currentTimeMillis();
                sendables.forEach((commitSession, mutations) -> {
                    commitSession.commit((List<Mutation>)mutations);
                    KeyExtent extent = commitSession.getExtent();
                    if (us.currentTablet != null && extent == us.currentTablet.getExtent()) {
                        us.successfulCommits.increment((Object)us.currentTablet, (long)us.queuedMutations.get(us.currentTablet).size());
                    }
                });
                long t2 = System.currentTimeMillis();
                us.flushTime += t2 - pt1;
                us.commitTimes.addStat(t2 - t1);
                this.updateAvgCommitTime(t2 - t1, sendables.size());
            }
            finally {
                span3.end();
            }
        }
        finally {
            us.queuedMutations.clear();
            if (us.currentTablet != null) {
                us.queuedMutations.put(us.currentTablet, new ArrayList());
            }
            this.server.updateTotalQueuedMutationSize(-us.queuedMutationSize);
            us.queuedMutationSize = 0L;
        }
        us.totalUpdates += (long)mutationCount;
    }

    private void updateWalogWriteTime(long time) {
        this.server.updateMetrics.addWalogWriteTime(time);
    }

    private void updateAvgCommitTime(long time, int size) {
        if (size > 0) {
            this.server.updateMetrics.addCommitTime((long)((double)time / (double)size));
        }
    }

    private void updateAvgPrepTime(long time, int size) {
        if (size > 0) {
            this.server.updateMetrics.addCommitPrep((long)((double)time / (double)size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateErrors closeUpdate(TInfo tinfo, long updateID) throws NoSuchScanIDException {
        UpdateSession us = (UpdateSession)this.server.sessionManager.reserveSession(updateID, true);
        if (us == null) {
            throw new NoSuchScanIDException();
        }
        try {
            ConstraintViolationSummary first;
            List violations;
            long opid = this.writeTracker.startWrite(us.queuedMutations.keySet());
            try {
                this.flush(us);
            }
            catch (HoldTimeoutException e2) {
                log.debug("HoldTimeoutException during closeUpdate, reporting no such session");
                throw new NoSuchScanIDException();
            }
            finally {
                this.writeTracker.finishWrite(opid);
            }
            if (log.isTraceEnabled()) {
                log.trace(String.format("UpSess %s %,d in %.3fs, at=[%s] ft=%.3fs(pt=%.3fs lt=%.3fs ct=%.3fs)", TServerUtils.clientAddress.get(), us.totalUpdates, (double)(System.currentTimeMillis() - us.startTime) / 1000.0, us.authTimes, (double)us.flushTime / 1000.0, (double)us.prepareTimes.sum() / 1000.0, (double)us.walogTimes.sum() / 1000.0, (double)us.commitTimes.sum() / 1000.0));
            }
            if (!us.failures.isEmpty()) {
                Map.Entry<KeyExtent, Long> first2 = us.failures.entrySet().iterator().next();
                log.debug(String.format("Failures: %d, first extent %s successful commits: %d", us.failures.size(), first2.getKey().toString(), first2.getValue()));
            }
            if (!(violations = us.violations.asList()).isEmpty()) {
                first = (ConstraintViolationSummary)us.violations.asList().iterator().next();
                log.debug(String.format("Violations: %d, first %s occurs %d", violations.size(), first.violationDescription, first.numberOfViolatingMutations));
            }
            if (!us.authFailures.isEmpty()) {
                first = us.authFailures.keySet().iterator().next();
                log.debug(String.format("Authentication Failures: %d, first %s", us.authFailures.size(), first.toString()));
            }
            UpdateErrors updateErrors = new UpdateErrors(us.failures.entrySet().stream().collect(Collectors.toMap(e -> ((KeyExtent)e.getKey()).toThrift(), Map.Entry::getValue)), violations.stream().map(ConstraintViolationSummary::toThrift).collect(Collectors.toList()), us.authFailures.entrySet().stream().collect(Collectors.toMap(e -> ((KeyExtent)e.getKey()).toThrift(), Map.Entry::getValue)));
            return updateErrors;
        }
        finally {
            this.server.sessionManager.removeSession(updateID, true);
        }
    }

    public boolean cancelUpdate(TInfo tinfo, long updateID) throws TException {
        return this.server.sessionManager.removeIfNotReserved(updateID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, TMutation tmutation, TDurability tdurability) throws NotServingTabletException, ConstraintViolationException, ThriftSecurityException {
        NamespaceId namespaceId;
        TableId tableId = TableId.of((String)new String(tkeyExtent.getTable(), StandardCharsets.UTF_8));
        if (!this.security.canWrite(credentials, tableId, namespaceId = this.getNamespaceId(credentials, tableId))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        KeyExtent keyExtent = KeyExtent.fromThrift((TKeyExtent)tkeyExtent);
        Tablet tablet = this.server.getOnlineTablet(KeyExtent.copyOf((KeyExtent)keyExtent));
        if (tablet == null) {
            throw new NotServingTabletException(tkeyExtent);
        }
        Durability tabletDurability = tablet.getDurability();
        if (!keyExtent.isMeta()) {
            try {
                this.server.resourceManager.waitUntilCommitsAreEnabled();
            }
            catch (HoldTimeoutException hte) {
                throw new NotServingTabletException(tkeyExtent);
            }
        }
        long opid = this.writeTracker.startWrite(TabletType.type((KeyExtent)keyExtent));
        try {
            Scope scope;
            PreparedMutations prepared;
            ServerMutation mutation = new ServerMutation(tmutation);
            List<ServerMutation> mutations = Collections.singletonList(mutation);
            Span span = TraceUtil.startSpan(this.getClass(), (String)"update::prep");
            try (Scope scope2 = span.makeCurrent();){
                prepared = tablet.prepareMutationsForCommit(new TservConstraintEnv(this.server.getContext(), this.security, credentials), mutations);
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            if (prepared.tabletClosed()) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (!prepared.getViolators().isEmpty()) {
                throw new ConstraintViolationException(prepared.getViolations().asList().stream().map(ConstraintViolationSummary::toThrift).collect(Collectors.toList()));
            }
            CommitSession session = prepared.getCommitSession();
            Durability durability = DurabilityImpl.resolveDurabilty((Durability)DurabilityImpl.fromThrift((TDurability)tdurability), (Durability)tabletDurability);
            while (durability != Durability.NONE) {
                try {
                    Span span2 = TraceUtil.startSpan(this.getClass(), (String)"update::wal");
                    try {
                        scope = span2.makeCurrent();
                        try {
                            this.server.logger.log(session, (Mutation)mutation, durability);
                            break;
                        }
                        finally {
                            if (scope != null) {
                                scope.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                        throw e;
                    }
                    finally {
                        span2.end();
                    }
                }
                catch (IOException ex) {
                    log.warn("Error writing mutations to log", (Throwable)ex);
                }
            }
            Span span3 = TraceUtil.startSpan(this.getClass(), (String)"update::commit");
            try {
                scope = span3.makeCurrent();
                try {
                    session.commit(mutations);
                }
                finally {
                    if (scope != null) {
                        scope.close();
                    }
                }
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span3, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span3.end();
            }
        }
        finally {
            this.writeTracker.finishWrite(opid);
        }
    }

    private NamespaceId getNamespaceId(TCredentials credentials, TableId tableId) throws ThriftSecurityException {
        try {
            return this.server.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e1) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    private void checkConditions(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession cs, List<String> symbols) throws IOException {
        Iterator<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> iter = updates.entrySet().iterator();
        CompressedIterators compressedIters = new CompressedIterators(symbols);
        ConditionCheckerContext checkerContext = new ConditionCheckerContext(this.server.getContext(), compressedIters, this.context.getTableConfiguration(cs.tableId));
        while (iter.hasNext()) {
            Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry = iter.next();
            Tablet tablet = this.server.getOnlineTablet(entry.getKey());
            if (tablet == null || tablet.isClosed()) {
                for (ServerConditionalMutation scm : entry.getValue()) {
                    results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                }
                iter.remove();
                continue;
            }
            ArrayList<ServerConditionalMutation> okMutations = new ArrayList<ServerConditionalMutation>(entry.getValue().size());
            List<TCMResult> resultsSubList = results.subList(results.size(), results.size());
            ConditionCheckerContext.ConditionChecker checker = checkerContext.newChecker(entry.getValue(), okMutations, resultsSubList);
            try {
                tablet.checkConditions(checker, cs.auths, cs.interruptFlag);
                if (okMutations.isEmpty()) {
                    iter.remove();
                    continue;
                }
                entry.setValue(okMutations);
            }
            catch (IterationInterruptedException | TooManyFilesException | TabletClosedException e) {
                resultsSubList.clear();
                for (ServerConditionalMutation scm : entry.getValue()) {
                    results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                }
                iter.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeConditionalMutations(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession sess) {
        Set<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> es = updates.entrySet();
        HashMap<CommitSession, List> sendables = new HashMap<CommitSession, List>();
        HashMap<CommitSession, TabletMutations> loggables = new HashMap<CommitSession, TabletMutations>();
        boolean sessionCanceled = sess.interruptFlag.get();
        Span span = TraceUtil.startSpan(this.getClass(), (String)"writeConditionalMutations::prep");
        try (Scope scope = span.makeCurrent();){
            long t1 = System.currentTimeMillis();
            for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : es) {
                Tablet tablet = this.server.getOnlineTablet(entry.getKey());
                if (tablet == null || tablet.isClosed() || sessionCanceled) {
                    this.addMutationsAsTCMResults(results, (Collection<? extends Mutation>)entry.getValue(), TCMStatus.IGNORED);
                    continue;
                }
                Durability durability = DurabilityImpl.resolveDurabilty((Durability)sess.durability, (Durability)tablet.getDurability());
                List<ServerConditionalMutation> mutations = Collections.unmodifiableList(entry.getValue());
                if (mutations.isEmpty()) continue;
                PreparedMutations prepared = tablet.prepareMutationsForCommit(new TservConstraintEnv(this.server.getContext(), this.security, sess.credentials), mutations);
                if (prepared.tabletClosed()) {
                    this.addMutationsAsTCMResults(results, mutations, TCMStatus.IGNORED);
                    continue;
                }
                if (!prepared.getNonViolators().isEmpty()) {
                    List<Mutation> validMutations = prepared.getNonViolators();
                    this.addMutationsAsTCMResults(results, validMutations, TCMStatus.ACCEPTED);
                    CommitSession session = prepared.getCommitSession();
                    if (durability != Durability.NONE) {
                        loggables.put(session, new TabletMutations(session, validMutations, durability));
                    }
                    sendables.put(session, validMutations);
                }
                if (prepared.getViolators().isEmpty()) continue;
                this.addMutationsAsTCMResults(results, prepared.getViolators(), TCMStatus.VIOLATED);
            }
            long t2 = System.currentTimeMillis();
            this.updateAvgPrepTime(t2 - t1, es.size());
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
        Span span2 = TraceUtil.startSpan(this.getClass(), (String)"writeConditionalMutations::wal");
        try (Scope scope = span2.makeCurrent();){
            while (!loggables.isEmpty()) {
                try {
                    long t1 = System.currentTimeMillis();
                    this.server.logger.logManyTablets(loggables);
                    long t2 = System.currentTimeMillis();
                    this.updateWalogWriteTime(t2 - t1);
                    break;
                }
                catch (IOException | FSError ex) {
                    TraceUtil.setException((Span)span2, (Throwable)ex, (boolean)false);
                    log.warn("logging mutations failed, retrying");
                }
                catch (Exception t) {
                    log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", (Throwable)t);
                    throw new RuntimeException(t);
                }
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span2.end();
        }
        Span span3 = TraceUtil.startSpan(this.getClass(), (String)"writeConditionalMutations::commit");
        try (Scope scope = span3.makeCurrent();){
            long t1 = System.currentTimeMillis();
            sendables.forEach(CommitSession::commit);
            long t2 = System.currentTimeMillis();
            this.updateAvgCommitTime(t2 - t1, sendables.size());
            return;
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span3, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span3.end();
        }
    }

    private void addMutationsAsTCMResults(List<TCMResult> list, Collection<? extends Mutation> mutations, TCMStatus status) {
        mutations.stream().map(mutation -> new TCMResult(((ServerConditionalMutation)((Object)mutation)).getID(), status)).forEach(list::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KeyExtent, List<ServerConditionalMutation>> conditionalUpdate(ConditionalSession cs, Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, List<String> symbols) throws IOException {
        ConditionalMutationSet.sortConditionalMutations(updates);
        HashMap<KeyExtent, List<ServerConditionalMutation>> deferred = new HashMap<KeyExtent, List<ServerConditionalMutation>>();
        ConditionalMutationSet.deferDuplicatesRows(updates, deferred);
        List<RowLocks.RowLock> locks = this.rowLocks.acquireRowlocks(updates, deferred);
        try {
            Span span = TraceUtil.startSpan(this.getClass(), (String)"conditionalUpdate::Check conditions");
            try (Scope scope = span.makeCurrent();){
                this.checkConditions(updates, results, cs, symbols);
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            Span span2 = TraceUtil.startSpan(this.getClass(), (String)"conditionalUpdate::apply conditional mutations");
            try (Scope scope = span2.makeCurrent();){
                this.writeConditionalMutations(updates, results, cs);
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span2.end();
            }
        }
        finally {
            this.rowLocks.releaseRowLocks(locks);
        }
        return deferred;
    }

    public TConditionalSession startConditionalUpdate(TInfo tinfo, TCredentials credentials, List<ByteBuffer> authorizations, String tableIdStr, TDurability tdurabilty, String classLoaderContext) throws ThriftSecurityException, TException {
        TableId tableId = TableId.of((String)tableIdStr);
        Authorizations userauths = null;
        NamespaceId namespaceId = this.getNamespaceId(credentials, tableId);
        if (!this.security.canConditionallyUpdate(credentials, tableId, namespaceId)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        userauths = this.security.getUserAuthorizations(credentials);
        for (ByteBuffer auth : authorizations) {
            if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
        }
        ConditionalSession cs = new ConditionalSession(credentials, new Authorizations(authorizations), tableId, DurabilityImpl.fromThrift((TDurability)tdurabilty));
        long sid = this.server.sessionManager.createSession(cs, false);
        return new TConditionalSession(sid, this.server.getLockID(), this.server.sessionManager.getMaxIdleTime());
    }

    public List<TCMResult> conditionalUpdate(TInfo tinfo, long sessID, Map<TKeyExtent, List<TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, TException {
        ConditionalSession cs = null;
        Long opid = null;
        try {
            cs = (ConditionalSession)this.server.sessionManager.reserveSession(sessID);
            if (cs == null || cs.interruptFlag.get()) {
                throw new NoSuchScanIDException();
            }
            if (!cs.tableId.equals((Object)MetadataTable.ID) && !cs.tableId.equals((Object)RootTable.ID)) {
                try {
                    this.server.resourceManager.waitUntilCommitsAreEnabled();
                }
                catch (HoldTimeoutException hte) {
                    log.debug("HoldTimeoutException during conditionalUpdate, reporting no such session");
                    throw new NoSuchScanIDException();
                }
            }
            TableId tid = cs.tableId;
            opid = this.writeTracker.startWrite(TabletType.type((KeyExtent)new KeyExtent(tid, null, null)));
            Map<KeyExtent, List<ServerConditionalMutation>> updates = mutations.entrySet().stream().collect(Collectors.toMap(entry -> KeyExtent.fromThrift((TKeyExtent)((TKeyExtent)entry.getKey())), entry -> ((List)entry.getValue()).stream().map(ServerConditionalMutation::new).collect(Collectors.toList())));
            for (KeyExtent ke : updates.keySet()) {
                if (ke.tableId().equals((Object)tid)) continue;
                throw new IllegalArgumentException("Unexpected table id " + tid + " != " + ke.tableId());
            }
            ArrayList<TCMResult> results = new ArrayList<TCMResult>();
            Map<KeyExtent, List<ServerConditionalMutation>> deferred = this.conditionalUpdate(cs, updates, results, symbols);
            while (!deferred.isEmpty()) {
                deferred = this.conditionalUpdate(cs, deferred, results, symbols);
            }
            ArrayList<TCMResult> arrayList = results;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new TException((Throwable)ioe);
        }
        catch (Exception e) {
            log.warn("Exception returned for conditionalUpdate {}", (Throwable)e);
            throw e;
        }
        finally {
            if (opid != null) {
                this.writeTracker.finishWrite(opid);
            }
            if (cs != null) {
                this.server.sessionManager.unreserveSession(sessID);
            }
        }
    }

    public void invalidateConditionalUpdate(TInfo tinfo, long sessID) {
        ConditionalSession cs = (ConditionalSession)this.server.sessionManager.getSession(sessID);
        if (cs != null) {
            cs.interruptFlag.set(true);
        }
        if ((cs = (ConditionalSession)this.server.sessionManager.reserveSession(sessID, true)) != null) {
            this.server.sessionManager.removeSession(sessID, true);
        }
    }

    public void closeConditionalUpdate(TInfo tinfo, long sessID) {
        this.server.sessionManager.removeSession(sessID, false);
    }

    public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, ByteBuffer splitPoint) throws NotServingTabletException, ThriftSecurityException {
        NamespaceId namespaceId;
        TableId tableId = TableId.of((String)new String(ByteBufferUtil.toBytes((ByteBuffer)tkeyExtent.table), StandardCharsets.UTF_8));
        if (!this.security.canSplitTablet(credentials, tableId, namespaceId = this.getNamespaceId(credentials, tableId))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        KeyExtent keyExtent = KeyExtent.fromThrift((TKeyExtent)tkeyExtent);
        Tablet tablet = this.server.getOnlineTablet(keyExtent);
        if (tablet == null) {
            throw new NotServingTabletException(tkeyExtent);
        }
        if (keyExtent.endRow() == null || !keyExtent.endRow().equals((Object)ByteBufferUtil.toText((ByteBuffer)splitPoint))) {
            try {
                if (this.server.splitTablet(tablet, ByteBufferUtil.toBytes((ByteBuffer)splitPoint)) == null) {
                    throw new NotServingTabletException(tkeyExtent);
                }
            }
            catch (IOException e) {
                log.warn("Failed to split " + keyExtent, (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (RuntimeException re) {
                log.warn("Failed to split " + keyExtent, (Throwable)re);
                throw re;
            }
        }
    }

    public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) {
        return this.server.getStats(this.server.sessionManager.getActiveScansPerTable());
    }

    public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) {
        ArrayList<TabletStats> result = new ArrayList<TabletStats>();
        TableId text = TableId.of((String)tableId);
        KeyExtent start = new KeyExtent(text, new Text(), null);
        for (Map.Entry<KeyExtent, Tablet> entry : this.server.getOnlineTablets().tailMap(start).entrySet()) {
            KeyExtent ke = entry.getKey();
            if (ke.tableId().compareTo((AbstractId)text) != 0) continue;
            Tablet tablet = entry.getValue();
            TabletStats stats = tablet.getTabletStats();
            stats.extent = ke.toThrift();
            stats.ingestRate = tablet.ingestRate();
            stats.queryRate = tablet.queryRate();
            stats.splitCreationTime = tablet.getSplitCreationTime();
            stats.numEntries = tablet.getNumEntries();
            result.add(stats);
        }
        return result;
    }

    static void checkPermission(SecurityOperation security, ServerContext context, TabletHostingServer server, TCredentials credentials, String lock, String request) throws ThriftSecurityException {
        try {
            log.trace("Got {} message from user: {}", (Object)request, (Object)credentials.getPrincipal());
            if (!security.canPerformSystemActions(credentials)) {
                log.warn("Got {} message from user: {}", (Object)request, (Object)credentials.getPrincipal());
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
        }
        catch (ThriftSecurityException e) {
            log.warn("Got {} message from unauthenticatable user: {}", (Object)request, (Object)e.getUser());
            if (context.getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName())) {
                log.error("Got message from a service with a mismatched configuration. Please ensure a compatible configuration.", (Throwable)e);
            }
            throw e;
        }
        if (server.getLock() == null || !server.getLock().wasLockAcquired()) {
            log.debug("Got {} message before my lock was acquired, ignoring...", (Object)request);
            throw new RuntimeException("Lock not acquired");
        }
        if (server.getLock() != null && server.getLock().wasLockAcquired() && !server.getLock().isLocked()) {
            Halt.halt((int)1, () -> {
                log.info("Tablet server no longer holds lock during checkPermission() : {}, exiting", (Object)request);
                server.getGcLogger().logGCInfo(server.getConfiguration());
            });
        }
        if (lock != null) {
            ZooUtil.LockID lid = new ZooUtil.LockID(context.getZooKeeperRoot() + "/managers/lock", lock);
            try {
                if (!ServiceLock.isLockHeld((ZooCache)server.getManagerLockCache(), (ZooUtil.LockID)lid)) {
                    server.getManagerLockCache().clear();
                    if (!ServiceLock.isLockHeld((ZooCache)server.getManagerLockCache(), (ZooUtil.LockID)lid)) {
                        log.warn("Got {} message from a manager that does not hold the current lock {}", (Object)request, (Object)lock);
                        throw new RuntimeException("bad manager lock");
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("bad manager lock", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "loadTablet");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to load a tablet", (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)textent);
        SortedSet<KeyExtent> sortedSet = this.server.unopenedTablets;
        synchronized (sortedSet) {
            SortedSet<KeyExtent> sortedSet2 = this.server.openingTablets;
            synchronized (sortedSet2) {
                OnlineTablets onlineTablets = this.server.onlineTablets;
                synchronized (onlineTablets) {
                    Set unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, this.server.unopenedTablets);
                    Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, this.server.openingTablets);
                    Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, this.server.getOnlineTablets());
                    HashSet all = new HashSet();
                    all.addAll(unopenedOverlapping);
                    all.addAll(openingOverlapping);
                    all.addAll(onlineOverlapping);
                    if (!all.isEmpty()) {
                        for (KeyExtent e2 : onlineOverlapping) {
                            Tablet tablet = this.server.getOnlineTablet(e2);
                            if (System.currentTimeMillis() - tablet.getSplitCreationTime() >= RECENTLY_SPLIT_MILLIES) continue;
                            all.remove(e2);
                        }
                        all.remove(extent);
                        if (!all.isEmpty()) {
                            log.error("Tablet {} overlaps a previously assigned tablet, possibly due to a recent split. Overlapping tablets:  Unopened: {}, Opening: {}, Online: {}", new Object[]{extent, unopenedOverlapping, openingOverlapping, onlineOverlapping});
                        }
                        return;
                    }
                    this.server.unopenedTablets.add(extent);
                }
            }
        }
        TabletLogger.loading((KeyExtent)extent, (TServerInstance)this.server.getTabletSession());
        AssignmentHandler ah = new AssignmentHandler(this.server, extent);
        if (extent.isRootTablet()) {
            Threads.createThread((String)"Root Tablet Assignment", () -> {
                ah.run();
                if (this.server.getOnlineTablets().containsKey(extent)) {
                    log.info("Root tablet loaded: {}", (Object)extent);
                } else {
                    log.info("Root tablet failed to load");
                }
            }).start();
        } else if (extent.isMeta()) {
            this.server.resourceManager.addMetaDataAssignment(extent, log, ah);
        } else {
            this.server.resourceManager.addAssignment(extent, log, ah);
        }
    }

    public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent, TUnloadTabletGoal goal, long requestTime) {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "unloadTablet");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to unload a tablet", (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)textent);
        this.server.resourceManager.addMigration(extent, new UnloadTabletHandler(this.server, extent, goal, requestTime));
    }

    public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
        long flushID;
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "flush");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to flush a table", (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyExtent ke = new KeyExtent(TableId.of((String)tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
        List<Tablet> tabletsToFlush = this.server.getOnlineTablets().values().stream().filter(tablet -> ke.overlaps(tablet.getExtent())).collect(Collectors.toList());
        if (tabletsToFlush.isEmpty()) {
            return;
        }
        try {
            Tablet firstTablet = (Tablet)tabletsToFlush.get(0);
            flushID = firstTablet.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Asked to flush table that has no flush id {} {}", (Object)ke, (Object)e.getMessage());
            return;
        }
        tabletsToFlush.forEach(tablet -> tablet.flush(flushID));
    }

    public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "flushTablet");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to flush a tablet", (Throwable)e);
            throw new RuntimeException(e);
        }
        Tablet tablet = this.server.getOnlineTablet(KeyExtent.fromThrift((TKeyExtent)textent));
        if (tablet != null) {
            log.info("Flushing {}", (Object)tablet.getExtent());
            try {
                tablet.flush(tablet.getFlushID());
            }
            catch (KeeperException.NoNodeException nne) {
                log.info("Asked to flush tablet that has no flush id {} {}", (Object)KeyExtent.fromThrift((TKeyExtent)textent), (Object)nne.getMessage());
            }
        }
    }

    public void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException {
        TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "halt");
        Halt.halt((int)0, () -> {
            log.info("Manager requested tablet server halt");
            this.server.gcLogger.logGCInfo(this.server.getConfiguration());
            this.server.requestStop();
            try {
                this.server.getLock().unlock();
            }
            catch (Exception e) {
                log.error("Caught exception unlocking TabletServer lock", (Throwable)e);
            }
        });
    }

    public void fastHalt(TInfo info, TCredentials credentials, String lock) {
        try {
            this.halt(info, credentials, lock);
        }
        catch (Exception e) {
            log.warn("Error halting", (Throwable)e);
        }
    }

    public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) {
        return this.server.statsKeeper.getTabletStats();
    }

    public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "chop");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to chop extent", (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyExtent ke = KeyExtent.fromThrift((TKeyExtent)textent);
        Tablet tablet = this.server.getOnlineTablet(ke);
        if (tablet != null) {
            tablet.chopFiles();
        }
    }

    public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, lock, "compact");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to compact a table", (Throwable)e);
            throw new RuntimeException(e);
        }
        KeyExtent ke = new KeyExtent(TableId.of((String)tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
        Pair<Long, CompactionConfig> compactionInfo = null;
        for (Tablet tablet : this.server.getOnlineTablets().values()) {
            if (!ke.overlaps(tablet.getExtent())) continue;
            if (compactionInfo == null) {
                try {
                    compactionInfo = tablet.getCompactionID();
                }
                catch (KeeperException.NoNodeException e) {
                    log.info("Asked to compact table with no compaction id {} {}", (Object)ke, (Object)e.getMessage());
                    return;
                }
            }
            tablet.compactAll((Long)compactionInfo.getFirst(), (CompactionConfig)compactionInfo.getSecond());
        }
    }

    public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        try {
            TabletClientHandler.checkPermission(this.security, this.context, this.server, credentials, null, "getActiveCompactions");
        }
        catch (ThriftSecurityException e) {
            log.error("Caller doesn't have permission to get active compactions", (Throwable)e);
            throw e;
        }
        List compactions = FileCompactor.getRunningCompactions();
        ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
        for (CompactionInfo compactionInfo : compactions) {
            ret.add(compactionInfo.toThrift());
        }
        return ret;
    }

    public List<TCompactionQueueSummary> getCompactionQueueInfo(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        return this.server.getCompactionManager().getCompactionQueueSummaries();
    }

    public TExternalCompactionJob reserveCompactionJob(TInfo tinfo, TCredentials credentials, String queueName, long priority, String compactor, String externalCompactionId) throws ThriftSecurityException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExternalCompactionId eci = ExternalCompactionId.of((String)externalCompactionId);
        ExternalCompactionJob extCompaction = this.server.getCompactionManager().reserveExternalCompaction(queueName, priority, compactor, eci);
        if (extCompaction != null) {
            return extCompaction.toThrift();
        }
        return new TExternalCompactionJob();
    }

    public void compactionJobFinished(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent, long fileSize, long entries) throws ThriftSecurityException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        this.server.getCompactionManager().commitExternalCompaction(ExternalCompactionId.of((String)externalCompactionId), KeyExtent.fromThrift((TKeyExtent)extent), this.server.getOnlineTablets(), fileSize, entries);
    }

    public void compactionJobFailed(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent) throws TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        this.server.getCompactionManager().externalCompactionFailed(ExternalCompactionId.of((String)externalCompactionId), KeyExtent.fromThrift((TKeyExtent)extent), this.server.getOnlineTablets());
    }

    public List<String> getActiveLogs(TInfo tinfo, TCredentials credentials) {
        String log = this.server.logger.getLogFile();
        if (log == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(log);
    }

    public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) {
        log.warn("Garbage collector is attempting to remove logs through the tablet server");
        log.warn("This is probably because your file Garbage Collector is an older version than your tablet servers.\nRestart your file Garbage Collector.");
    }

    private TSummaries getSummaries(Future<SummaryCollection> future) throws TimeoutException {
        try {
            SummaryCollection sc = future.get(this.MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS, TimeUnit.MILLISECONDS);
            return sc.toThrift();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private TSummaries handleTimeout(long sessionId) {
        long timeout = this.server.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
        this.server.sessionManager.removeIfNotAccessed(sessionId, timeout);
        return new TSummaries(false, sessionId, -1L, -1L, null);
    }

    private TSummaries startSummaryOperation(TCredentials credentials, Future<SummaryCollection> future) {
        try {
            return this.getSummaries(future);
        }
        catch (TimeoutException e) {
            long sid = this.server.sessionManager.createSession(new SummarySession(credentials, future), false);
            while (sid == 0L) {
                this.server.sessionManager.removeSession(sid);
                sid = this.server.sessionManager.createSession(new SummarySession(credentials, future), false);
            }
            return this.handleTimeout(sid);
        }
    }

    public TSummaries startGetSummaries(TInfo tinfo, TCredentials credentials, TSummaryRequest request) throws ThriftSecurityException, ThriftTableOperationException, TException {
        NamespaceId namespaceId;
        TableId tableId = TableId.of((String)request.getTableId());
        try {
            namespaceId = this.server.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e1) {
            throw new ThriftTableOperationException(tableId.canonical(), null, null, TableOperationExceptionType.NOTFOUND, null);
        }
        if (!this.security.canGetSummaries(credentials, tableId, namespaceId)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExecutorService es = this.server.resourceManager.getSummaryPartitionExecutor();
        TableConfiguration tableConf = this.context.getTableConfiguration(tableId);
        Future future = new Gatherer((ClientContext)this.server.getContext(), request, (AccumuloConfiguration)tableConf, tableConf.getCryptoService()).gather(es);
        return this.startSummaryOperation(credentials, future);
    }

    public TSummaries startGetSummariesForPartition(TInfo tinfo, TCredentials credentials, TSummaryRequest request, int modulus, int remainder) throws ThriftSecurityException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExecutorService spe = this.server.resourceManager.getSummaryRemoteExecutor();
        TableConfiguration tableConfig = this.context.getTableConfiguration(TableId.of((String)request.getTableId()));
        Future future = new Gatherer((ClientContext)this.server.getContext(), request, (AccumuloConfiguration)tableConfig, tableConfig.getCryptoService()).processPartition(spe, modulus, remainder);
        return this.startSummaryOperation(credentials, future);
    }

    public TSummaries startGetSummariesFromFiles(TInfo tinfo, TCredentials credentials, TSummaryRequest request, Map<String, List<TRowRange>> files) throws ThriftSecurityException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        ExecutorService srp = this.server.resourceManager.getSummaryRetrievalExecutor();
        TableConfiguration tableCfg = this.context.getTableConfiguration(TableId.of((String)request.getTableId()));
        BlockCache summaryCache = this.server.resourceManager.getSummaryCache();
        BlockCache indexCache = this.server.resourceManager.getIndexCache();
        Cache<String, Long> fileLenCache = this.server.resourceManager.getFileLenCache();
        VolumeManager fs = this.context.getVolumeManager();
        Gatherer.FileSystemResolver volMgr = arg_0 -> ((VolumeManager)fs).getFileSystemByPath(arg_0);
        Future future = new Gatherer((ClientContext)this.server.getContext(), request, (AccumuloConfiguration)tableCfg, tableCfg.getCryptoService()).processFiles(volMgr, files, summaryCache, indexCache, fileLenCache, srp);
        return this.startSummaryOperation(credentials, future);
    }

    public TSummaries contiuneGetSummaries(TInfo tinfo, long sessionId) throws NoSuchScanIDException, TException {
        SummarySession session = (SummarySession)this.server.sessionManager.getSession(sessionId);
        if (session == null) {
            throw new NoSuchScanIDException();
        }
        Future<SummaryCollection> future = session.getFuture();
        try {
            TSummaries tsums = this.getSummaries(future);
            this.server.sessionManager.removeSession(sessionId);
            return tsums;
        }
        catch (TimeoutException e) {
            return this.handleTimeout(sessionId);
        }
    }
}

