/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.beust.jcommander.Parameter;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.metadata.ScanServerRefTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.ScanServerBusyException;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.tserver.AssignmentHandler;
import org.apache.accumulo.tserver.BlockCacheMetrics;
import org.apache.accumulo.tserver.ScanServerMetrics;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.ThriftScanClientHandler;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.SessionManager;
import org.apache.accumulo.tserver.session.SingleScanSession;
import org.apache.accumulo.tserver.tablet.SnapshotTablet;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanServer
extends AbstractServer
implements TabletScanClientService.Iface,
TabletHostingServer {
    private static final Logger log = LoggerFactory.getLogger(ScanServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(ScanServer.class);
    protected ThriftScanClientHandler delegate;
    private UUID serverLockUUID;
    private final TabletMetadataLoader tabletMetadataLoader;
    private final LoadingCache<KeyExtent, TabletMetadata> tabletMetadataCache;
    private final ThreadPoolExecutor tmCacheExecutor;
    private final Set<StoredTabletFile> influxFiles = new HashSet<StoredTabletFile>();
    private final ReentrantReadWriteLock.ReadLock reservationsReadLock;
    private final ReentrantReadWriteLock.WriteLock reservationsWriteLock;
    private final Condition reservationCondition;
    private final Map<StoredTabletFile, ReservedFile> reservedFiles = new ConcurrentHashMap<StoredTabletFile, ReservedFile>();
    private final AtomicLong nextScanReservationId = new AtomicLong();
    private final ServerContext context;
    private final SessionManager sessionManager;
    private final TabletServerResourceManager resourceManager;
    HostAndPort clientAddress;
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    protected volatile boolean serverStopRequested = false;
    private ServiceLock scanServerLock;
    protected TabletServerScanMetrics scanMetrics;
    private ScanServerMetrics scanServerMetrics;
    private BlockCacheMetrics blockCacheMetrics;
    private ZooCache managerLockCache;
    private final String groupName;

    public ScanServer(ScanServerOpts opts, String[] args) {
        super("sserver", (ServerOpts)opts, args);
        this.context = super.getContext();
        log.info("Version 2.1.3");
        log.info("Instance " + this.getContext().getInstanceID());
        this.sessionManager = new SessionManager(this.context);
        this.resourceManager = new TabletServerResourceManager(this.context, this);
        this.managerLockCache = new ZooCache(this.context.getZooReader(), null);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.reservationsReadLock = readWriteLock.readLock();
        this.reservationsWriteLock = readWriteLock.writeLock();
        this.reservationCondition = readWriteLock.writeLock().newCondition();
        long cacheExpiration = this.getConfiguration().getTimeInMillis(Property.SSERV_CACHED_TABLET_METADATA_EXPIRATION);
        long scanServerReservationExpiration = this.getConfiguration().getTimeInMillis(Property.SSERV_SCAN_REFERENCE_EXPIRATION_TIME);
        this.tabletMetadataLoader = new TabletMetadataLoader(this.getContext().getAmple());
        if (cacheExpiration == 0L) {
            LOG.warn("Tablet metadata caching disabled, may cause excessive scans on metadata table.");
            this.tabletMetadataCache = null;
            this.tmCacheExecutor = null;
        } else {
            double cacheRefreshPercentage;
            if (cacheExpiration < 60000L) {
                LOG.warn("Tablet metadata caching less than one minute, may cause excessive scans on metadata table.");
            }
            Preconditions.checkArgument(((cacheRefreshPercentage = this.getConfiguration().getFraction(Property.SSERV_CACHED_TABLET_METADATA_REFRESH_PERCENT)) < (double)cacheExpiration ? 1 : 0) != 0, (String)"Tablet metadata cache refresh percentage is '%s' but must be less than 1", (Object)cacheRefreshPercentage);
            this.tmCacheExecutor = this.context.threadPools().getPoolBuilder(ThreadPoolNames.SCAN_SERVER_TABLET_METADATA_CACHE_POOL).numCoreThreads(8).enableThreadPoolMetrics().build();
            Caffeine builder = Caffeine.newBuilder().expireAfterWrite(cacheExpiration, TimeUnit.MILLISECONDS).scheduler(Scheduler.systemScheduler()).executor((Executor)this.tmCacheExecutor).recordStats();
            if (cacheRefreshPercentage > 0.0) {
                long cacheRefresh = (long)((double)cacheExpiration * cacheRefreshPercentage);
                LOG.debug("Tablet metadata refresh percentage set to {}, refresh time set to {} ms", (Object)cacheRefreshPercentage, (Object)cacheRefresh);
                builder.refreshAfterWrite(cacheRefresh, TimeUnit.MILLISECONDS);
            } else {
                LOG.warn("Tablet metadata cache refresh disabled, may cause blocking on cache expiration.");
            }
            this.tabletMetadataCache = builder.build((CacheLoader)this.tabletMetadataLoader);
        }
        this.delegate = this.newThriftScanClientHandler(new WriteTracker());
        this.groupName = Objects.requireNonNull(opts.getGroupName());
        ThreadPools.watchCriticalScheduledTask(this.getContext().getScheduledExecutor().scheduleWithFixedDelay(() -> this.cleanUpReservedFiles(scanServerReservationExpiration), scanServerReservationExpiration, scanServerReservationExpiration, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    protected ThriftScanClientHandler newThriftScanClientHandler(WriteTracker writeTracker) {
        return new ThriftScanClientHandler(this, writeTracker);
    }

    protected ServerAddress startScanServerClientService() throws UnknownHostException {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getScanServerTProcessor((TabletScanClientService.Iface)this, (ServerContext)this.getContext());
        Property maxMessageSizeProperty = this.getConfiguration().resolve(Property.RPC_MAX_MESSAGE_SIZE, new Property[]{Property.GENERAL_MAX_MESSAGE_SIZE});
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)this.getHostname(), (Property)Property.SSERV_CLIENTPORT, (TProcessor)processor, (String)this.getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.SSERV_PORTSEARCH, (Property)Property.SSERV_MINTHREADS, (Property)Property.SSERV_MINTHREADS_TIMEOUT, (Property)Property.SSERV_THREADCHECK, (Property)maxMessageSizeProperty);
        LOG.info("address = {}", (Object)sp.address);
        return sp;
    }

    public String getClientAddressString() {
        if (this.clientAddress == null) {
            return null;
        }
        return this.clientAddress.getHost() + ":" + this.clientAddress.getPort();
    }

    private ServiceLock announceExistence() {
        ZooReaderWriter zoo = this.getContext().getZooReaderWriter();
        try {
            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(this.getContext().getZooKeeperRoot() + "/sservers/" + this.getClientAddressString()));
            try {
                zoo.putPersistentData(zLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NOAUTH) {
                    LOG.error("Failed to write to ZooKeeper. Ensure that accumulo.properties, specifically instance.secret, is consistent.");
                }
                throw e;
            }
            this.serverLockUUID = UUID.randomUUID();
            this.scanServerLock = new ServiceLock(zoo.getZooKeeper(), zLockPath, this.serverLockUUID);
            ServiceLock.LockWatcher lw = new ServiceLock.LockWatcher(){

                public void lostLock(ServiceLock.LockLossReason reason) {
                    Halt.halt((int)(ScanServer.this.serverStopRequested ? 0 : 1), () -> {
                        if (!ScanServer.this.serverStopRequested) {
                            LOG.error("Lost tablet server lock (reason = {}), exiting.", (Object)reason);
                        }
                        ScanServer.this.gcLogger.logGCInfo(ScanServer.this.getConfiguration());
                    });
                }

                public void unableToMonitorLockNode(Exception e) {
                    Halt.halt((int)1, () -> LOG.error("Lost ability to monitor scan server lock, exiting.", (Throwable)e));
                }
            };
            byte[] lockContent = (this.serverLockUUID.toString() + "," + this.groupName).getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < 24; ++i) {
                zoo.putPersistentData(zLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.scanServerLock.tryLock(lw, lockContent)) {
                    LOG.debug("Obtained scan server lock {}", (Object)this.scanServerLock.getLockPath());
                    return this.scanServerLock;
                }
                LOG.info("Waiting for scan server lock");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            LOG.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            LOG.info("Could not obtain scan server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)this.getConfiguration());
        ServerAddress address = null;
        try {
            address = this.startScanServerClientService();
            this.clientAddress = address.getAddress();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the compactor client service", e1);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.addServiceTags(this.getApplicationName(), this.clientAddress);
        metricsInfo.addCommonTags(List.of(Tag.of((String)"resource.group", (String)this.groupName)));
        this.scanMetrics = new TabletServerScanMetrics();
        this.scanServerMetrics = new ScanServerMetrics(this.tabletMetadataCache);
        this.blockCacheMetrics = new BlockCacheMetrics(this.resourceManager.getIndexCache(), this.resourceManager.getDataCache(), this.resourceManager.getSummaryCache());
        metricsInfo.addMetricsProducers(new MetricsProducer[]{this, this.scanMetrics, this.scanServerMetrics, this.blockCacheMetrics});
        metricsInfo.init();
        ServiceLock lock = this.announceExistence();
        try {
            while (!this.serverStopRequested) {
                UtilWaitThread.sleep((long)1000L);
                this.updateIdleStatus(this.sessionManager.getActiveScans().isEmpty() && this.tabletMetadataCache.estimatedSize() == 0L);
            }
        }
        finally {
            LOG.info("Stopping Thrift Servers");
            address.server.stop();
            try {
                LOG.info("Removing server scan references");
                this.getContext().getAmple().deleteScanServerFileReferences(this.clientAddress.toString(), this.serverLockUUID);
            }
            catch (Exception e) {
                LOG.warn("Failed to remove scan server refs from metadata location", (Throwable)e);
            }
            try {
                LOG.debug("Closing filesystems");
                VolumeManager mgr = this.getContext().getVolumeManager();
                if (null != mgr) {
                    mgr.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close filesystem : {}", (Object)e.getMessage(), (Object)e);
            }
            if (this.tmCacheExecutor != null) {
                LOG.debug("Shutting down TabletMetadataCache executor");
                this.tmCacheExecutor.shutdownNow();
            }
            this.gcLogger.logGCInfo(this.getConfiguration());
            LOG.info("stop requested. exiting ... ");
            try {
                if (null != lock) {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to release scan server lock", (Throwable)e);
            }
        }
    }

    private Map<KeyExtent, TabletMetadata> getTabletMetadata(Collection<KeyExtent> extents) {
        if (this.tabletMetadataCache == null) {
            return this.tabletMetadataLoader.loadAll((Set)extents);
        }
        return this.tabletMetadataCache.getAll(extents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KeyExtent, TabletMetadata> reserveFilesInner(Collection<KeyExtent> extents, long myReservationId, Set<KeyExtent> failures) throws AccumuloException {
        LOG.debug("RFFS {} ensuring files are referenced for scan of extents {}", (Object)myReservationId, extents);
        Map<KeyExtent, TabletMetadata> tabletsMetadata = this.getTabletMetadata(extents);
        if (!(tabletsMetadata instanceof HashMap)) {
            tabletsMetadata = new HashMap<KeyExtent, TabletMetadata>(tabletsMetadata);
        }
        for (KeyExtent keyExtent : extents) {
            TabletMetadata tabletMetadata = tabletsMetadata.get(keyExtent);
            if (tabletMetadata == null) {
                LOG.info("RFFS {} extent not found in metadata table {}", (Object)myReservationId, (Object)keyExtent);
                failures.add(keyExtent);
            }
            if (AssignmentHandler.checkTabletMetadata(keyExtent, null, tabletMetadata, true)) continue;
            LOG.info("RFFS {} extent unable to load {} as AssignmentHandler returned false", (Object)myReservationId, (Object)keyExtent);
            failures.add(keyExtent);
            tabletsMetadata.remove(keyExtent);
        }
        HashMap allFiles = new HashMap();
        tabletsMetadata.forEach((extent, tm) -> tm.getFiles().forEach(file -> allFiles.put(file, extent)));
        this.reservationsReadLock.lock();
        try {
            if (this.reservedFiles.keySet().containsAll(allFiles.keySet())) {
                for (StoredTabletFile file2 : allFiles.keySet()) {
                    if (this.reservedFiles.get((Object)file2).activeReservations.add(myReservationId)) continue;
                    throw new IllegalStateException("reservation id unexpectedly already in set");
                }
                Map<KeyExtent, TabletMetadata> map = tabletsMetadata;
                return map;
            }
        }
        finally {
            this.reservationsReadLock.unlock();
        }
        this.reservationsWriteLock.lock();
        try {
            while (!Collections.disjoint(this.influxFiles, allFiles.keySet())) {
                this.reservationCondition.await();
            }
            this.influxFiles.addAll(allFiles.keySet());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.reservationsWriteLock.unlock();
        }
        try {
            HashSet<Object> hashSet = new HashSet<Object>();
            ArrayList<ScanServerRefTabletFile> refs = new ArrayList<ScanServerRefTabletFile>();
            HashSet<KeyExtent> tabletsToCheck = new HashSet<KeyExtent>();
            String serverAddress = this.clientAddress.toString();
            for (Object file3 : allFiles.keySet()) {
                if (this.reservedFiles.containsKey(file3)) continue;
                refs.add(new ScanServerRefTabletFile(this.serverLockUUID, serverAddress, file3.getPathStr()));
                hashSet.add(file3);
                tabletsToCheck.add(Objects.requireNonNull((KeyExtent)allFiles.get(file3)));
                LOG.trace("RFFS {} need to add scan ref for file {}", (Object)myReservationId, file3);
            }
            if (!hashSet.isEmpty()) {
                this.scanServerMetrics.recordWriteOutReservationTime(() -> this.getContext().getAmple().putScanServerFileReferences((Collection)refs));
                if (this.tabletMetadataCache != null) {
                    this.tabletMetadataCache.invalidateAll(tabletsToCheck);
                }
                Map<KeyExtent, TabletMetadata> tabletsToCheckMetadata = this.getTabletMetadata(tabletsToCheck);
                for (KeyExtent extent3 : tabletsToCheck) {
                    TabletMetadata metadataAfter = tabletsToCheckMetadata.get(extent3);
                    if (metadataAfter == null) {
                        LOG.info("RFFS {} extent unable to load {} as metadata no longer referencing files", (Object)myReservationId, (Object)extent3);
                        failures.add(extent3);
                        tabletsMetadata.remove(extent3);
                        continue;
                    }
                    hashSet.removeAll(metadataAfter.getFiles());
                }
                if (!hashSet.isEmpty()) {
                    Object file3;
                    LOG.info("RFFS {} tablet files changed while attempting to reference files {}", (Object)myReservationId, hashSet);
                    this.getContext().getAmple().deleteScanServerFileReferences(refs);
                    this.scanServerMetrics.incrementReservationConflictCount();
                    file3 = null;
                    return file3;
                }
            }
            for (StoredTabletFile file2 : allFiles.keySet()) {
                if (!this.reservedFiles.computeIfAbsent((StoredTabletFile)file2, (Function<StoredTabletFile, ReservedFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reserveFilesInner$4(org.apache.accumulo.core.metadata.StoredTabletFile ), (Lorg/apache/accumulo/core/metadata/StoredTabletFile;)Lorg/apache/accumulo/tserver/ScanServer$ReservedFile;)()).activeReservations.add(myReservationId)) {
                    throw new IllegalStateException("reservation id unexpectedly already in set");
                }
                LOG.trace("RFFS {} reserved reference for startScan {}", (Object)myReservationId, (Object)file2);
            }
            Map<KeyExtent, TabletMetadata> map = tabletsMetadata;
            return map;
        }
        finally {
            this.reservationsWriteLock.lock();
            try {
                allFiles.keySet().forEach(file -> Preconditions.checkState((boolean)this.influxFiles.remove(file)));
                this.reservationCondition.signal();
            }
            finally {
                this.reservationsWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ScanReservation reserveFilesInstrumented(Map<KeyExtent, List<TRange>> extents) throws AccumuloException {
        long start = System.nanoTime();
        try {
            ScanReservation scanReservation = this.reserveFiles(extents);
            return scanReservation;
        }
        finally {
            this.scanServerMetrics.recordTotalReservationTime(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    protected ScanReservation reserveFiles(Map<KeyExtent, List<TRange>> extents) throws AccumuloException {
        long myReservationId = this.nextScanReservationId.incrementAndGet();
        HashSet<KeyExtent> failedReservations = new HashSet<KeyExtent>();
        Map<KeyExtent, TabletMetadata> tabletsMetadata = this.reserveFilesInner(extents.keySet(), myReservationId, failedReservations);
        while (tabletsMetadata == null) {
            failedReservations.clear();
            tabletsMetadata = this.reserveFilesInner(extents.keySet(), myReservationId, failedReservations);
        }
        if (!Collections.disjoint(tabletsMetadata.keySet(), failedReservations) || !extents.keySet().equals(Sets.union(tabletsMetadata.keySet(), failedReservations))) {
            throw new IllegalStateException("bug in reserverFilesInner " + extents.keySet() + "," + tabletsMetadata.keySet() + "," + failedReservations);
        }
        HashMap<TKeyExtent, List<TRange>> failures = new HashMap<TKeyExtent, List<TRange>>();
        failedReservations.forEach(extent -> failures.put(extent.toThrift(), (List)extents.get(extent)));
        return new ScanReservation(tabletsMetadata, myReservationId, failures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ScanReservation reserveFilesInstrumented(long scanId) throws NoSuchScanIDException {
        long start = System.nanoTime();
        try {
            ScanReservation scanReservation = this.reserveFiles(scanId);
            return scanReservation;
        }
        finally {
            this.scanServerMetrics.recordTotalReservationTime(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScanReservation reserveFiles(long scanId) throws NoSuchScanIDException {
        ScanSession session = (ScanSession)this.sessionManager.getSession(scanId);
        if (session == null) {
            throw new NoSuchScanIDException();
        }
        Set<StoredTabletFile> scanSessionFiles = ScanServer.getScanSessionFiles(session);
        long myReservationId = this.nextScanReservationId.incrementAndGet();
        this.reservationsReadLock.lock();
        try {
            if (!this.reservedFiles.keySet().containsAll(scanSessionFiles)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("RFFS {} files are no longer referenced on continue scan {} {}", new Object[]{myReservationId, scanId, Sets.difference(scanSessionFiles, this.reservedFiles.keySet())});
                }
                throw new NoSuchScanIDException();
            }
            for (StoredTabletFile file : scanSessionFiles) {
                if (!this.reservedFiles.get((Object)file).activeReservations.add(myReservationId)) {
                    throw new IllegalStateException("reservation id unexpectedly already in set");
                }
                LOG.trace("RFFS {} reserved reference for continue scan {} {}", new Object[]{myReservationId, scanId, file});
            }
        }
        finally {
            this.reservationsReadLock.unlock();
        }
        return new ScanReservation(scanSessionFiles, myReservationId);
    }

    private static Set<StoredTabletFile> getScanSessionFiles(ScanSession session) {
        if (session instanceof SingleScanSession) {
            SingleScanSession sss = (SingleScanSession)session;
            return Set.copyOf(session.getTabletResolver().getTablet(sss.extent).getDatafiles().keySet());
        }
        if (session instanceof MultiScanSession) {
            MultiScanSession mss = (MultiScanSession)session;
            return mss.exents.stream().flatMap(e -> {
                TabletBase tablet = mss.getTabletResolver().getTablet((KeyExtent)e);
                if (tablet == null) {
                    return Stream.empty();
                }
                return tablet.getDatafiles().keySet().stream();
            }).collect(Collectors.toUnmodifiableSet());
        }
        throw new IllegalArgumentException("Unknown session type " + session.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpReservedFiles(long expireTimeMs) {
        if (this.reservedFiles.values().stream().anyMatch(rf -> rf.shouldDelete(expireTimeMs))) {
            ArrayList<ScanServerRefTabletFile> refsToDelete = new ArrayList<ScanServerRefTabletFile>();
            ArrayList<StoredTabletFile> confirmed = new ArrayList<StoredTabletFile>();
            String serverAddress = this.clientAddress.toString();
            this.reservationsWriteLock.lock();
            try {
                Iterator<Map.Entry<StoredTabletFile, ReservedFile>> reservedIter = this.reservedFiles.entrySet().iterator();
                while (reservedIter.hasNext()) {
                    Map.Entry<StoredTabletFile, ReservedFile> entry = reservedIter.next();
                    StoredTabletFile file2 = entry.getKey();
                    if (!entry.getValue().shouldDelete(expireTimeMs) || this.influxFiles.contains(file2)) continue;
                    this.influxFiles.add(file2);
                    confirmed.add(file2);
                    refsToDelete.add(new ScanServerRefTabletFile(this.serverLockUUID, serverAddress, file2.getPathStr()));
                    reservedIter.remove();
                }
            }
            finally {
                this.reservationsWriteLock.unlock();
            }
            if (!confirmed.isEmpty()) {
                try {
                    this.getContext().getAmple().deleteScanServerFileReferences(refsToDelete);
                    if (LOG.isTraceEnabled()) {
                        confirmed.forEach(refToDelete -> LOG.trace("RFFS referenced files has not been used recently, removing reference {}", refToDelete));
                    }
                }
                finally {
                    this.reservationsWriteLock.lock();
                    try {
                        confirmed.forEach(file -> Preconditions.checkState((boolean)this.influxFiles.remove(file)));
                        this.reservationCondition.signal();
                    }
                    finally {
                        this.reservationsWriteLock.unlock();
                    }
                }
            }
        }
        ArrayList candidates = new ArrayList();
        this.reservedFiles.forEach((file, reservationInfo) -> {
            if (reservationInfo.shouldDelete(expireTimeMs)) {
                candidates.add(file);
            }
        });
    }

    protected KeyExtent getKeyExtent(TKeyExtent textent) {
        return KeyExtent.fromThrift((TKeyExtent)textent);
    }

    protected ScanSession.TabletResolver getScanTabletResolver(final TabletBase tablet) {
        return new ScanSession.TabletResolver(){
            final TabletBase t;
            {
                this.t = tablet;
            }

            @Override
            public TabletBase getTablet(KeyExtent extent) {
                if (extent.equals((Object)this.t.getExtent())) {
                    return this.t;
                }
                LOG.warn("TabletResolver passed the wrong tablet. Known extent: {}, requested extent: {}", (Object)this.t.getExtent(), (Object)extent);
                return null;
            }

            @Override
            public void close() {
                try {
                    this.t.close(false);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error closing tablet", e);
                }
            }
        };
    }

    protected ScanSession.TabletResolver getBatchScanTabletResolver(final HashMap<KeyExtent, TabletBase> tablets) {
        return new ScanSession.TabletResolver(){

            @Override
            public TabletBase getTablet(KeyExtent extent) {
                return (TabletBase)tablets.get(extent);
            }

            @Override
            public void close() {
                tablets.forEach((e, t) -> {
                    try {
                        t.close(false);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException("Error closing tablet: " + e.toString(), ex);
                    }
                });
            }
        };
    }

    protected boolean isSystemUser(TCredentials creds) {
        return this.context.getSecurityOperation().isSystemUser(creds);
    }

    public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent textent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, Map<String, String> executionHints, long busyTimeout) throws ThriftSecurityException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, TException {
        KeyExtent extent = this.getKeyExtent(textent);
        if (extent.isMeta() && !this.isSystemUser(credentials)) {
            throw new TException("Only the system user can perform eventual consistency scans on the root and metadata tables");
        }
        ScanReservation reservation = this.reserveFilesInstrumented(Map.of(extent, Collections.singletonList(range)));
        try {
            InitialScan is;
            if (reservation.getFailures().containsKey(textent)) {
                throw new NotServingTabletException(extent.toThrift());
            }
            SnapshotTablet tablet = reservation.newTablet(this, extent);
            InitialScan initialScan = is = this.delegate.startScan(tinfo, credentials, extent, range, columns, batchSize, ssiList, ssio, authorizations, waitForWrites, isolated, readaheadThreshold, samplerConfig, batchTimeOut, classLoaderContext, executionHints, this.getScanTabletResolver(tablet), busyTimeout);
            if (reservation != null) {
                reservation.close();
            }
            return initialScan;
        }
        catch (Throwable throwable) {
            try {
                if (reservation != null) {
                    try {
                        reservation.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ScanServerBusyException be) {
                this.scanServerMetrics.incrementBusy();
                throw be;
            }
            catch (IOException | AccumuloException e) {
                LOG.error("Error starting scan", e);
                throw new RuntimeException(e);
            }
        }
    }

    public ScanResult continueScan(TInfo tinfo, long scanID, long busyTimeout) throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, TException {
        LOG.trace("continue scan: {}", (Object)scanID);
        ScanReservation reservation = this.reserveFilesInstrumented(scanID);
        try {
            Preconditions.checkState((boolean)reservation.getFailures().isEmpty());
            ScanResult scanResult = this.delegate.continueScan(tinfo, scanID, busyTimeout);
            if (reservation != null) {
                reservation.close();
            }
            return scanResult;
        }
        catch (Throwable throwable) {
            try {
                if (reservation != null) {
                    try {
                        reservation.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ScanServerBusyException be) {
                this.scanServerMetrics.incrementBusy();
                throw be;
            }
        }
    }

    public void closeScan(TInfo tinfo, long scanID) throws TException {
        LOG.trace("close scan: {}", (Object)scanID);
        this.delegate.closeScan(tinfo, scanID);
    }

    public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String contextArg, Map<String, String> executionHints, long busyTimeout) throws ThriftSecurityException, TSampleNotPresentException, TException {
        if (tbatch.size() == 0) {
            throw new TException("Scan Server batch must include at least one extent");
        }
        HashMap<KeyExtent, List<TRange>> batch = new HashMap<KeyExtent, List<TRange>>();
        for (Map.Entry<TKeyExtent, List<TRange>> entry : tbatch.entrySet()) {
            KeyExtent extent2 = this.getKeyExtent(entry.getKey());
            if (extent2.isMeta() && !this.context.getSecurityOperation().isSystemUser(credentials)) {
                throw new TException("Only the system user can perform eventual consistency scans on the root and metadata tables");
            }
            batch.put(extent2, entry.getValue());
        }
        ScanReservation reservation = this.reserveFilesInstrumented(batch);
        try {
            HashMap<KeyExtent, TabletBase> tablets = new HashMap<KeyExtent, TabletBase>();
            reservation.getTabletMetadataExtents().forEach(extent -> {
                try {
                    tablets.put((KeyExtent)extent, reservation.newTablet(this, (KeyExtent)extent));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            InitialMultiScan ims = this.delegate.startMultiScan(tinfo, credentials, tcolumns, ssiList, batch, ssio, authorizations, waitForWrites, tSamplerConfig, batchTimeOut, contextArg, executionHints, this.getBatchScanTabletResolver(tablets), busyTimeout);
            LOG.trace("started scan: {}", (Object)ims.getScanID());
            InitialMultiScan initialMultiScan = ims;
            if (reservation != null) {
                reservation.close();
            }
            return initialMultiScan;
        }
        catch (Throwable throwable) {
            try {
                if (reservation != null) {
                    try {
                        reservation.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ScanServerBusyException be) {
                this.scanServerMetrics.incrementBusy();
                throw be;
            }
            catch (TException e) {
                LOG.error("Error starting scan", (Throwable)e);
                throw e;
            }
            catch (AccumuloException e) {
                LOG.error("Error starting scan", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public MultiScanResult continueMultiScan(TInfo tinfo, long scanID, long busyTimeout) throws NoSuchScanIDException, TSampleNotPresentException, TException {
        LOG.trace("continue multi scan: {}", (Object)scanID);
        ScanReservation reservation = this.reserveFilesInstrumented(scanID);
        try {
            Preconditions.checkState((boolean)reservation.getFailures().isEmpty());
            MultiScanResult multiScanResult = this.delegate.continueMultiScan(tinfo, scanID, busyTimeout);
            if (reservation != null) {
                reservation.close();
            }
            return multiScanResult;
        }
        catch (Throwable throwable) {
            try {
                if (reservation != null) {
                    try {
                        reservation.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ScanServerBusyException be) {
                this.scanServerMetrics.incrementBusy();
                throw be;
            }
        }
    }

    public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, TException {
        LOG.trace("close multi scan: {}", (Object)scanID);
        this.delegate.closeMultiScan(tinfo, scanID);
    }

    public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
        return this.delegate.getActiveScans(tinfo, credentials);
    }

    @Override
    public Tablet getOnlineTablet(KeyExtent extent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public TabletServerResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public TabletServerScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }

    @Override
    public Session getSession(long scanID) {
        return this.sessionManager.getSession(scanID);
    }

    @Override
    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.getContext().getTableConfiguration(extent.tableId());
    }

    @Override
    public ServiceLock getLock() {
        return this.scanServerLock;
    }

    @Override
    public ZooCache getManagerLockCache() {
        return this.managerLockCache;
    }

    @Override
    public GarbageCollectionLogger getGcLogger() {
        return this.gcLogger;
    }

    public BlockCacheConfiguration getBlockCacheConfiguration(AccumuloConfiguration acuConf) {
        return BlockCacheConfiguration.forScanServer((AccumuloConfiguration)acuConf);
    }

    public static void main(String[] args) throws Exception {
        try (ScanServer tserver = new ScanServer(new ScanServerOpts(), args);){
            tserver.runServer();
        }
    }

    private static /* synthetic */ ReservedFile lambda$reserveFilesInner$4(StoredTabletFile k) {
        return new ReservedFile();
    }

    private static class TabletMetadataLoader
    implements CacheLoader<KeyExtent, TabletMetadata> {
        private final Ample ample;

        private TabletMetadataLoader(Ample ample) {
            this.ample = ample;
        }

        public @Nullable TabletMetadata load(KeyExtent keyExtent) {
            long t1 = System.currentTimeMillis();
            TabletMetadata tm = this.ample.readTablet(keyExtent, new TabletMetadata.ColumnType[0]);
            long t2 = System.currentTimeMillis();
            LOG.trace("Read metadata for 1 tablet in {} ms", (Object)(t2 - t1));
            return tm;
        }

        public Map<? extends KeyExtent, ? extends TabletMetadata> loadAll(Set<? extends KeyExtent> keys) {
            long t1 = System.currentTimeMillis();
            Map<KeyExtent, TabletMetadata> tms = this.ample.readTablets().forTablets(keys).build().stream().collect(Collectors.toMap(tm -> tm.getExtent(), tm -> tm));
            long t2 = System.currentTimeMillis();
            LOG.trace("Read metadata for {} tablets in {} ms", (Object)keys.size(), (Object)(t2 - t1));
            return tms;
        }
    }

    public static class ScanServerOpts
    extends ServerOpts {
        @Parameter(required=false, names={"-g", "--group"}, description="Optional group name that will be made available to the ScanServerSelector client plugin.  If not specified will be set to 'default'.  Groups support at least two use cases : dedicating resources to scans and/or using different hardware for scans.")
        private String groupName = "default";

        public String getGroupName() {
            return this.groupName;
        }
    }

    static class ReservedFile {
        final Set<Long> activeReservations = new ConcurrentSkipListSet<Long>();
        final AtomicLong lastUseTime = new AtomicLong(0L);

        ReservedFile() {
        }

        boolean shouldDelete(long expireTimeMs) {
            return this.activeReservations.isEmpty() && System.currentTimeMillis() - this.lastUseTime.get() > expireTimeMs;
        }
    }

    class ScanReservation
    implements AutoCloseable {
        private final Collection<StoredTabletFile> files;
        private final long myReservationId;
        private final Map<KeyExtent, TabletMetadata> tabletsMetadata;
        private final Map<TKeyExtent, List<TRange>> failures;

        ScanReservation(Map<KeyExtent, TabletMetadata> tabletsMetadata, long myReservationId, Map<TKeyExtent, List<TRange>> failures) {
            this.tabletsMetadata = tabletsMetadata;
            this.failures = failures;
            this.files = tabletsMetadata.values().stream().flatMap(tm -> tm.getFiles().stream()).collect(Collectors.toUnmodifiableSet());
            this.myReservationId = myReservationId;
        }

        ScanReservation(Collection<StoredTabletFile> files, long myReservationId) {
            this.tabletsMetadata = null;
            this.failures = Map.of();
            this.files = files;
            this.myReservationId = myReservationId;
        }

        public TabletMetadata getTabletMetadata(KeyExtent extent) {
            return this.tabletsMetadata.get(extent);
        }

        public Set<KeyExtent> getTabletMetadataExtents() {
            return this.tabletsMetadata.keySet();
        }

        public Map<TKeyExtent, List<TRange>> getFailures() {
            return this.failures;
        }

        SnapshotTablet newTablet(ScanServer server, KeyExtent extent) throws IOException {
            TabletMetadata tabletMetadata = this.getTabletMetadata(extent);
            TabletServerResourceManager.TabletResourceManager trm = ScanServer.this.resourceManager.createTabletResourceManager(tabletMetadata.getExtent(), (AccumuloConfiguration)ScanServer.this.context.getTableConfiguration(tabletMetadata.getExtent().tableId()));
            return new SnapshotTablet(server, tabletMetadata, trm);
        }

        @Override
        public void close() {
            for (StoredTabletFile file : this.files) {
                ReservedFile reservedFile = ScanServer.this.reservedFiles.get(file);
                if (!reservedFile.activeReservations.remove(this.myReservationId)) {
                    throw new IllegalStateException("reservation id was not in set as expected");
                }
                LOG.trace("RFFS {} unreserved reference for file {}", (Object)this.myReservationId, (Object)file);
                reservedFile.lastUseTime.set(System.currentTimeMillis());
            }
        }
    }
}

