/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.spi.metrics.MeterRegistryFactory;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.metrics.MeterRegistryEnvPropImpl;
import org.apache.hadoop.util.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsInfoImpl
implements MetricsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsInfoImpl.class);
    private final ServerContext context;
    private final Lock lock = new ReentrantLock();
    private final Map<String, Tag> commonTags;
    private JvmGcMetrics jvmGcMetrics;
    private final boolean metricsEnabled;
    private CompositeMeterRegistry composite = null;
    private final List<MeterRegistry> pendingRegistries = new ArrayList<MeterRegistry>();
    private final List<MetricsProducer> producers = new ArrayList<MetricsProducer>();

    public MetricsInfoImpl(ServerContext context) {
        this.context = context;
        this.metricsEnabled = context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_ENABLED);
        this.printMetricsConfig();
        this.commonTags = new HashMap<String, Tag>();
        Tag t = MetricsInfo.instanceNameTag((String)context.getInstanceName());
        this.commonTags.put(t.getKey(), t);
    }

    private void printMetricsConfig() {
        boolean jvmMetricsEnabled = this.context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED);
        LOG.info("micrometer metrics enabled: {}", (Object)this.metricsEnabled);
        if (jvmMetricsEnabled) {
            if (this.metricsEnabled) {
                LOG.info("detailed jvm metrics enabled: {}", (Object)jvmMetricsEnabled);
            } else {
                LOG.info("requested jvm metrics, but micrometer metrics are disabled.");
            }
        }
        if (this.metricsEnabled) {
            LOG.info("metrics registry factories: {}", (Object)this.context.getConfiguration().get(Property.GENERAL_MICROMETER_FACTORY));
        }
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void addServiceTags(String applicationName, HostAndPort hostAndPort) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (applicationName != null && !applicationName.isEmpty()) {
            tags.add(MetricsInfo.processTag((String)applicationName));
        }
        if (hostAndPort != null) {
            tags.addAll(MetricsInfo.addressTags((HostAndPort)hostAndPort));
        }
        this.addCommonTags(tags);
    }

    public void addCommonTags(List<Tag> updates) {
        this.lock.lock();
        try {
            if (this.composite != null) {
                LOG.warn("Common tags after registry has been initialized may be ignored. Current common tags: {}", this.commonTags);
                return;
            }
            updates.forEach(t -> this.commonTags.put(t.getKey(), (Tag)t));
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<Tag> getCommonTags() {
        this.lock.lock();
        try {
            Collection<Tag> collection = Collections.unmodifiableCollection(this.commonTags.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRegistry(MeterRegistry registry) {
        this.lock.lock();
        try {
            if (this.composite != null) {
                this.composite.add(registry);
            } else {
                this.pendingRegistries.add(registry);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addMetricsProducers(MetricsProducer ... producer) {
        if (producer.length == 0) {
            LOG.debug("called addMetricsProducers() without providing at least one producer - this has no effect");
            return;
        }
        this.lock.lock();
        try {
            if (this.composite == null) {
                this.producers.addAll(Arrays.asList(producer));
            } else {
                Arrays.stream(producer).forEach(p -> p.registerMetrics((MeterRegistry)this.composite));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public MeterRegistry getRegistry() {
        this.lock.lock();
        try {
            if (this.composite == null) {
                throw new IllegalStateException("metrics have not been initialized, call init() first");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.lock.lock();
        try {
            if (this.composite != null) {
                LOG.warn("metrics registry has already been initialized");
                return;
            }
            this.composite = new CompositeMeterRegistry();
            this.composite.config().commonTags(this.commonTags.values());
            LOG.info("Metrics initialization. common tags: {}", this.commonTags);
            boolean jvmMetricsEnabled = this.context.getConfiguration().getBoolean(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED);
            if (jvmMetricsEnabled) {
                LOG.info("enabling detailed jvm, classloader, jvm gc and process metrics");
                new ClassLoaderMetrics().bindTo((MeterRegistry)this.composite);
                new JvmMemoryMetrics().bindTo((MeterRegistry)this.composite);
                this.jvmGcMetrics = new JvmGcMetrics();
                this.jvmGcMetrics.bindTo((MeterRegistry)this.composite);
                new ProcessorMetrics().bindTo((MeterRegistry)this.composite);
                new JvmThreadMetrics().bindTo((MeterRegistry)this.composite);
            }
            MeterFilter replicationFilter = new MeterFilter(){

                public DistributionStatisticConfig configure(Meter.Id id, @NonNull DistributionStatisticConfig config) {
                    if (id.getName().equals("replicationQueue")) {
                        return DistributionStatisticConfig.builder().percentiles(new double[]{0.5, 0.75, 0.9, 0.95, 0.99}).expiry(Duration.ofMinutes(10L)).build().merge(config);
                    }
                    return config;
                }
            };
            if (this.isMetricsEnabled()) {
                String userRegistryFactories = this.context.getConfiguration().get(Property.GENERAL_MICROMETER_FACTORY);
                for (String factoryName : StringUtils.getTrimmedStrings((String)userRegistryFactories)) {
                    try {
                        MeterRegistry registry2 = MetricsInfoImpl.getRegistryFromFactory(factoryName, this.context);
                        registry2.config().commonTags(this.commonTags.values());
                        registry2.config().meterFilter(replicationFilter);
                        this.addRegistry(registry2);
                    }
                    catch (ReflectiveOperationException ex) {
                        LOG.warn("Could not load registry {}", (Object)factoryName, (Object)ex);
                    }
                }
            }
            this.pendingRegistries.forEach(registry -> this.composite.add(registry));
            LOG.info("Metrics initialization. Register producers: {}", this.producers);
            this.producers.forEach(p -> p.registerMetrics((MeterRegistry)this.composite));
            Metrics.globalRegistry.add((MeterRegistry)this.composite);
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    static MeterRegistry getRegistryFromFactory(String factoryName, ServerContext context) throws ReflectiveOperationException {
        try {
            LOG.info("look for meter spi registry factory {}", (Object)factoryName);
            Class clazz = ClassLoaderUtil.loadClass((String)factoryName, MeterRegistryFactory.class);
            MeterRegistryFactory factory = (MeterRegistryFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MeterRegistryEnvPropImpl initParameters = new MeterRegistryEnvPropImpl(context);
            return factory.create((MeterRegistryFactory.InitParameters)initParameters);
        }
        catch (ClassCastException clazz) {
            try {
                LOG.info("find legacy meter registry factory {}", (Object)factoryName);
                Class clazz2 = ClassLoaderUtil.loadClass((String)factoryName, org.apache.accumulo.core.metrics.MeterRegistryFactory.class);
                org.apache.accumulo.core.metrics.MeterRegistryFactory factory = (org.apache.accumulo.core.metrics.MeterRegistryFactory)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return factory.create();
            }
            catch (ClassCastException classCastException) {
                throw new ClassNotFoundException("Could not find appropriate class implementing a MetricsFactory for: " + factoryName);
            }
        }
    }

    public synchronized void close() {
        LOG.info("Closing metrics registry");
        if (this.jvmGcMetrics != null) {
            this.jvmGcMetrics.close();
            this.jvmGcMetrics = null;
        }
        if (this.composite != null) {
            this.composite.close();
            this.composite = null;
        }
    }

    public String toString() {
        return "MetricsCommonTags{tags=" + this.getCommonTags() + "}";
    }
}

