/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.RootTabletMetadata;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.metadata.RootGcCandidates;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

public class ZooKeeperInitializer {
    private final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final byte[] ZERO_CHAR_ARRAY = new byte[]{48};

    void initializeConfig(InstanceId instanceId, ZooReaderWriter zoo) {
        try {
            zoo.putPersistentData("/accumulo", new byte[0], ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
            String zkInstanceRoot = "/accumulo/" + instanceId;
            zoo.putPersistentData(zkInstanceRoot, this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.SKIP);
            String sysPropPath = SystemPropKey.of(instanceId).getPath();
            VersionedProperties vProps = new VersionedProperties();
            if (zoo.exists(sysPropPath)) {
                return;
            }
            boolean created = zoo.putPrivatePersistentData(sysPropPath, VersionedPropCodec.getDefault().toBytes(vProps), ZooUtil.NodeExistsPolicy.FAIL);
            if (!created) {
                throw new IllegalStateException("Failed to create default system props during initialization at: {}" + sysPropPath);
            }
        }
        catch (IOException | InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to initialize configuration for prop store", ex);
        }
    }

    void initialize(ServerContext context, boolean clearInstanceName, String instanceNamePath, String rootTabletDirName, String rootTabletFileUri) throws KeeperException, InterruptedException {
        ZooReaderWriter zoo = context.getZooReaderWriter();
        InstanceId instanceId = context.getInstanceID();
        zoo.putPersistentData("/accumulo/instances", new byte[0], ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        if (clearInstanceName) {
            zoo.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        zoo.putPersistentData(instanceNamePath, instanceId.canonical().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        String zkInstanceRoot = "/accumulo/" + instanceId;
        zoo.putPersistentData(zkInstanceRoot + "/tables", Constants.ZTABLES_INITIAL_ID, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/namespaces", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(context, Namespace.DEFAULT.id(), Namespace.DEFAULT.name(), ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(context, Namespace.ACCUMULO.id(), Namespace.ACCUMULO.name(), ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(context, RootTable.ID, Namespace.ACCUMULO.id(), RootTable.NAME, TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(context, MetadataTable.ID, Namespace.ACCUMULO.id(), MetadataTable.NAME, TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        String replicationTableName = ReplicationTable.NAME;
        TableManager.prepareNewTableState(context, Initialize.REPL_TABLE_ID, Namespace.ACCUMULO.id(), replicationTableName, TableState.OFFLINE, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tservers", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/problems", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet", ZooKeeperInitializer.getInitialRootTabletJson(rootTabletDirName, rootTabletFileUri), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/gc_candidates", new RootGcCandidates().toJson().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/managers", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/managers/lock", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/managers/goal_state", ManagerGoalState.NORMAL.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc/lock", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/table_locks", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/hdfs_reservations", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/next_file", this.ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/recovery", this.ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor/lock", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        String replicationZBase = "/replication";
        zoo.putPersistentData(zkInstanceRoot + replicationZBase, this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        String replicationZServers = "/replication/tservers";
        zoo.putPersistentData(zkInstanceRoot + replicationZServers, this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/wals", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/coordinators", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/coordinators/lock", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/compactors", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/sservers", this.EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
    }

    public static byte[] getInitialRootTabletJson(String dirName, String file) {
        MetadataSchema.TabletsSection.ServerColumnFamily.validateDirCol((String)dirName);
        Mutation mutation = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)RootTable.EXTENT);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mutation, new Value((CharSequence)dirName));
        mutation.put((CharSequence)"file", (CharSequence)file, new DataFileValue(0L, 0L).encodeAsValue());
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mutation, new Value((CharSequence)new MetadataTime(0L, TimeType.LOGICAL).encode()));
        RootTabletMetadata rootTabletJson = new RootTabletMetadata();
        rootTabletJson.update(mutation);
        return rootTabletJson.toJson().getBytes(StandardCharsets.UTF_8);
    }
}

