/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.metrics.ProcessMetrics;
import org.apache.accumulo.server.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements AutoCloseable,
MetricsProducer,
Runnable {
    private final ServerContext context;
    protected final String applicationName;
    private final String hostname;
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private final ProcessMetrics processMetrics;
    protected final long idleReportingPeriodNanos;
    private volatile long idlePeriodStartNanos = 0L;

    protected AbstractServer(String appName, ServerOpts opts, String[] args) {
        this.applicationName = appName;
        opts.parseArgs(appName, args, new Object[0]);
        this.hostname = Objects.requireNonNull(opts.getAddress());
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
        this.context = new ServerContext(siteConfig);
        this.log.info("Version 2.1.3");
        this.log.info("Instance " + this.context.getInstanceID());
        this.context.init(appName);
        ClassLoaderUtil.initContextFactory((AccumuloConfiguration)this.context.getConfiguration());
        TraceUtil.initializeTracer((AccumuloConfiguration)this.context.getConfiguration());
        if (this.context.getSaslParams() != null) {
            this.context.enforceKerberosLogin();
        }
        this.processMetrics = new ProcessMetrics();
        this.idleReportingPeriodNanos = TimeUnit.MILLISECONDS.toNanos(this.context.getConfiguration().getTimeInMillis(Property.GENERAL_IDLE_PROCESS_INTERVAL));
    }

    protected void updateIdleStatus(boolean isIdle) {
        boolean hasExceededIdlePeriod;
        boolean shouldResetIdlePeriod = !isIdle || this.idleReportingPeriodNanos == 0L;
        boolean isIdlePeriodNotStarted = this.idlePeriodStartNanos == 0L;
        boolean bl = hasExceededIdlePeriod = System.nanoTime() - this.idlePeriodStartNanos > this.idleReportingPeriodNanos;
        if (shouldResetIdlePeriod) {
            this.idlePeriodStartNanos = 0L;
            this.processMetrics.setIdleValue(false);
        } else if (isIdlePeriodNotStarted) {
            this.idlePeriodStartNanos = System.nanoTime();
        } else if (hasExceededIdlePeriod) {
            this.processMetrics.setIdleValue(true);
            this.idlePeriodStartNanos = 0L;
        }
    }

    public void runServer() throws Exception {
        AtomicReference err = new AtomicReference();
        Thread service = new Thread(TraceUtil.wrap((Runnable)this), this.applicationName);
        service.setUncaughtExceptionHandler((thread, exception) -> err.set(exception));
        service.start();
        service.join();
        Throwable thrown = (Throwable)err.get();
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof Exception) {
                throw (Exception)thrown;
            }
            throw new RuntimeException("Weird throwable type thrown", thrown);
        }
    }

    public void registerMetrics(MeterRegistry registry) {
        if (this.processMetrics != null) {
            this.processMetrics.registerMetrics(registry);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public ServerContext getContext() {
        return this.context;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.getContext().getConfiguration();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void close() {
    }
}

