/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.minicluster.impl.ZooKeeperBindException;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
@Category(value={MiniClusterOnlyTests.class})
public class CyclicReplicationIT {
    private static final Logger log = LoggerFactory.getLogger(CyclicReplicationIT.class);
    @Rule
    public TestName testName = new TestName();

    @Rule
    public Timeout getTimeout() {
        int scalingFactor = 1;
        try {
            scalingFactor = Integer.parseInt(System.getProperty("timeout.factor"));
        }
        catch (NumberFormatException exception) {
            log.warn("Could not parse timeout.factor, not scaling timeout");
        }
        return new Timeout((long)(scalingFactor * 10), TimeUnit.MINUTES);
    }

    private File createTestDir(String name) {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assert.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        File testDir = new File(baseDir, this.getClass().getName() + "_" + this.testName.getMethodName() + "_" + name);
        FileUtils.deleteQuietly((File)testDir);
        Assert.assertTrue((boolean)testDir.mkdir());
        return testDir;
    }

    private void setCoreSite(MiniAccumuloClusterImpl cluster) throws Exception {
        File csFile = new File(cluster.getConfig().getConfDir(), "core-site.xml");
        if (csFile.exists()) {
            throw new RuntimeException(csFile + " already exist");
        }
        Configuration coreSite = new Configuration(false);
        coreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(cluster.getConfig().getConfDir(), "core-site.xml")));
        coreSite.writeXml((OutputStream)out);
        ((OutputStream)out).close();
    }

    private void updatePeerConfigFromPrimary(MiniAccumuloConfigImpl primaryCfg, MiniAccumuloConfigImpl peerCfg) {
        String credProvider;
        Map primarySiteConfig = primaryCfg.getSiteConfig();
        if ("true".equals(primarySiteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            String truststorePassword;
            HashMap<String, String> peerSiteConfig = new HashMap<String, String>();
            peerSiteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
            String keystorePath = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Keystore Path was null", (Object)keystorePath);
            peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), keystorePath);
            String truststorePath = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PATH.getKey());
            Assert.assertNotNull((String)"Truststore Path was null", (Object)truststorePath);
            peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), truststorePath);
            String keystorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey());
            if (null != keystorePassword) {
                peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), keystorePassword);
            }
            if (null != (truststorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey()))) {
                peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), truststorePassword);
            }
            System.out.println("Setting site configuration for peer " + peerSiteConfig);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
        if (null != (credProvider = (String)primarySiteConfig.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey()))) {
            Map peerSiteConfig = peerCfg.getSiteConfig();
            peerSiteConfig.put(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey(), credProvider);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataIsNotOverReplicated() throws Exception {
        MiniAccumuloClusterImpl master2Cluster;
        MiniAccumuloClusterImpl master1Cluster;
        MiniAccumuloConfigImpl master1Cfg;
        File master1Dir = this.createTestDir("master1");
        File master2Dir = this.createTestDir("master2");
        String password = "password";
        while (true) {
            master1Cfg = new MiniAccumuloConfigImpl(master1Dir, password);
            master1Cfg.setNumTservers(1);
            master1Cfg.setInstanceName("master1");
            ConfigurableMacBase.configureForEnvironment(master1Cfg, this.getClass(), ConfigurableMacBase.getSslDir(master1Dir));
            master1Cfg.setProperty(Property.REPLICATION_NAME, master1Cfg.getInstanceName());
            master1Cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "5M");
            master1Cfg.setProperty(Property.REPLICATION_THREADCHECK, "5m");
            master1Cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
            master1Cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
            master1Cluster = new MiniAccumuloClusterImpl(master1Cfg);
            this.setCoreSite(master1Cluster);
            try {
                master1Cluster.start();
            }
            catch (ZooKeeperBindException e) {
                log.warn("Failed to start ZooKeeper on " + master1Cfg.getZooKeeperPort() + ", will retry");
                continue;
            }
            break;
        }
        while (true) {
            MiniAccumuloConfigImpl master2Cfg = new MiniAccumuloConfigImpl(master2Dir, password);
            master2Cfg.setNumTservers(1);
            master2Cfg.setInstanceName("master2");
            this.updatePeerConfigFromPrimary(master1Cfg, master2Cfg);
            master2Cfg.setProperty(Property.REPLICATION_NAME, master2Cfg.getInstanceName());
            master2Cfg.setProperty(Property.TSERV_WALOG_MAX_SIZE, "5M");
            master2Cfg.setProperty(Property.REPLICATION_THREADCHECK, "5m");
            master2Cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
            master2Cfg.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL, "1s");
            master2Cluster = new MiniAccumuloClusterImpl(master2Cfg);
            this.setCoreSite(master2Cluster);
            try {
                master2Cluster.start();
            }
            catch (ZooKeeperBindException e) {
                log.warn("Failed to start ZooKeeper on " + master2Cfg.getZooKeeperPort() + ", will retry");
                continue;
            }
            break;
        }
        try {
            Connector connMaster1 = master1Cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)password));
            Connector connMaster2 = master2Cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)password));
            String master1UserName = "master1";
            String master1Password = "foo";
            String master2UserName = "master2";
            String master2Password = "bar";
            String master1Table = master1Cluster.getInstanceName();
            String master2Table = master2Cluster.getInstanceName();
            connMaster1.securityOperations().createLocalUser(master1UserName, new PasswordToken((CharSequence)master1Password));
            connMaster2.securityOperations().createLocalUser(master2UserName, new PasswordToken((CharSequence)master2Password));
            connMaster1.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + master2Cluster.getInstanceName(), master2UserName);
            connMaster1.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + master2Cluster.getInstanceName(), master2Password);
            connMaster2.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + master1Cluster.getInstanceName(), master1UserName);
            connMaster2.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + master1Cluster.getInstanceName(), master1Password);
            connMaster1.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + master2Cluster.getInstanceName(), ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)master2Cluster.getInstanceName(), (String)master2Cluster.getZooKeepers())));
            connMaster2.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + master1Cluster.getInstanceName(), ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)master1Cluster.getInstanceName(), (String)master1Cluster.getZooKeepers())));
            connMaster1.tableOperations().create(master1Table, new NewTableConfiguration().withoutDefaultIterators());
            String master1TableId = (String)connMaster1.tableOperations().tableIdMap().get(master1Table);
            Assert.assertNotNull((Object)master1TableId);
            connMaster2.tableOperations().create(master2Table, new NewTableConfiguration().withoutDefaultIterators());
            String master2TableId = (String)connMaster2.tableOperations().tableIdMap().get(master2Table);
            Assert.assertNotNull((Object)master2TableId);
            connMaster1.tableOperations().setProperty(master1Table, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster1.tableOperations().setProperty(master1Table, Property.TABLE_REPLICATION_TARGET.getKey() + master2Cluster.getInstanceName(), master2TableId);
            connMaster2.tableOperations().setProperty(master2Table, Property.TABLE_REPLICATION.getKey(), "true");
            connMaster2.tableOperations().setProperty(master2Table, Property.TABLE_REPLICATION_TARGET.getKey() + master1Cluster.getInstanceName(), master1TableId);
            connMaster1.securityOperations().grantTablePermission(master1UserName, master1Table, TablePermission.WRITE);
            connMaster2.securityOperations().grantTablePermission(master2UserName, master2Table, TablePermission.WRITE);
            IteratorSetting summingCombiner = new IteratorSetting(50, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)summingCombiner, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setCombineAllColumns((IteratorSetting)summingCombiner, (boolean)true);
            connMaster1.tableOperations().attachIterator(master1Table, summingCombiner);
            connMaster2.tableOperations().attachIterator(master2Table, summingCombiner);
            BatchWriter bw = connMaster1.createBatchWriter(master1Table, new BatchWriterConfig());
            Mutation m = new Mutation((CharSequence)"row");
            m.put((CharSequence)"count", (CharSequence)"", (CharSequence)"1");
            bw.addMutation(m);
            bw.close();
            Set files = connMaster1.replicationOperations().referencedFiles(master1Table);
            log.info("Found {} that need replication from master1", (Object)files);
            for (ProcessReference proc : (Collection)master1Cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                master1Cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            master1Cluster.exec(TabletServer.class, new String[0]);
            log.info("Restarted tserver on master1");
            Thread.sleep(1000L);
            Scanner s = connMaster1.createScanner(master1Table, Authorizations.EMPTY);
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            connMaster1.replicationOperations().drain(master1Table, files);
            Thread.sleep(5000L);
            s = connMaster2.createScanner(master2Table, Authorizations.EMPTY);
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            files = connMaster2.replicationOperations().referencedFiles(master2Table);
            for (ProcessReference proc : (Collection)master2Cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                master2Cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            master2Cluster.exec(TabletServer.class, new String[0]);
            Thread.sleep(1000L);
            s = connMaster2.createScanner(master2Table, Authorizations.EMPTY);
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            connMaster2.replicationOperations().drain(master2Table, files);
            Thread.sleep(5000L);
            s = connMaster1.createScanner(master1Table, Authorizations.EMPTY);
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
        }
        finally {
            master1Cluster.stop();
            master2Cluster.stop();
        }
    }
}

