/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class AlterTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getInstance().getConnector(WalkingSecurity.get(state, env).getSysUserName(), WalkingSecurity.get(state, env).getSysToken());
        String tableName = WalkingSecurity.get(state, env).getTableName();
        String namespaceName = WalkingSecurity.get(state, env).getNamespaceName();
        boolean exists = WalkingSecurity.get(state, env).getTableExists();
        boolean hasPermission = WalkingSecurity.get(state, env).canAlterTable(WalkingSecurity.get(state, env).getSysCredentials(), tableName, namespaceName);
        String newTableName = String.format("security_%s_%s_%d", InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_"), env.getPid(), System.currentTimeMillis());
        AlterTable.renameTable(conn, state, env, tableName, newTableName, hasPermission, exists);
    }

    public static void renameTable(Connector conn, State state, Environment env, String oldName, String newName, boolean hasPermission, boolean tableExists) throws AccumuloSecurityException, AccumuloException, TableExistsException {
        try {
            conn.tableOperations().rename(oldName, newName);
        }
        catch (AccumuloSecurityException ae) {
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                if (hasPermission) {
                    throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                }
                return;
            }
            if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_CREDENTIALS) && WalkingSecurity.get(state, env).userPassTransient(conn.whoami())) {
                return;
            }
            throw new AccumuloException("Got unexpected ae error code", (Throwable)ae);
        }
        catch (TableNotFoundException tnfe) {
            if (tableExists) {
                throw new TableExistsException(null, oldName, "Got a TableNotFoundException but it should exist", (Throwable)tnfe);
            }
            return;
        }
        WalkingSecurity.get(state, env).setTableName(newName);
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
    }
}

