/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TabletIT
extends AccumuloClusterHarness {
    private static final int N = 1000;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "128M");
        cfg.setDefaultMemory(256L, MemoryUnit.MEGABYTE);
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void createTableTest() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.createTableTest(tableName, false);
        this.createTableTest(tableName, true);
    }

    public void createTableTest(String tableName, boolean readOnly) throws Exception {
        Connector connector = this.getConnector();
        if (!readOnly) {
            TreeSet<Text> keys = new TreeSet<Text>();
            for (int i = 10; i < 1000; i += 10) {
                keys.add(new Text(String.format("%05d", i)));
            }
            connector.tableOperations().create(tableName);
            connector.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "200");
            connector.tableOperations().addSplits(tableName, keys);
            BatchWriter b = connector.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < 1000; ++i) {
                Mutation m = new Mutation(new Text(String.format("%05d", i)));
                m.put(new Text("col" + Integer.toString(i % 3 + 1)), new Text("qual"), new Value("junk".getBytes(StandardCharsets.UTF_8)));
                b.addMutation(m);
            }
            b.close();
        }
        Scanner scanner = this.getConnector().createScanner(tableName, Authorizations.EMPTY);
        int count = 0;
        for (Map.Entry elt : scanner) {
            String expected = String.format("%05d", count);
            assert (((Key)elt.getKey()).getRow().toString().equals(expected));
            ++count;
        }
        Assert.assertEquals((long)1000L, (long)count);
    }
}

