/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MetadataMaxFilesIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.TSERV_SCAN_MAX_OPENFILES, "10");
        cfg.setProperty(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "100");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test() throws Exception {
        int i;
        Connector c = this.getConnector();
        TreeSet<Text> splits = new TreeSet<Text>();
        for (i = 0; i < 1000; ++i) {
            splits.add(new Text(String.format("%03d", i)));
        }
        c.tableOperations().setProperty("accumulo.metadata", Property.TABLE_SPLIT_THRESHOLD.getKey(), "10000");
        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        for (i = 0; i < 5; ++i) {
            String tableName = "table" + i;
            log.info("Creating " + tableName);
            c.tableOperations().create(tableName);
            log.info("adding splits");
            c.tableOperations().addSplits(tableName, splits);
            log.info("flushing");
            c.tableOperations().flush("accumulo.metadata", null, null, true);
            c.tableOperations().flush("accumulo.root", null, null, true);
        }
        log.info("shutting down");
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        this.cluster.stop();
        log.info("starting up");
        this.cluster.start();
        Credentials creds = new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        while (true) {
            MasterMonitorInfo stats;
            block8: {
                stats = null;
                MasterClientService.Client client = null;
                try {
                    ClientContext context = new ClientContext(c.getInstance(), creds, this.getClientConfig());
                    client = MasterClient.getConnectionWithRetry((ClientContext)context);
                    log.info("Fetching stats");
                    stats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                    if (client == null) break block8;
                }
                catch (Throwable throwable) {
                    if (client == null) throw throwable;
                    MasterClient.close(client);
                    throw throwable;
                }
                MasterClient.close((MasterClientService.Iface)client);
            }
            int tablets = 0;
            for (TabletServerStatus tserver : stats.tServerInfo) {
                for (Map.Entry entry : tserver.tableMap.entrySet()) {
                    if (((String)entry.getKey()).startsWith("!") || ((String)entry.getKey()).startsWith("+")) continue;
                    tablets += ((TableInfo)entry.getValue()).onlineTablets;
                }
            }
            log.info("Online tablets " + tablets);
            if (tablets == 5005) {
                return;
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

