/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeleteEverythingIT
extends AccumuloClusterHarness {
    private String majcDelay;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "1s");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void updateMajcDelay() throws Exception {
        Connector c = this.getConnector();
        this.majcDelay = (String)c.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
        c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1s");
        if (DeleteEverythingIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
            Thread.sleep(AccumuloConfiguration.getTimeInMillis((String)this.majcDelay));
        }
    }

    @After
    public void resetMajcDelay() throws Exception {
        Connector c = this.getConnector();
        c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
    }

    @Test
    public void run() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        BatchWriter bw = this.getConnector().createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation(new Text("foo"));
        m.put(new Text("bar"), new Text("1910"), new Value("5".getBytes(StandardCharsets.UTF_8)));
        bw.addMutation(m);
        bw.flush();
        this.getConnector().tableOperations().flush(tableName, null, null, true);
        FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
        m = new Mutation(new Text("foo"));
        m.putDelete(new Text("bar"), new Text("1910"));
        bw.addMutation(m);
        bw.flush();
        Scanner scanner = this.getConnector().createScanner(tableName, Authorizations.EMPTY);
        scanner.setRange(new Range());
        int count = Iterators.size((Iterator)scanner.iterator());
        Assert.assertEquals((String)("count == " + count), (long)0L, (long)count);
        this.getConnector().tableOperations().flush(tableName, null, null, true);
        this.getConnector().tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1.0");
        UtilWaitThread.sleepUninterruptibly((long)4L, (TimeUnit)TimeUnit.SECONDS);
        FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
        bw.close();
        count = Iterables.size((Iterable)scanner);
        if (count != 0) {
            throw new Exception("count == " + count);
        }
    }
}

