/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(CompactionIT.class);
    private String majcThreadMaxOpen;
    private String majcDelay;
    private String majcMaxConcurrent;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN, "4");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.TSERV_MAJC_MAXCONCURRENT, "1");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void alterConfig() throws Exception {
        if (AccumuloClusterHarness.ClusterType.STANDALONE == CompactionIT.getClusterType()) {
            InstanceOperations iops = this.getConnector().instanceOperations();
            Map config = iops.getSystemConfiguration();
            this.majcThreadMaxOpen = (String)config.get(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey());
            this.majcDelay = (String)config.get(Property.TSERV_MAJC_DELAY.getKey());
            this.majcMaxConcurrent = (String)config.get(Property.TSERV_MAJC_MAXCONCURRENT.getKey());
            iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), "4");
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1");
            iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), "1");
            CompactionIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            CompactionIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @After
    public void resetConfig() throws Exception {
        if (null != this.majcThreadMaxOpen) {
            InstanceOperations iops = this.getConnector().instanceOperations();
            iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), this.majcThreadMaxOpen);
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
            iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), this.majcMaxConcurrent);
            CompactionIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            CompactionIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        final Connector c = this.getConnector();
        final String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1.0");
        FileSystem fs = CompactionIT.getFileSystem();
        Path root = new Path(cluster.getTemporaryPath(), this.getClass().getName());
        Path testrf = new Path(root, "testrf");
        FunctionalTestUtils.createRFiles(c, fs, testrf.toString(), 500000, 59, 4);
        FunctionalTestUtils.bulkImport(c, fs, tableName, testrf.toString());
        int beforeCount = this.countFiles(c);
        final AtomicBoolean fail = new AtomicBoolean(false);
        final ClientConfiguration clientConf = cluster.getClientConfig();
        int THREADS = 5;
        for (int count = 0; count < 5; ++count) {
            ExecutorService executor = Executors.newFixedThreadPool(5);
            int span = 8474;
            for (int i = 0; i < 500000; i += 8474) {
                final int finalI = i;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VerifyIngest.Opts opts = new VerifyIngest.Opts();
                            opts.startRow = finalI;
                            opts.rows = 8474;
                            opts.random = 56;
                            opts.dataSize = 50;
                            opts.cols = 1;
                            opts.setTableName(tableName);
                            if (clientConf.hasSasl()) {
                                opts.updateKerberosCredentials(clientConf);
                            } else {
                                opts.setPrincipal(AccumuloClusterHarness.getAdminPrincipal());
                                PasswordToken passwordToken = (PasswordToken)AccumuloClusterHarness.getAdminToken();
                                opts.setPassword(new ClientOpts.Password(new String(passwordToken.getPassword(), StandardCharsets.UTF_8)));
                            }
                            VerifyIngest.verifyIngest(c, opts, new ScannerOpts());
                        }
                        catch (Exception ex) {
                            log.warn("Got exception verifying data", (Throwable)ex);
                            fail.set(true);
                        }
                    }
                };
                executor.execute(r);
            }
            executor.shutdown();
            executor.awaitTermination(this.defaultTimeoutSeconds(), TimeUnit.SECONDS);
            Assert.assertFalse((String)"Failed to successfully run all threads, Check the test output for error", (boolean)fail.get());
        }
        int finalCount = this.countFiles(c);
        Assert.assertTrue((finalCount < beforeCount ? 1 : 0) != 0);
        try {
            CompactionIT.getClusterControl().adminStopAll();
        }
        finally {
            CompactionIT.getCluster().stop();
            if (AccumuloClusterHarness.ClusterType.STANDALONE == CompactionIT.getClusterType()) {
                CompactionIT.getCluster().start();
            }
        }
    }

    private int countFiles(Connector c) throws Exception {
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(new Text(MetadataSchema.TabletsSection.TabletColumnFamily.NAME));
        s.fetchColumnFamily(new Text(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME));
        return Iterators.size((Iterator)s.iterator());
    }
}

